/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.application.scripting.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.openjdk.jmc.commands.CommandsPlugin;
import org.openjdk.jmc.rcp.application.scripting.model.Line;

public final class Program
extends Observable {
    private final Map<String, Line> m_cache = new HashMap<String, Line>();
    private final List<Line> m_sourceCode = new ArrayList<Line>();

    public synchronized List<Line> getSourceCode() {
        return this.m_sourceCode;
    }

    public synchronized void clear() {
        this.m_sourceCode.clear();
        this.setChanged();
    }

    public synchronized void addLine(String text) {
        Line line = this.m_cache.get(text);
        if (line == null) {
            line = this.createLine(text);
            if (this.m_cache.size() > 100000) {
                this.m_cache.clear();
            }
            this.m_cache.put(text, line);
        }
        this.m_sourceCode.add(line);
        this.setChanged();
    }

    private Line createLine(String text) {
        try {
            CommandsPlugin.getDefault().parse(text);
            return new Line(text, null);
        }
        catch (ParseException e) {
            return new Line(text, e.getMessage());
        }
    }

    public synchronized Line getLine(int position) {
        return this.m_sourceCode.get(position);
    }

    public synchronized int getLineCount() {
        return this.m_sourceCode.size();
    }

    public synchronized List<String> getSourceLines() {
        ArrayList<String> sourceLines = new ArrayList<String>();
        for (Line l : this.getSourceCode()) {
            sourceLines.add(l.getSource());
        }
        return sourceLines;
    }
}

