/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.preferences;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.openjdk.jmc.rjmx.preferences.JMXRMIPreferences;
import org.openjdk.jmc.rjmx.ui.preferences.Messages;
import org.openjdk.jmc.ui.common.security.SecurityManagerFactory;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.PasswordFieldEditor;

public class JMXRMIPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Label clearLabel;
    private boolean pageUnlocked;
    private volatile boolean doClearPrefs;
    private final PreferenceStore store = new PreferenceStore(){

        public void save() throws IOException {
            try {
                if (this.allPrefsEmpty() || JMXRMIPreferencePage.this.doClearPrefs) {
                    JMXRMIPreferences.getInstance().remove();
                } else {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.save(baos, null);
                    JMXRMIPreferences.getInstance().set(baos.toByteArray());
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        public boolean needsSaving() {
            return JMXRMIPreferencePage.this.doClearPrefs || super.needsSaving();
        }

        private boolean allPrefsEmpty() {
            String[] stringArray = this.preferenceNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String val = this.getString(key);
                if (val != null && !val.isEmpty()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    };
    private final List<FieldEditor> fields = new ArrayList<FieldEditor>(4);

    public JMXRMIPreferencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)this.store);
        this.setDescription(Messages.JMXRMIPreferencePage_DESCRIPTION);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        if (!this.pageUnlocked && JMXRMIPreferences.getInstance().exists()) {
            this.clearLabel.setVisible(true);
            this.getFieldEditorParent().layout();
            this.doClearPrefs = true;
        }
    }

    protected void createFieldEditors() {
        boolean bl = this.pageUnlocked = !SecurityManagerFactory.getSecurityManager().isLocked();
        if (this.pageUnlocked) {
            this.unlockAndLoadPage();
        }
        this.doAddFieldEditor((FieldEditor)new FileFieldEditor("javax.net.ssl.keyStore", Messages.JMXRMIPreferencePage_CAPTION_KEY_STORE, this.getFieldEditorParent()));
        this.doAddFieldEditor((FieldEditor)new PasswordFieldEditor("javax.net.ssl.keyStorePassword", Messages.JMXRMIPreferencePage_CAPTION_KEY_STORE_PASSWORD, this.getFieldEditorParent()));
        this.doAddFieldEditor((FieldEditor)new FileFieldEditor("javax.net.ssl.trustStore", Messages.JMXRMIPreferencePage_CAPTION_TRUST_STORE, this.getFieldEditorParent()));
        this.doAddFieldEditor((FieldEditor)new PasswordFieldEditor("javax.net.ssl.trustStorePassword", Messages.JMXRMIPreferencePage_CAPTION_TRUST_STORE_PASSWORD, this.getFieldEditorParent()));
        final Button unlockButton = new Button(this.getFieldEditorParent(), 0);
        unlockButton.setText(Messages.JMXRMIPreferencePage_UNLOCK_BUTTON_TEXT);
        unlockButton.setEnabled(!this.pageUnlocked);
        unlockButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (JMXRMIPreferencePage.this.unlockAndLoadPage()) {
                    for (FieldEditor fe : JMXRMIPreferencePage.this.fields) {
                        fe.setEnabled(true, JMXRMIPreferencePage.this.getFieldEditorParent());
                    }
                    JMXRMIPreferencePage.this.initialize();
                    unlockButton.setEnabled(false);
                    JMXRMIPreferencePage.this.clearLabel.setVisible(false);
                    JMXRMIPreferencePage.this.doClearPrefs = false;
                }
            }
        });
        this.clearLabel = new Label(this.getFieldEditorParent(), 0);
        this.clearLabel.setText(Messages.JMXRMIPreferencePage_CLEAR_SETTINGS_WARNING);
        this.clearLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        this.clearLabel.setForeground(JFaceColors.getErrorText((Display)this.clearLabel.getDisplay()));
        this.clearLabel.setVisible(false);
    }

    public boolean performCancel() {
        this.doClearPrefs = false;
        return super.performCancel();
    }

    private void doAddFieldEditor(FieldEditor field) {
        field.setEnabled(this.pageUnlocked, this.getFieldEditorParent());
        this.fields.add(field);
        this.addField(field);
    }

    private boolean unlockAndLoadPage() {
        try {
            SecurityManagerFactory.getSecurityManager().unlock();
            byte[] value = JMXRMIPreferences.getInstance().get();
            if (value != null) {
                this.store.load((InputStream)new ByteArrayInputStream(value));
            }
            this.pageUnlocked = true;
            return true;
        }
        catch (Exception e) {
            DialogToolkit.showException((Shell)this.getFieldEditorParent().getShell(), (String)Messages.JMXRMIPreferencePage_LOAD_CONTENT_FAILED_TITLE, (String)Messages.JMXRMIPreferencePage_LOAD_CONTENT_FAILED_TEXT, (Throwable)e);
            return false;
        }
    }
}

