/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.editor.internal;

import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.openjdk.jmc.console.ui.ConsolePlugin;
import org.openjdk.jmc.console.ui.editor.IConsolePageContainer;
import org.openjdk.jmc.console.ui.editor.IConsolePageStateHandler;
import org.openjdk.jmc.console.ui.editor.internal.ConsoleEditor;
import org.openjdk.jmc.console.ui.editor.internal.ShowTabStateAction;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.ui.common.util.Environment;
import org.openjdk.jmc.ui.misc.MementoToolkit;
import org.osgi.service.prefs.Preferences;

public class ConsoleFormPage
extends FormPage
implements IConsolePageContainer {
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_ICON = "icon";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String HELP_CONTEXT_ID = "helpContextID";
    private IMemento defaultConfig;
    private String id;
    private Image icon;
    private String helpContextID;
    @Inject
    private IConnectionHandle connectionHandle;
    private IConsolePageStateHandler stateHandler;

    public ConsoleFormPage() {
        super(null, "", "");
    }

    @Override
    public ConsoleEditor getEditor() {
        return (ConsoleEditor)super.getEditor();
    }

    @Override
    public Composite getBody() {
        return this.getManagedForm().getForm().getBody();
    }

    public IConnectionHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        Form form = managedForm.getForm().getForm();
        managedForm.getToolkit().decorateFormHeading(form);
        form.setText(this.getTitle());
        form.setImage(this.getTitleImage());
        this.validateDependencies();
        IToolBarManager toolBar = managedForm.getForm().getToolBarManager();
        toolBar.add((IContributionItem)new GroupMarker("first"));
        toolBar.add((IContributionItem)new GroupMarker("help"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)managedForm.getForm(), this.helpContextID);
        if (Environment.isDebug()) {
            toolBar.add((IAction)new ShowTabStateAction(this));
        }
        toolBar.update(true);
    }

    private void setHelpContextID(String contextID) {
        this.helpContextID = contextID;
    }

    protected void validateDependencies() {
    }

    @Override
    public IMemento loadConfig() {
        try {
            return XMLMemento.createReadRoot((Reader)new StringReader(this.getServerConfiguration().get(this.getId(), "")));
        }
        catch (Exception exception) {
            return this.defaultConfig;
        }
    }

    @Override
    public IMemento getDefaultConfig() {
        return this.defaultConfig;
    }

    public String getId() {
        return this.id;
    }

    public Image getTitleImage() {
        return this.icon;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        String iconName;
        super.setInitializationData(config, propertyName, data);
        this.id = config.getAttribute(ATTRIBUTE_ID);
        this.setHelpContextID(config.getAttribute(HELP_CONTEXT_ID));
        this.defaultConfig = XMLMemento.createWriteRoot((String)this.id);
        IConfigurationElement[] ce = config.getChildren(ATTRIBUTE_CLASS);
        if (ce.length == 1) {
            MementoToolkit.copy((IConfigurationElement)ce[0], (IMemento)this.defaultConfig);
        }
        if ((iconName = config.getAttribute(ATTRIBUTE_ICON)) != null) {
            String pluginId = config.getDeclaringExtension().getContributor().getName();
            ImageDescriptor iconDesc = ResourceLocator.imageDescriptorFromBundle((String)pluginId, (String)iconName).orElse(null);
            if (iconDesc != null) {
                this.icon = (Image)JFaceResources.getResources().get((DeviceResourceDescriptor)iconDesc);
            } else {
                ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Could not load icon " + iconName + " for plug-in " + pluginId);
            }
        }
    }

    public void dispose() {
        if (this.stateHandler != null) {
            XMLMemento state = XMLMemento.createWriteRoot((String)this.getId());
            if (this.stateHandler.saveState((IMemento)state)) {
                this.getServerConfiguration().put(this.getId(), MementoToolkit.asString((XMLMemento)state));
            }
            this.stateHandler.dispose();
        }
        super.dispose();
    }

    protected boolean saveState(IMemento state) {
        if (this.stateHandler != null) {
            return this.stateHandler.saveState(state);
        }
        return false;
    }

    public void setContentStateHandler(IConsolePageStateHandler handler) {
        this.stateHandler = handler;
    }

    private Preferences getServerConfiguration() {
        return RJMXPlugin.getDefault().getServerPreferences(this.getConnectionHandle().getServerDescriptor().getGUID());
    }

    @Override
    public void presentError(final String message) {
        final IMessageManager manager = this.getManagedForm().getMessageManager();
        Display display = this.getSite().getShell().getDisplay();
        if (!display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    manager.addMessage((Object)message, message, null, 3);
                }
            });
        }
    }
}

