/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.idesupport;

import java.io.File;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.openjdk.jmc.ui.common.util.Filename;
import org.openjdk.jmc.ui.idesupport.Messages;
import org.openjdk.jmc.ui.misc.DialogToolkit;

public class IDESupportUIToolkit {
    private IDESupportUIToolkit() {
    }

    public static File browseForSaveAsFile(String title, File suggestedFile, String requiredExt, String description) {
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        File parent = suggestedFile.getParentFile();
        if (parent != null && parent.isDirectory()) {
            dialog.setFilterPath(parent.getAbsolutePath());
        }
        String reqFileEnding = "";
        if (requiredExt != null) {
            dialog.setFilterExtensions(new String[]{"*." + requiredExt});
            reqFileEnding = "." + requiredExt;
        }
        dialog.setFileName(suggestedFile.getName());
        dialog.setText(title);
        String file = dialog.open();
        if (file == null) {
            return null;
        }
        if (!file.endsWith(reqFileEnding)) {
            file = String.valueOf(file) + reqFileEnding;
        }
        return new File(file);
    }

    public static File browseForOpenFile(String title, File suggestedFile) {
        String fileExt;
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        File parent = suggestedFile.getParentFile();
        if (parent != null && parent.isDirectory()) {
            dialog.setFilterPath(parent.getAbsolutePath());
        }
        if (!(fileExt = Filename.splitFilename((String)suggestedFile.getName()).getExtension()).isEmpty()) {
            dialog.setFilterExtensions(new String[]{"*." + fileExt});
        }
        dialog.setText(title);
        String file = dialog.open();
        if (file != null) {
            return new File(file);
        }
        return null;
    }

    public static boolean checkAlreadyExists(File theFile) {
        if (theFile.exists()) {
            return !DialogToolkit.openQuestionOnUiThread(Messages.BasicIDESupport_FILE_ALREADY_EXISTS_TITLE, String.valueOf(Messages.BasicIDESupport_FILE_ALREADY_MESSAGE_TEXT) + '\n' + theFile.getAbsolutePath());
        }
        return false;
    }
}

