/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.action;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.console.ui.notification.action.Messages;
import org.openjdk.jmc.console.ui.notification.action.WriteAndOpenRecordingJob;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.services.jfr.FlightRecorderException;
import org.openjdk.jmc.rjmx.services.jfr.FlightRecorderToolkit;
import org.openjdk.jmc.rjmx.services.jfr.IFlightRecorderService;
import org.openjdk.jmc.rjmx.triggers.TriggerAction;
import org.openjdk.jmc.rjmx.triggers.TriggerEvent;
import org.openjdk.jmc.ui.common.idesupport.IDESupportToolkit;
import org.openjdk.jmc.ui.common.resource.MCFile;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class TriggerActionDumpRecording
extends TriggerAction {
    public void handleNotificationEvent(final TriggerEvent event) {
        final IFlightRecorderService service = (IFlightRecorderService)event.getSource().getServiceOrNull(IFlightRecorderService.class);
        if (service == null) {
            RJMXPlugin.getDefault().getLogger().severe("There is no flight recorder available on the " + event.getSource() + " JVM");
            return;
        }
        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Job job = TriggerActionDumpRecording.this.createDumpFlightRecordingJob(event, service);
                job.schedule();
            }
        });
    }

    protected Job createDumpFlightRecordingJob(TriggerEvent event, IFlightRecorderService service) {
        MCFile path = IDESupportToolkit.createFileResource((String)this.getSetting("file").getFileName());
        IQuantity timerange = this.getSetting("timerange").getQuantity();
        Boolean open = this.getSetting("open").getBoolean();
        return new WriteAndOpenRecordingJob(NLS.bind((String)Messages.TriggerActionDumpRecording_DUMPING_JOB_NAME, (Object)event.getRule().getName()), event.getSource().getServerDescriptor().getDisplayName(), service, path, timerange, open, event);
    }

    public boolean supportsAction(IConnectionHandle handle) {
        IFlightRecorderService jfrService = (IFlightRecorderService)handle.getServiceOrNull(IFlightRecorderService.class);
        try {
            return jfrService != null && jfrService.isEnabled() && FlightRecorderToolkit.getDescriptorByTimerange((List)jfrService.getAvailableRecordings(), (IQuantity)UnitLookup.MILLISECOND.quantity(0L)) != null;
        }
        catch (FlightRecorderException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Got exception when checking for available recordings in JVM", e);
            return false;
        }
    }
}

