/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.security;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.ui.common.security.ISecurityManager;

public final class SecurityManagerFactory {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.ui.common.security");
    private static ISecurityManager instance;

    static {
        String className = System.getProperty("org.openjdk.jmc.common.security.manager");
        try {
            if (className != null) {
                Class<?> c = Class.forName(className);
                instance = (ISecurityManager)c.newInstance();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not create Security manager for className. Using default! Exception was:", e);
        }
    }

    public static final synchronized void setDefaultSecurityManager(ISecurityManager manager) {
        if (instance == null) {
            instance = manager;
        }
    }

    public static final synchronized ISecurityManager getSecurityManager() {
        return instance;
    }

    private SecurityManagerFactory() {
        throw new AssertionError((Object)"This class is not to be instantiated!");
    }
}

