/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.awt.Graphics2D;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.ui.charts.AWTChartToolkit;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.misc.AwtCanvas;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.PatternFly;

public class TimelineCanvas
extends Canvas {
    private static final int BASE_RANGE_INDICATOR_HEIGHT = 10;
    private static final int BASE_RANGE_INDICATOR_Y_OFFSET = 25;
    private int rangeIndicatorHeight;
    private int rangeIndicatorYOffset;
    private int x1;
    private int x2;
    private int xOffset;
    private AwtCanvas awtCanvas;
    private ChartCanvas chartCanvas;
    private Graphics2D g2d;
    private IRange<IQuantity> chartRange;
    private Rectangle dragRect;
    private Rectangle indicatorRect;
    private Rectangle timelineRect;
    private SashForm sashForm;
    private SubdividedQuantityRange xTickRange;
    private XYChart chart;

    public TimelineCanvas(Composite parent, ChartCanvas chartCanvas, SashForm sashForm, double yScale) {
        super(parent, 0);
        this.chartCanvas = chartCanvas;
        this.sashForm = sashForm;
        this.awtCanvas = new AwtCanvas();
        this.addPaintListener(new TimelineCanvasPainter());
        DragDetector dragDetector = new DragDetector();
        this.addMouseListener((MouseListener)dragDetector);
        this.addMouseMoveListener(dragDetector);
        this.rangeIndicatorHeight = (int)(10.0 * yScale);
        this.rangeIndicatorYOffset = (int)(25.0 * yScale);
    }

    private int calculateXOffset() {
        return this.sashForm.getChildren()[0].getSize().x + this.sashForm.getSashWidth();
    }

    public void renderRangeIndicator(int x1, int x2) {
        this.x1 = x1;
        this.x2 = x2;
        this.redraw();
    }

    public void setXTickRange(SubdividedQuantityRange xTickRange) {
        this.xTickRange = xTickRange;
    }

    public void setChart(XYChart chart) {
        this.chart = chart;
        this.chartRange = chart.getVisibleRange();
    }

    private class DragDetector
    extends MouseAdapter
    implements MouseMoveListener {
        boolean isDrag = false;
        Point currentSelection;
        Point lastSelection;

        private DragDetector() {
        }

        public void mouseDown(MouseEvent e) {
            e.x = TimelineCanvas.this.chartCanvas.translateDisplayToImageXCoordinates(e.x);
            e.y = TimelineCanvas.this.chartCanvas.translateDisplayToImageYCoordinates(e.y);
            if (this.isDrag || e.button == 1 && TimelineCanvas.this.timelineRect.contains(e.x, e.y)) {
                this.isDrag = true;
                this.currentSelection = new Point(e.x, e.y);
            }
        }

        public void mouseUp(MouseEvent e) {
            this.isDrag = false;
            TimelineCanvas.this.chart.setIsZoomPanDrag(false);
        }

        public void mouseMove(MouseEvent e) {
            e.x = TimelineCanvas.this.chartCanvas.translateDisplayToImageXCoordinates(e.x);
            e.y = TimelineCanvas.this.chartCanvas.translateDisplayToImageYCoordinates(e.y);
            if (TimelineCanvas.this.timelineRect.contains(e.x, e.y)) {
                TimelineCanvas.this.setCursor(TimelineCanvas.this.getDisplay().getSystemCursor(21));
            } else {
                TimelineCanvas.this.setCursor(TimelineCanvas.this.getDisplay().getSystemCursor(0));
            }
            if (this.isDrag) {
                this.lastSelection = this.currentSelection;
                TimelineCanvas.this.chart.setIsZoomPanDrag(true);
                this.currentSelection = new Point(e.x, e.y);
                int xdiff = this.currentSelection.x - this.lastSelection.x;
                this.updateTimelineIndicatorFromDrag(xdiff);
            }
        }

        private void updateTimelineIndicatorFromDrag(int xdiff) {
            if (xdiff != 0 && ((TimelineCanvas)TimelineCanvas.this).indicatorRect.x + xdiff >= ((TimelineCanvas)TimelineCanvas.this).timelineRect.x && ((TimelineCanvas)TimelineCanvas.this).indicatorRect.x + xdiff + ((TimelineCanvas)TimelineCanvas.this).indicatorRect.width <= ((TimelineCanvas)TimelineCanvas.this).timelineRect.x + ((TimelineCanvas)TimelineCanvas.this).timelineRect.width) {
                ((TimelineCanvas)TimelineCanvas.this).indicatorRect.x += xdiff;
                SubdividedQuantityRange xAxis = new SubdividedQuantityRange((IQuantity)TimelineCanvas.this.chartRange.getStart(), (IQuantity)TimelineCanvas.this.chartRange.getEnd(), ((TimelineCanvas)TimelineCanvas.this).timelineRect.width, 1);
                TimelineCanvas.this.chart.setVisibleRange(xAxis.getQuantityAtPixel(((TimelineCanvas)TimelineCanvas.this).indicatorRect.x - TimelineCanvas.this.xOffset), xAxis.getQuantityAtPixel(((TimelineCanvas)TimelineCanvas.this).indicatorRect.x - TimelineCanvas.this.xOffset + ((TimelineCanvas)TimelineCanvas.this).indicatorRect.width));
                TimelineCanvas.this.dragRect = TimelineCanvas.this.indicatorRect;
                TimelineCanvas.this.chartCanvas.redrawChart();
            }
        }
    }

    private class TimelineCanvasPainter
    implements PaintListener {
        private TimelineCanvasPainter() {
        }

        public void paintControl(PaintEvent e) {
            TimelineCanvas.this.xOffset = TimelineCanvas.this.chartCanvas.translateDisplayToImageXCoordinates(TimelineCanvas.this.calculateXOffset());
            Rectangle rect = TimelineCanvas.this.getClientArea();
            TimelineCanvas.this.g2d = TimelineCanvas.this.awtCanvas.getGraphics(rect.width, rect.height);
            Point adjusted = TimelineCanvas.this.chartCanvas.translateDisplayToImageCoordinates(rect.width, rect.height);
            TimelineCanvas.this.g2d.setColor(PatternFly.Palette.PF_BLACK_100.getAWTColor());
            TimelineCanvas.this.g2d.fillRect(0, 0, adjusted.x, adjusted.y);
            if (TimelineCanvas.this.xTickRange != null) {
                TimelineCanvas.this.g2d.setColor(PatternFly.Palette.PF_BLACK.getAWTColor());
                AWTChartToolkit.drawAxis(TimelineCanvas.this.g2d, TimelineCanvas.this.xTickRange, 0, false, 1, false, TimelineCanvas.this.xOffset);
            }
            TimelineCanvas.this.indicatorRect = TimelineCanvas.this.dragRect != null ? TimelineCanvas.this.dragRect : new Rectangle(TimelineCanvas.this.x1 + TimelineCanvas.this.xOffset, TimelineCanvas.this.chartCanvas.translateDisplayToImageYCoordinates(TimelineCanvas.this.rangeIndicatorYOffset), TimelineCanvas.this.x2 - TimelineCanvas.this.x1, TimelineCanvas.this.chartCanvas.translateDisplayToImageYCoordinates(TimelineCanvas.this.rangeIndicatorHeight));
            TimelineCanvas.this.dragRect = null;
            TimelineCanvas.this.g2d.setPaint(PatternFly.Palette.PF_ORANGE_400.getAWTColor());
            TimelineCanvas.this.g2d.fillRect(((TimelineCanvas)TimelineCanvas.this).indicatorRect.x, ((TimelineCanvas)TimelineCanvas.this).indicatorRect.y, ((TimelineCanvas)TimelineCanvas.this).indicatorRect.width, ((TimelineCanvas)TimelineCanvas.this).indicatorRect.height);
            Point totalSize = TimelineCanvas.this.sashForm.getChildren()[1].getSize();
            adjusted = TimelineCanvas.this.chartCanvas.translateDisplayToImageCoordinates(totalSize.x, totalSize.y);
            TimelineCanvas.this.timelineRect = new Rectangle(TimelineCanvas.this.xOffset, TimelineCanvas.this.chartCanvas.translateDisplayToImageYCoordinates(TimelineCanvas.this.rangeIndicatorYOffset), adjusted.x, TimelineCanvas.this.chartCanvas.translateDisplayToImageYCoordinates(TimelineCanvas.this.rangeIndicatorHeight));
            TimelineCanvas.this.g2d.setPaint(PatternFly.Palette.PF_BLACK_600.getAWTColor());
            TimelineCanvas.this.g2d.drawRect(((TimelineCanvas)TimelineCanvas.this).timelineRect.x, ((TimelineCanvas)TimelineCanvas.this).timelineRect.y, ((TimelineCanvas)TimelineCanvas.this).timelineRect.width, ((TimelineCanvas)TimelineCanvas.this).timelineRect.height);
            TimelineCanvas.this.awtCanvas.paint(e, 0, 0);
        }
    }
}

