/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.browser.attach;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openjdk.jmc.attach.AttachToolkit;
import org.openjdk.jmc.browser.attach.BrowserAttachPlugin;
import org.openjdk.jmc.browser.attach.LocalJVMToolkit;
import org.openjdk.jmc.browser.attach.Messages;
import org.openjdk.jmc.rjmx.descriptorprovider.AbstractDescriptorProvider;
import org.openjdk.jmc.rjmx.descriptorprovider.IDescriptorListener;

public class LocalDescriptorProvider
extends AbstractDescriptorProvider {
    private static final long LOCAL_REFRESH_INTERVAL = 5000L;
    private LocalScanner scanner;
    private Thread scannerThread;
    private static final LocalDescriptorProvider instance = new LocalDescriptorProvider();
    private final Map<Integer, LocalJVMToolkit.DiscoveryEntry> lastDescriptors = new HashMap<Integer, LocalJVMToolkit.DiscoveryEntry>();

    private LocalDescriptorProvider() {
    }

    public String getName() {
        return Messages.LocalDescriptorProvider_PROVIDER_NAME;
    }

    public String getDescription() {
        return Messages.LocalDescriptorProvider_PROVIDER_DESCRIPTION;
    }

    private void initialize() {
        if (!AttachToolkit.isLocalAttachAvailable()) {
            BrowserAttachPlugin.getPluginLogger().warning("Could not find the classes needed to support attach. Attaching to local JVMs will be disabled! This will happen if you're not running Mission Control with a JDK, because the JDK tools.jar is needed for attach. In JDK 9 the java.management and jdk.attach modules are required. Run with logging set to FINE for more information.");
            return;
        }
        this.scanner = new LocalScanner();
        this.scannerThread = new Thread((Runnable)this.scanner, "Local Descriptor Scanner");
        this.scannerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptorListener(IDescriptorListener l) {
        List list = this.m_descriptorListeners;
        synchronized (list) {
            if (this.m_descriptorListeners.size() == 0) {
                super.addDescriptorListener(l);
                this.initialize();
            } else {
                super.addDescriptorListener(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDescriptorListener(IDescriptorListener l) {
        List list = this.m_descriptorListeners;
        synchronized (list) {
            super.removeDescriptorListener(l);
            if (this.m_descriptorListeners.size() == 0 && this.scanner != null) {
                this.scanner.shutdown();
                this.scannerThread.interrupt();
            }
        }
    }

    public void shutdown() {
        this.scanner.shutdown();
    }

    public static LocalDescriptorProvider getInstance() {
        return instance;
    }

    private class LocalScanner
    implements Runnable {
        boolean isRunning;

        private LocalScanner() {
        }

        @Override
        public void run() {
            this.isRunning = true;
            while (this.isRunning) {
                try {
                    this.scan();
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void shutdown() {
            this.isRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scan() {
            LocalJVMToolkit.DiscoveryEntry[] props;
            HashMap<Integer, LocalJVMToolkit.DiscoveryEntry> newOnes = new HashMap<Integer, LocalJVMToolkit.DiscoveryEntry>();
            LocalJVMToolkit.DiscoveryEntry[] discoveryEntryArray = props = LocalJVMToolkit.getAttachableJVMs();
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                LocalJVMToolkit.DiscoveryEntry prop = discoveryEntryArray[n2];
                newOnes.put(prop.getServerDescriptor().getJvmInfo().getPid(), prop);
                ++n2;
            }
            Map<Integer, LocalJVMToolkit.DiscoveryEntry> map = LocalDescriptorProvider.this.lastDescriptors;
            synchronized (map) {
                LocalJVMToolkit.DiscoveryEntry d;
                Iterator<Map.Entry<Integer, LocalJVMToolkit.DiscoveryEntry>> entryIterator = LocalDescriptorProvider.this.lastDescriptors.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry<Integer, LocalJVMToolkit.DiscoveryEntry> entry = entryIterator.next();
                    if (newOnes.containsKey(entry.getKey())) continue;
                    d = entry.getValue();
                    entryIterator.remove();
                    LocalDescriptorProvider.this.onDescriptorRemoved(d.getServerDescriptor().getGUID());
                }
                for (Map.Entry entry : newOnes.entrySet()) {
                    if (LocalDescriptorProvider.this.lastDescriptors.containsKey(entry.getKey())) continue;
                    d = (LocalJVMToolkit.DiscoveryEntry)entry.getValue();
                    LocalDescriptorProvider.this.onDescriptorDetected(d.getServerDescriptor(), null, null, d.getConnectionDescriptor());
                }
                LocalDescriptorProvider.this.lastDescriptors.clear();
                LocalDescriptorProvider.this.lastDescriptors.putAll(newOnes);
            }
        }
    }
}

