/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow;

import java.io.File;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmc.joverflow.batch.BatchProblemRecorder;
import org.openjdk.jmc.joverflow.batch.DetailedStats;
import org.openjdk.jmc.joverflow.batch.ReportFormatter;
import org.openjdk.jmc.joverflow.codeanalysis.DupStringFieldFinder;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.parser.DumpCorruptedException;
import org.openjdk.jmc.joverflow.heap.parser.HeapDumpReader;
import org.openjdk.jmc.joverflow.heap.parser.HprofParsingCancelledException;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;
import org.openjdk.jmc.joverflow.stats.LongLivedStringClustersCalculator;
import org.openjdk.jmc.joverflow.stats.StandardStatsCalculator;
import org.openjdk.jmc.joverflow.support.DupStringStats;
import org.openjdk.jmc.joverflow.support.HeapStats;
import org.openjdk.jmc.joverflow.util.FileUtils;
import org.openjdk.jmc.joverflow.util.MemNumFormatter;
import org.openjdk.jmc.joverflow.util.ProgressMeter;
import org.openjdk.jmc.joverflow.util.Utils;
import org.openjdk.jmc.joverflow.util.VerboseOutputCollector;

public class Main {
    private static final String VERSION = "0.8";
    private static final String USAGE = "Usage: joverflow <options> heap_dump_file\n\nwhere options include\n  -verbose          Print verbose diagnostic messages if problems\n           occur when parsing heap dump file, etc.\n  -depth_first, -dfs    Use depth-first heap scan (default)\n  -breadth_first, -bfs  Use breadth-first heap scan (slower but produces\n           generally shorter and more useful reference chains)\n  -full_obj_histo   Print full object histogram\n           (normally only top memory consumers are printed)\n  -ref_chain_depth=<n> Print up to n elements in reverse reference\n           chains leading to problematic objects (default is 8)\n  -ref_chain_stoppers=<prefix1,prefix2,...> Stop printing a reference\n           chain when class starting with any of prefixes is reached\n           (default is oracle.apps.)  -pointer_size=<size in bytes>   Explicitly specify JVM pointer size\n           to be used in calculations. Makes sense for 64-bit heap dumps.\n  -use_mmap         Use mmap to access data on disk during heap analysis\n           (default is JOverflow's own custom disk cache)";
    private static final int MIN_OVHD_TO_REPORT_AS_HEAP_FRACTION = 1000;
    private static String[] refChainStopperClassPrefixes = new String[]{"oracle.apps."};
    private static boolean printFullObjectHistogram;
    private static int printedRefChainDepth;
    private static int explicitPointerSize;
    private static boolean useMmap;
    private static boolean useBreadthFirst;
    private static boolean findLongLivedStrings;
    private static File stringsToInternTextFile;
    private static boolean verbose;
    private static long startTime0;
    private static long startTime1;
    private static long snapshotReadTimeMs;

    static {
        printedRefChainDepth = 8;
    }

    public static void main(String[] args) throws Exception {
        System.err.println("JOverflow version 0.8");
        ArrayList<String> dumpFileNames = new ArrayList<String>();
        ArrayList<String> classpath = new ArrayList<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.charAt(0) == '-') {
                if (arg.equals("-help")) {
                    System.out.println(USAGE);
                } else if (arg.equals("-verbose")) {
                    verbose = true;
                } else if (arg.equals("-full_obj_histo")) {
                    printFullObjectHistogram = true;
                } else if (arg.startsWith("-ref_chain_depth=")) {
                    printedRefChainDepth = Main.parseNumericFlag(arg);
                } else if (arg.startsWith("-ref_chain_stoppers=")) {
                    refChainStopperClassPrefixes = Main.parseCommaSeparatedStringsFlag(arg);
                } else if (arg.startsWith("-pointer_size=")) {
                    explicitPointerSize = Main.parseNumericFlag(arg);
                } else if (arg.equals("-use_mmap")) {
                    useMmap = true;
                } else if (arg.equals("-depth_first") || arg.equals("-dfs")) {
                    useBreadthFirst = false;
                } else if (arg.equals("-breadth_first") || arg.equals("-bfs")) {
                    useBreadthFirst = true;
                } else if (arg.equals("-long_lived_strings")) {
                    findLongLivedStrings = true;
                } else if (arg.startsWith("-print_string_fields_to_intern=")) {
                    stringsToInternTextFile = Main.parseFileNameFlag(arg);
                } else {
                    System.err.println("Unknown flag: " + arg);
                    System.exit(-1);
                }
            } else if (arg.endsWith(".txt")) {
                File jarListFile = FileUtils.fileExistsAndReadableOrExit(arg);
                classpath.addAll(FileUtils.readTextFile(jarListFile));
            } else if (arg.endsWith(".jar")) {
                classpath.add(arg);
            } else {
                FileUtils.fileExistsAndReadableOrExit(arg);
                dumpFileNames.add(arg);
            }
            ++n2;
        }
        if (dumpFileNames.isEmpty()) {
            System.err.println("No dump file specified");
            System.exit(-1);
        }
        VerboseOutputCollector vc = new VerboseOutputCollector();
        if (findLongLivedStrings) {
            if (dumpFileNames.size() <= 1) {
                System.err.println("-string_fields_to_intern requires more than one dump file");
                System.exit(-1);
            }
            Main.generateLongLivedStringsReport(dumpFileNames, vc);
        } else {
            if (dumpFileNames.size() > 1) {
                System.err.println("More than one dump file specified: " + dumpFileNames);
                System.exit(-1);
            }
            String fileName = dumpFileNames.get(0);
            Main.checkFileAndGetSize(fileName);
            Snapshot snapshot = Main.readSnapshot(fileName, vc);
            Main.generateStandardReport(snapshot, classpath);
        }
    }

    private static void generateStandardReport(Snapshot snapshot, ArrayList<String> classpath) {
        List<String> warnings;
        ReportFormatter rf = Main.calculateAndFormatStandardStats(snapshot);
        long endTime = System.currentTimeMillis();
        long heapAnalysisTimeMs = endTime - startTime1;
        if (stringsToInternTextFile != null) {
            System.err.println("Storing info on String fields to intern into " + stringsToInternTextFile.getName());
            List<String> fieldsToIntern = DupStringFieldFinder.getFieldsToInternAsText(rf.getHeapStats(), rf.getDetailedStats());
            try {
                FileUtils.writeTextToFile(stringsToInternTextFile, fieldsToIntern);
            }
            catch (IOException ex) {
                System.err.println("Could not write to file " + stringsToInternTextFile.getName() + ": " + ex.getMessage());
            }
        }
        long totalTimeMs = endTime - startTime0;
        int heapAnalysisTimeSec = (int)(heapAnalysisTimeMs / 1000L);
        int totalTimeSec = (int)(totalTimeMs / 1000L);
        System.err.println("\rDone. Heap analysis time: " + heapAnalysisTimeSec + " sec, total time: " + totalTimeSec + " sec");
        VerboseOutputCollector vc = snapshot.getVerboseOutputCollector();
        if (verbose && !(warnings = vc.getWarnings()).isEmpty()) {
            for (String warning : warnings) {
                System.err.println(warning);
            }
        }
        System.out.println(rf.getReport(printFullObjectHistogram, printedRefChainDepth, refChainStopperClassPrefixes));
        System.out.println("\nSnapshot read time: " + snapshotReadTimeMs / 1000L + " sec");
        System.out.println("Heap analysis time: " + heapAnalysisTimeSec + " sec");
        System.out.println("Total time: " + totalTimeSec + " sec");
        System.out.print("GC time: ");
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            System.out.print(String.valueOf(gcBean.getName()) + " " + gcBean.getCollectionTime() + " ms  ");
        }
        System.out.println();
        System.gc();
        long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.out.println("Used memory: " + usedMemory / 1024L / 1024L + "M");
        List<String> warningKinds = vc.getWarningKinds();
        if (!warningKinds.isEmpty()) {
            System.err.print("Note: there were some warning(s) of kind ");
            for (String warning : warningKinds) {
                System.err.print(warning);
                System.err.print(", ");
            }
            System.err.println("\nRun the tool with -verbose to get more details");
        }
    }

    private static void generateLongLivedStringsReport(ArrayList<String> fileNames, VerboseOutputCollector vc) throws IOException, HprofParsingCancelledException {
        System.err.println("Comparing heap dumps to find long-living string clusters...");
        final LongLivedStringClustersCalculator llc = new LongLivedStringClustersCalculator(fileNames.size());
        for (String fileName : fileNames) {
            System.err.println("Processing heap dump " + fileName);
            Snapshot snapshot = Main.readSnapshot(fileName, vc);
            long totalObjSize = snapshot.getRoughTotalObjectSize();
            MemNumFormatter nf = new MemNumFormatter(totalObjSize);
            PrintingProgressMeter pm = new PrintingProgressMeter(){

                @Override
                public int queryPercentage() {
                    return llc.getProgressPercentage();
                }
            };
            pm.start();
            DupStringStats dss = llc.update(snapshot);
            ((ProgressMeter)pm).stopReporting();
            System.out.println("Heap dump " + fileName + ":");
            System.out.format("Total strings: %,d Unique string values: %,d Duplicate values: %,d Overhead: %s%n", dss.nStrings, dss.nUniqueStringValues, dss.nUniqueDupStringValues, nf.getNumInKAndPercent(dss.dupStringsOverhead));
        }
        llc.calculate();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Snapshot readSnapshot(String fileName, VerboseOutputCollector vc) {
        block7: {
            block6: {
                Main.startTime0 = System.currentTimeMillis();
                System.err.println("Reading heap dump...");
                snapshot = null;
                bufFactory /* !! */  = Main.useMmap != false ? new ReadBuffer.MmappedBufferFactory(fileName) : new ReadBuffer.CachedReadBufferFactory(fileName, 0);
                try {
                    reader = HeapDumpReader.createReader(bufFactory /* !! */ , Main.explicitPointerSize, vc);
                    pm = new PrintingProgressMeter(){

                        @Override
                        public int queryPercentage() {
                            return reader.getProgressPercentage();
                        }
                    };
                    pm.start();
                    snapshot = reader.read();
                    pm.stopReporting();
                }
                catch (DumpCorruptedException ex) {
                    System.err.println("Heap dump corrupted: " + ex.getMessage());
                    warnings = vc.getWarnings();
                    if (warnings.isEmpty()) break block6;
                    System.err.println("The following warnings were recorded before the fatal error was detected:");
                    ** for (warning : warnings)
                }
lbl-1000:
                // 1 sources

                {
                    System.err.println(warning);
                    continue;
                }
            }
            if (!(debugInfo = vc.getDebugInfo()).isEmpty()) {
                System.err.println("Additional debug info:");
                for (String debug : debugInfo) {
                    System.err.println(debug);
                }
            }
            System.exit(-1);
            break block7;
            catch (HprofParsingCancelledException v0) {
                System.err.println("Parsing heap dump cancelled by user");
                System.exit(-1);
            }
        }
        System.err.println("\rRead " + snapshot.getNumObjects() + " objects");
        Main.startTime1 = System.currentTimeMillis();
        Main.snapshotReadTimeMs = Main.startTime1 - Main.startTime0;
        System.err.println("Snapshot read time: " + Main.snapshotReadTimeMs / 1000L + " sec");
        return snapshot;
    }

    private static ReportFormatter calculateAndFormatStandardStats(Snapshot snapshot) {
        System.err.println("Calculating stats...");
        BatchProblemRecorder recorder = new BatchProblemRecorder();
        final StandardStatsCalculator ssc = new StandardStatsCalculator(snapshot, recorder, useBreadthFirst);
        PrintingProgressMeter pm = new PrintingProgressMeter(){

            @Override
            public int queryPercentage() {
                return ssc.getProgressPercentage();
            }
        };
        pm.start();
        HeapStats hs = null;
        try {
            hs = ssc.calculate();
        }
        catch (DumpCorruptedException ex) {
            System.err.println("Heap dump corrupted: " + ex.getMessage());
            System.exit(-1);
        }
        catch (HprofParsingCancelledException hprofParsingCancelledException) {
            System.err.println("Heap dump parsing cancelled by user");
            System.exit(-1);
        }
        ((ProgressMeter)pm).stopReporting();
        int minOverheadToReport = (int)(hs.totalObjSize / 1000L);
        DetailedStats ds = recorder.getDetailedStats(minOverheadToReport);
        return new ReportFormatter(hs, ds);
    }

    private static int parseNumericFlag(String flag) {
        String numStr = Main.getFlagValue(flag);
        try {
            return Integer.parseInt(numStr);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("No proper number in flag " + flag);
            System.exit(-1);
            return 0;
        }
    }

    private static String[] parseCommaSeparatedStringsFlag(String flag) {
        String valStr = Main.getFlagValue(flag);
        if (valStr.indexOf(44) == -1) {
            return new String[]{valStr};
        }
        return Utils.split(valStr, ',');
    }

    private static File parseFileNameFlag(String flag) {
        String fileName = Main.getFlagValue(flag);
        return FileUtils.fileWritableOrExit(fileName);
    }

    private static String getFlagValue(String flag) {
        int equalsPos = flag.indexOf(61);
        if (equalsPos == -1 || equalsPos == flag.length() - 1) {
            System.err.println(String.valueOf(flag) + " is not a flag with value");
            System.exit(-1);
        }
        return flag.substring(equalsPos + 1);
    }

    private static long checkFileAndGetSize(String fileName) {
        File f = FileUtils.fileExistsAndReadableOrExit(fileName);
        return f.length();
    }

    private static abstract class PrintingProgressMeter
    extends ProgressMeter {
        private PrintingProgressMeter() {
        }

        @Override
        public void stopReporting() {
            super.stopReporting();
            System.err.print('\r');
        }

        @Override
        public void reportProgress(int progressPerecentage) {
            System.err.print('\r');
            System.err.print(progressPerecentage);
            System.err.print('%');
        }
    }
}

