/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.batch;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openjdk.jmc.joverflow.batch.DetailedStats;
import org.openjdk.jmc.joverflow.batch.FormattedOutputBuffer;
import org.openjdk.jmc.joverflow.batch.ReferencedObjCluster;
import org.openjdk.jmc.joverflow.descriptors.CollectionClassDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.stats.ClassloaderStats;
import org.openjdk.jmc.joverflow.stats.LengthHistogram;
import org.openjdk.jmc.joverflow.stats.ObjectHistogram;
import org.openjdk.jmc.joverflow.support.CompressibleStringStats;
import org.openjdk.jmc.joverflow.support.Constants;
import org.openjdk.jmc.joverflow.support.DupArrayStats;
import org.openjdk.jmc.joverflow.support.DupStringStats;
import org.openjdk.jmc.joverflow.support.HeapStats;
import org.openjdk.jmc.joverflow.support.NumberEncodingStringStats;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.support.RefChainElementImpl;
import org.openjdk.jmc.joverflow.support.ReferenceChain;
import org.openjdk.jmc.joverflow.support.ShortArrayStats;
import org.openjdk.jmc.joverflow.util.MiscUtils;
import org.openjdk.jmc.joverflow.util.ObjectToIntMap;

public class ReportFormatter {
    private static final String DASH_SEPARATOR = "\n---------------------------------------------------";
    private final HeapStats hs;
    private final DetailedStats ds;
    private final FormattedOutputBuffer b;

    public ReportFormatter(HeapStats hs, DetailedStats ds) {
        this.hs = hs;
        this.ds = ds;
        this.b = new FormattedOutputBuffer(hs.totalObjSize);
    }

    public HeapStats getHeapStats() {
        return this.hs;
    }

    public DetailedStats getDetailedStats() {
        return this.ds;
    }

    public String getReport(boolean printFullObjectHistogram, int printedRefChainDepth, String[] refChainStopperClassPrefixes) {
        this.formatOverallStats();
        this.formatDetailedStats(printFullObjectHistogram, printedRefChainDepth, refChainStopperClassPrefixes);
        return this.b.getOutput();
    }

    private void formatOverallStats() {
        this.b.println(DASH_SEPARATOR);
        this.b.println("1. OVERALL STATS:\n");
        this.b.println("1.0 Fundamentals\n");
        this.b.format("Pointer size: %d bytes %s\n", this.hs.ptrSize, this.hs.usingNarrowPointers ? "(narrow in 64-bit mode)" : "");
        this.b.format("Object header size: %d bytes\n", this.hs.objHeaderSize);
        this.b.format("Object alignment: %d bytes\n", this.hs.objAlignment);
        this.b.format("\nTotal num of objects: %,d\n", this.hs.nObjects);
        this.b.format("Instances: %,d, object arrays: %,d, primitive arrays: %,d\n", this.hs.nInstances, this.hs.nObjectArrays, this.hs.nValueArrays);
        this.b.format("Total size of all objects: %s\n", this.b.k(this.hs.totalObjSize));
        this.b.format("Instances: %s, object arrays: %s, primitive arrays: %s\n", this.b.k(this.hs.totalInstSize), this.b.k(this.hs.totalObjArraySize), this.b.k(this.hs.totalValueArraySize));
        this.b.print("\nMinimum reported overhead: ");
        if (this.ds.minOvhdToReport < 1024) {
            this.b.println(String.valueOf(this.ds.minOvhdToReport) + " bytes");
        } else {
            this.b.println(String.valueOf(this.ds.minOvhdToReport / 1024) + "K");
        }
        this.b.println("\n1.1 Assorted raw stats; no distinction between collections and standalone arrays\n");
        this.b.format("Total size of object headers: %s\n", this.b.k(this.hs.ovhdObjHeaders));
        this.b.format("Num and size of all *$Entry instances: %,d, %s\n", this.hs.nEntryInstances, this.b.k(this.hs.entryClassSize));
        ShortArrayStats soa = this.hs.shortObjArrayStats;
        this.b.format("\nNum and overhead of length 0 obj arrays: %,d  %s\n", soa.n0LenObjs, this.b.k(soa.ovhd0LenObjs));
        this.b.format("Num and overhead of length 1 obj arrays: %,d  %s\n", soa.n1LenObjs, this.b.k(soa.ovhd1LenObjs));
        this.b.format("Num and overhead of length 2..4 obj arrays: %,d  %s\n", soa.n4LenObjs, this.b.k(soa.ovhd4LenObjs));
        this.b.format("Num and overhead of length 5..8 obj arrays: %,d  %s\n", soa.n8LenObjs, this.b.k(soa.ovhd8LenObjs));
        ShortArrayStats spa = this.hs.shortPrimitiveArrayStats;
        this.b.format("\nNum and overhead of length 0 primitive arrays: %,d  %s\n", spa.n0LenObjs, this.b.k(spa.ovhd0LenObjs));
        this.b.format("Num and overhead of length 1 primitive arrays: %,d  %s\n", spa.n1LenObjs, this.b.k(spa.ovhd1LenObjs));
        this.b.format("Num and overhead of length 2..4 primitive arrays: %,d  %s\n", spa.n4LenObjs, this.b.k(spa.ovhd4LenObjs));
        this.b.format("Num and overhead of length 5..8 primitive arrays: %,d  %s\n", spa.n8LenObjs, this.b.k(spa.ovhd8LenObjs));
        ShortArrayStats sstrs = this.hs.shortStringStats;
        this.b.format("\nNum and overhead of length 0 Strings: %,d  %s\n", sstrs.n0LenObjs, this.b.k(sstrs.ovhd0LenObjs));
        this.b.format("Num and overhead of length 1 Strings: %,d  %s\n", sstrs.n1LenObjs, this.b.k(sstrs.ovhd1LenObjs));
        this.b.format("Num and overhead of length 2..4 Strings: %,d  %s\n", sstrs.n4LenObjs, this.b.k(sstrs.ovhd4LenObjs));
        this.b.format("Num and overhead of length 5..8 Strings: %,d  %s\n", sstrs.n8LenObjs, this.b.k(sstrs.ovhd8LenObjs));
        NumberEncodingStringStats nesStats = this.hs.numberEncodingStringStats;
        this.b.format("\nNum and overhead of Strings that encode int numbers: %,d  %s\n", nesStats.nStringsEncodingInts, this.b.k(nesStats.stringsEncodingIntsOvhd));
        this.b.format("\nNum of boxed Numbers: %,d\n", this.hs.nBoxedNumbers);
        this.b.format("Overhead of boxed Numbers: %s\n", this.b.k(this.hs.ovhdBoxedNumbers));
        this.b.format("\nNum of wrapped Unmodifiable* collection classes:\n", new Object[0]);
        ObjectToIntMap.Entry<String>[] entryArray = this.hs.unmodifiableClasses;
        int n = this.hs.unmodifiableClasses.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectToIntMap.Entry<String> entry = entryArray[n2];
            this.b.format("%20s : %,d\n", entry.key, entry.value);
            ++n2;
        }
        this.b.println("\n1.2 Stats on the JVM that produced the dump (from System.getProperties()):\n");
        HashMap<String, String> systemProps = this.hs.systemProperties;
        if (systemProps != null) {
            for (Map.Entry<String, String> entry : systemProps.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith("\"java.runtime.") && !key.startsWith("\"java.vm.") && !key.startsWith("\"java.specification.") && !key.startsWith("\"os.")) continue;
                this.b.println(String.valueOf(key) + " = " + entry.getValue());
            }
        } else {
            this.b.println("  *** Could not be found ***");
        }
        this.b.println("\n1.3 Stats on classloaders\n");
        ClassloaderStats clStats = this.hs.classloaderStats;
        ObjectToIntMap<JavaObject> clInstToNumLoadedClasses = clStats.getCLInstToNumLoadedClasses();
        ObjectToIntMap<JavaClass> clClazzToNumLoadedClasses = clStats.getClClazzToNumLoadedClasses();
        int numClTypesWithLoadedClasses = 0;
        ObjectToIntMap.Entry<JavaClass>[] entryArray2 = clClazzToNumLoadedClasses.getEntries();
        int n3 = entryArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            ObjectToIntMap.Entry<JavaClass> entry = entryArray2[n4];
            if (entry.value > 0) {
                ++numClTypesWithLoadedClasses;
            }
            ++n4;
        }
        int numClInstancesWithOneLoaded = 0;
        HashSet<JavaClass> clClassesWithOneLoaded = new HashSet<JavaClass>();
        ObjectToIntMap.Entry<JavaObject>[] entryArray3 = clInstToNumLoadedClasses.getEntries();
        int n5 = entryArray3.length;
        int n6 = 0;
        while (n6 < n5) {
            ObjectToIntMap.Entry<JavaObject> entry = entryArray3[n6];
            if (entry.value == 1) {
                ++numClInstancesWithOneLoaded;
                clClassesWithOneLoaded.add(((JavaObject)entry.key).getClazz());
            }
            ++n6;
        }
        this.b.format("Num of classes extending java.lang.ClassLoader: %,d\n", clClazzToNumLoadedClasses.size());
        this.b.format("Classloader instances with loaded classes: num: %,d types: %,d\n", clInstToNumLoadedClasses.size(), numClTypesWithLoadedClasses);
        this.b.format("Classloader instances with only one loaded class: num: %,d types: %,d\n", numClInstancesWithOneLoaded, clClassesWithOneLoaded.size());
        this.b.println("\n1.4 Stats on compressible strings\n");
        CompressibleStringStats cs = this.hs.compressibleStringStats;
        this.b.format("Total num of String objects: %,d\n", cs.nTotalStrings);
        this.b.format("Total used bytes in backing arrays: %s\n", this.b.k(cs.totalUsedBackingArrayBytes));
        int percent = (int)((double)cs.nCompressedStrings * 100.0 / (double)cs.nTotalStrings);
        this.b.format("Num of Strings with backing byte[] arrays: %,d (%d%% of all Strings)\n", cs.nCompressedStrings, percent);
        this.b.format("Total used bytes in backing byte[] arrays: %s\n", this.b.k(cs.compressedBackingArrayBytes));
        percent = (int)((double)cs.nAsciiCharBackedStrings * 100.0 / (double)cs.nTotalStrings);
        this.b.format("Num of Strings backed by ASCII char[] arrays: %,d (%d%% of all Strings)\n", cs.nAsciiCharBackedStrings, percent);
        this.b.format("Total used bytes in backing ASCII char[] arrays: %s\n", this.b.k(cs.asciiCharBackingArrayBytes));
    }

    /*
     * WARNING - void declaration
     */
    private void formatDetailedStats(boolean printFullObjectHistogram, int printedRefChainDepth, String[] refChainStopperClassPrefixes) {
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("2. CLASS AND OBJECT INFORMATION:", "High memory consumption by instances of", 10.0);
        List<ObjectHistogram.Entry> objHistogram = this.hs.objHisto.getListSortedByInclusiveSize(printFullObjectHistogram ? 0 : this.ds.minOvhdToReport);
        this.b.format("\nTotal classes: %,d  Total objects: %,d\n", this.hs.nClasses, this.hs.nObjects);
        int[] smallInstClasses = this.hs.objHisto.calculateNumSmallInstClasses();
        this.b.format("Classes with no instances: %,d  Classes with 1 instance: %,d\n", smallInstClasses[0], smallInstClasses[1]);
        this.b.println("\nObject histogram for top memory consumers");
        this.b.println(" #instances    Shallow size   Impl-inclusive size   Class name");
        this.b.println("---------------------------------------------------------------");
        for (ObjectHistogram.Entry entry : objHistogram) {
            this.b.format("%,10d  %16s   %16s    %s\n", entry.getNumInstances(), this.b.k(entry.getTotalShallowSize()), this.b.k(entry.getTotalInclusiveSize()), entry.getClazz().getHumanFriendlyNameWithLoaderIfNeeded());
            this.b.criticalCheck(entry.getTotalInclusiveSize(), entry.getClazz().getHumanFriendlyNameWithLoaderIfNeeded());
        }
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("3. NUMBER, SIZE AND NEAREST FIELDS FOR HIGH MEMORY CONSUMERS:");
        this.b.println();
        List<ReferencedObjCluster.HighSizeObjects> hsFields = this.ds.highSizeObjClusters.get(1);
        for (ReferencedObjCluster.HighSizeObjects c : hsFields) {
            void var10_13;
            RefChainElement classAndField = c.getReferer();
            String string = ReferenceChain.toStringInStraightOrder(classAndField);
            String fieldDefiningClass = ReportFormatter.getFieldDefiningClassFromFieldRefChain(ReferenceChain.getRootElement(classAndField));
            if (fieldDefiningClass != null) {
                String string2 = String.valueOf(string) + " (defined in " + fieldDefiningClass + ")";
            }
            this.b.print("  ");
            this.b.print((String)var10_13);
            this.b.println(" -->");
            this.b.println(c.clusterAsString(this.b.getMemNumFormatter()));
        }
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("4. NUMBER, SIZE AND REF CHAINS FOR TOP MEMORY CONSUMERS:");
        this.b.println();
        List<ReferencedObjCluster.HighSizeObjects> hsReverseChains = this.ds.highSizeObjClusters.get(0);
        for (ReferencedObjCluster referencedObjCluster : hsReverseChains) {
            this.b.println(referencedObjCluster.clusterAsString(this.b.getMemNumFormatter()));
            this.b.print("    ");
            this.b.println(ReferenceChain.toStringInReverseOrder(referencedObjCluster.getReferer(), printedRefChainDepth, refChainStopperClassPrefixes));
        }
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("5. PROBLEMATIC COLLECTIONS:", "High overhead due to problematic collections of kind", 2.0);
        this.b.format("\nTotal collections: %,d\n", this.hs.numCols);
        this.b.format("\nEmpty unused collections total number:  %,10d, ovhd: %14s\n", this.hs.numEmptyUnusedCols, this.b.k(this.hs.emptyUnusedColsOverhead));
        this.b.criticalCheck(this.hs.emptyUnusedColsOverhead, "empty unused");
        this.printClassesWithProblemKind(Constants.ProblemKind.EMPTY_UNUSED, false, false);
        this.b.format("\nEmpty used collections total number:    %,10d, ovhd: %14s\n", this.hs.numEmptyUsedCols, this.b.k(this.hs.emptyUsedColsOverhead));
        this.b.criticalCheck(this.hs.emptyUsedColsOverhead, "empty used");
        this.printClassesWithProblemKind(Constants.ProblemKind.EMPTY_USED, false, false);
        this.b.format("\nEmpty collections total number:         %,10d, ovhd: %14s\n", this.hs.numEmptyCols, this.b.k(this.hs.emptyColsOverhead));
        this.b.criticalCheck(this.hs.emptyColsOverhead, "empty");
        this.printClassesWithProblemKind(Constants.ProblemKind.EMPTY, false, false);
        this.b.format("\nSmall sparse collections total number:  %,10d, ovhd: %14s\n", this.hs.numSparseSmallCols, this.b.k(this.hs.sparseSmallColsOverhead));
        this.b.criticalCheck(this.hs.sparseSmallColsOverhead, "small sparse");
        this.printClassesWithProblemKind(Constants.ProblemKind.SPARSE_SMALL, false, false);
        this.b.format("\nLarge sparse collections total number:  %,10d, ovhd: %14s\n", this.hs.numSparseLargeCols, this.b.k(this.hs.sparseLargeColsOverhead));
        this.b.criticalCheck(this.hs.sparseLargeColsOverhead, "large sparse");
        this.printClassesWithProblemKind(Constants.ProblemKind.SPARSE_LARGE, false, false);
        this.b.format("\nBoxed Number collections total number:  %,10d, ovhd: %14s\n", this.hs.numBoxedNumberCols, this.b.k(this.hs.boxedNumberColsOverhead));
        this.b.criticalCheck(this.hs.boxedNumberColsOverhead, "boxed number");
        this.printClassesWithProblemKind(Constants.ProblemKind.BOXED, false, false);
        this.b.format("\nVertical bar collections total number:  %,10d, ovhd: %14s\n", this.hs.numBarCols, this.b.k(this.hs.barColsOverhead));
        this.b.criticalCheck(this.hs.barColsOverhead, "vertical bar");
        this.printClassesWithProblemKind(Constants.ProblemKind.BAR, false, false);
        this.b.format("\nSmall collections total number:         %,10d, ovhd: %14s\n", this.hs.numSmallCols, this.b.k(this.hs.smallColsOverhead));
        this.b.criticalCheck(this.hs.smallColsOverhead, "small");
        this.printClassesWithProblemKind(Constants.ProblemKind.SMALL, false, false);
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("6. PROBLEMATIC STANDALONE OBJECT ARRAYS:", "High overhead due to problematic object arrays of kind", 2.0);
        this.b.format("\nTotal standalone obj arrays: %,d\n", this.hs.numObjArrays);
        this.b.format("\nLength 0 object arrays number:          %,10d, ovhd: %14s\n", this.hs.numLengthZeroObjArrays, this.b.k(this.hs.lengthZeroObjArraysOverhead));
        this.b.criticalCheck(this.hs.lengthZeroObjArraysOverhead, "length 0");
        this.printClassesWithProblemKind(Constants.ProblemKind.LENGTH_ZERO, true, false);
        this.b.format("\nLength 1 object arrays number:          %,10d, ovhd: %14s\n", this.hs.numLengthOneObjArrays, this.b.k(this.hs.lengthOneObjArraysOverhead));
        this.b.criticalCheck(this.hs.lengthOneObjArraysOverhead, "length 1");
        this.printClassesWithProblemKind(Constants.ProblemKind.LENGTH_ONE, true, false);
        this.b.format("\nEmpty object arrays number:             %,10d, ovhd: %14s\n", this.hs.numEmptyObjArrays, this.b.k(this.hs.emptyObjArraysOverhead));
        this.b.criticalCheck(this.hs.emptyObjArraysOverhead, "empty");
        this.printClassesWithProblemKind(Constants.ProblemKind.EMPTY, true, false);
        this.b.format("\nSparse object arrays number:            %,10d, ovhd: %14s\n", this.hs.numSparseObjArrays, this.b.k(this.hs.sparseObjArraysOverhead));
        this.b.criticalCheck(this.hs.sparseObjArraysOverhead, "sparse");
        this.printClassesWithProblemKind(Constants.ProblemKind.SPARSE_ARRAY, true, false);
        this.b.format("\nBoxed Number object arrays number:      %,10d, ovhd: %14s\n", this.hs.numBoxedNumberArrays, this.b.k(this.hs.boxedNumberArraysOverhead));
        this.b.criticalCheck(this.hs.boxedNumberArraysOverhead, "boxed");
        this.printClassesWithProblemKind(Constants.ProblemKind.BOXED, true, false);
        this.b.format("\nVertical bar object arrays number:      %,10d, ovhd: %14s\n", this.hs.numBarObjArrays, this.b.k(this.hs.barObjArraysOverhead));
        this.b.criticalCheck(this.hs.barObjArraysOverhead, "vertical bar");
        this.printClassesWithProblemKind(Constants.ProblemKind.BAR, true, false);
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("7. PROBLEMATIC STANDALONE PRIMITIVE ARRAYS:", "High overhead due to problematic primitive arrays of kind", 2.0);
        this.b.format("\nTotal standalone primitive arrays: %,d\n", this.hs.numValueArrays);
        this.b.format("\nLength 0 primitive arrays number:         %,8d, ovhd: %14s\n", this.hs.numLengthZeroValueArrays, this.b.k(this.hs.lengthZeroValueArraysOverhead));
        this.b.criticalCheck(this.hs.lengthZeroValueArraysOverhead, "length 0");
        this.printClassesWithProblemKind(Constants.ProblemKind.LENGTH_ZERO, true, true);
        this.b.format("\nLength 1 primitive arrays number:         %,8d, ovhd: %14s\n", this.hs.numLengthOneValueArrays, this.b.k(this.hs.lengthOneValueArraysOverhead));
        this.b.criticalCheck(this.hs.lengthOneValueArraysOverhead, "length 1");
        this.printClassesWithProblemKind(Constants.ProblemKind.LENGTH_ONE, true, true);
        this.b.format("\nEmpty primitive arrays number:            %,8d, ovhd: %14s\n", this.hs.numEmptyValueArrays, this.b.k(this.hs.emptyValueArraysOverhead));
        this.b.criticalCheck(this.hs.emptyValueArraysOverhead, "empty");
        this.printClassesWithProblemKind(Constants.ProblemKind.EMPTY, true, true);
        this.b.format("\nLong zero-tail primitive arrays number:   %,8d, ovhd: %14s\n", this.hs.numLZTValueArrays, this.b.k(this.hs.lztValueArraysOverhead));
        this.b.criticalCheck(this.hs.lztValueArraysOverhead, "long zero-tail (LZT)");
        this.printClassesWithProblemKind(Constants.ProblemKind.LZT, true, true);
        this.b.format("\nUnused high bytes primitive arrays number:%,8d, ovhd: %14s\n", this.hs.numUnusedHiBytesValueArrays, this.b.k(this.hs.unusedHiBytesValueArraysOverhead));
        this.b.criticalCheck(this.hs.unusedHiBytesValueArraysOverhead, "unused high bytes");
        this.printClassesWithProblemKind(Constants.ProblemKind.UNUSED_HI_BYTES, true, true);
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("8. NUMBER, OVERHEAD AND NEAREST FIELDS FOR PROBLEMATIC COLLECTIONS AND ARRAYS:");
        this.b.println();
        List<ReferencedObjCluster.Collections> list = this.ds.collectionClusters.get(1);
        for (ReferencedObjCluster.Collections c : list) {
            void var12_21;
            if (c.getTotalOverhead() < this.ds.minOvhdToReport / 4) break;
            RefChainElement classAndField = c.getReferer();
            String string = ReferenceChain.toStringInStraightOrder(classAndField);
            String string3 = ReportFormatter.getFieldDefiningClassFromFieldRefChain(ReferenceChain.getRootElement(classAndField));
            if (string3 != null) {
                String string4 = String.valueOf(string) + " (defined in " + string3 + ")";
            }
            this.b.print("  ");
            this.b.print((String)var12_21);
            this.b.println(" -->");
            this.b.println(c.clusterAsString(this.b.getMemNumFormatter()));
        }
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("9. NUMBER, OVERHEAD AND REF CHAINS FOR PROBLEMATIC COLLECTIONS AND ARRAYS:");
        this.b.println();
        List<ReferencedObjCluster.Collections> colReverseChains = this.ds.collectionClusters.get(0);
        for (ReferencedObjCluster referencedObjCluster : colReverseChains) {
            if (referencedObjCluster.getTotalOverhead() < this.ds.minOvhdToReport / 4) break;
            this.b.println(referencedObjCluster.clusterAsString(this.b.getMemNumFormatter()));
            this.b.print("    ");
            this.b.println(ReferenceChain.toStringInReverseOrder(referencedObjCluster.getReferer(), printedRefChainDepth, refChainStopperClassPrefixes));
        }
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("10. DUPLICATE STRING STATS:", "High overhead due to duplicate strings", 5.0);
        DupStringStats dupStringStats = this.hs.dupStringStats;
        this.b.format("\nTotal strings: %,d Unique strings: %,d Duplicate values: %,d Overhead: %s\n", dupStringStats.nStrings, dupStringStats.nUniqueStringValues, dupStringStats.nUniqueDupStringValues, this.b.k(dupStringStats.dupStringsOverhead));
        this.b.criticalCheck(dupStringStats.dupStringsOverhead, "");
        this.b.format("Top duplicate Strings:\n", new Object[0]);
        this.b.format("    Ovhd        Num char[]s  Num objs  Max arr len  Value\n", new Object[0]);
        for (DupStringStats.Entry entry : dupStringStats.dupStrings) {
            if (entry.overhead < this.ds.minOvhdToReport) break;
            this.b.format("%14s   %6d     %6d     %6d       ", this.b.k(entry.overhead), entry.nBackingArrays, entry.nStringInstances, entry.maxArrayLen);
            String string = MiscUtils.removeEndLinesAndAddQuotes(entry.string, 100);
            this.b.println(string);
        }
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("11. NUMBER, OVERHEAD AND NEAREST FIELDS FOR DUPLICATE STRINGS:");
        this.b.println();
        List<ReferencedObjCluster.DupStrings> rsFields = this.ds.dupStringClusters.get(1);
        for (ReferencedObjCluster referencedObjCluster : rsFields) {
            void var15_36;
            if (referencedObjCluster.getTotalOverhead() < this.ds.minOvhdToReport / 4) break;
            RefChainElement classAndField = referencedObjCluster.getReferer();
            String string = ReferenceChain.toStringInStraightOrder(classAndField);
            String string5 = ReportFormatter.getFieldDefiningClassFromFieldRefChain(ReferenceChain.getRootElement(classAndField));
            if (string5 != null) {
                String string6 = String.valueOf(string) + " (defined in " + string5 + ")";
            }
            this.b.print("  ");
            this.b.print((String)var15_36);
            this.b.println(" -->");
            this.b.println(referencedObjCluster.clusterAsString(this.b.getMemNumFormatter()));
        }
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("12. NUMBER, OVERHEAD AND REF CHAINS FOR DUPLICATE STRINGS:");
        this.b.println();
        List<ReferencedObjCluster.DupStrings> list2 = this.ds.dupStringClusters.get(0);
        for (ReferencedObjCluster referencedObjCluster : list2) {
            if (referencedObjCluster.getTotalOverhead() < this.ds.minOvhdToReport / 4) break;
            this.b.println(referencedObjCluster.clusterAsString(this.b.getMemNumFormatter()));
            this.b.print("    ");
            this.b.println(ReferenceChain.toStringInReverseOrder(referencedObjCluster.getReferer(), printedRefChainDepth, refChainStopperClassPrefixes));
        }
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("13. DUPLICATE PRIMITIVE ARRAY STATS:", "High overhead due to duplicate primitive arrays", 5.0);
        DupArrayStats dupArrayStats = this.hs.dupArrayStats;
        this.b.format("\nTotal primitive arrays: %,d Unique arrays: %,d Duplicate values: %,d Overhead: %s\n", dupArrayStats.nArrays, dupArrayStats.nUniqueArrays, dupArrayStats.nDifferentDupArrayValues, this.b.k(dupArrayStats.dupArraysOverhead));
        this.b.criticalCheck(dupArrayStats.dupArraysOverhead, "");
        this.b.format("Top duplicate primitive arrays:\n", new Object[0]);
        this.b.format("    Ovhd         Num objs  Array len    Value\n", new Object[0]);
        for (DupArrayStats.Entry entry : dupArrayStats.dupArrays) {
            if (entry.overhead < this.ds.minOvhdToReport) break;
            this.b.format("%14s   %6d     %6d     ", this.b.k(entry.overhead), entry.nArrayInstances, entry.firstArray.getLength());
            String string = entry.firstArray.valueAsString();
            this.b.println(string);
        }
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("14. NUMBER, OVERHEAD AND NEAREST FIELDS FOR DUPLICATE PRIMITIVE ARRAYS:");
        this.b.println();
        List<ReferencedObjCluster.DupArrays> daFields = this.ds.dupArrayClusters.get(1);
        for (ReferencedObjCluster referencedObjCluster : daFields) {
            void var18_51;
            if (referencedObjCluster.getTotalOverhead() < this.ds.minOvhdToReport / 4) break;
            RefChainElement classAndField = referencedObjCluster.getReferer();
            String string = ReferenceChain.toStringInStraightOrder(classAndField);
            String string7 = ReportFormatter.getFieldDefiningClassFromFieldRefChain(ReferenceChain.getRootElement(classAndField));
            if (string7 != null) {
                String string8 = String.valueOf(string) + " (defined in " + string7 + ")";
            }
            this.b.print("  ");
            this.b.print((String)var18_51);
            this.b.println(" -->");
            this.b.println(referencedObjCluster.clusterAsString(this.b.getMemNumFormatter()));
        }
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("15. NUMBER, OVERHEAD AND REF CHAINS FOR DUPLICATE PRIMITIVE ARRAYS:");
        this.b.println();
        List<ReferencedObjCluster.DupArrays> list3 = this.ds.dupArrayClusters.get(0);
        for (ReferencedObjCluster referencedObjCluster : list3) {
            if (referencedObjCluster.getTotalOverhead() < this.ds.minOvhdToReport / 4) break;
            this.b.println(referencedObjCluster.clusterAsString(this.b.getMemNumFormatter()));
            this.b.print("    ");
            this.b.println(ReferenceChain.toStringInReverseOrder(referencedObjCluster.getReferer(), printedRefChainDepth, refChainStopperClassPrefixes));
        }
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("16. WEAK HASHMAPS WITH REFS FROM VALUES TO KEYS\n    (conservative estimate; deep object size not calculated):", "Found WeakHashMaps with references from values to keys, minimum overhead", 0.01);
        this.b.format("\n      Ovhd       Num collections   Type\n", new Object[0]);
        Constants.ProblemKind problemKind = Constants.ProblemKind.WEAK_MAP_WITH_BACK_REFS;
        for (CollectionClassDescriptor cd : this.hs.overheadsByClass) {
            int n = cd.getNumProblematicCollections(problemKind);
            if (n == 0) continue;
            String className = cd.getClazz().getHumanFriendlyName();
            int ovhd = cd.getProblematicCollectionsOverhead(problemKind);
            this.b.criticalCheck(ovhd, "");
            this.b.format("%14s   %,8d        %s\n", this.b.k(ovhd), n, className);
        }
        this.b.println();
        List<ReferencedObjCluster.WeakHashMaps> wmReverseChains = this.ds.weakHashMapClusters.get(0);
        for (ReferencedObjCluster referencedObjCluster : wmReverseChains) {
            this.b.println(referencedObjCluster.clusterAsString(this.b.getMemNumFormatter()));
            this.b.print("    ");
            this.b.println(ReferenceChain.toStringInReverseOrder(referencedObjCluster.getReferer(), printedRefChainDepth, refChainStopperClassPrefixes));
        }
        this.b.println();
        List<ReferencedObjCluster.WeakHashMaps> list4 = this.ds.weakHashMapClusters.get(1);
        for (ReferencedObjCluster referencedObjCluster : list4) {
            this.b.print("  ");
            this.b.print(ReferenceChain.toStringInStraightOrder(referencedObjCluster.getReferer()));
            this.b.println(" -->");
            this.b.println(referencedObjCluster.clusterAsString(this.b.getMemNumFormatter()));
        }
        this.b.println();
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("17. DATA FIELDS ALWAYS OR ALMOST ALWAYS NULL/ZERO, OR NO FIELDS:", "High overhead due to fields that are null/zero/non-existent in", 1.0);
        this.printProblemFieldsHistogram(this.hs.objHisto, true, 1.0f, this.ds.minOvhdToReport);
        this.printProblemFieldsHistogram(this.hs.objHisto, true, 0.9f, this.ds.minOvhdToReport);
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("18. PRIMITIVE DATA FIELDS WITH UNUSED HIGH BYTES:", "High overhead due to primitive fields with unused high bytes", 1.0);
        this.printProblemFieldsHistogram(this.hs.objHisto, false, 1.0f, this.ds.minOvhdToReport);
        this.printProblemFieldsHistogram(this.hs.objHisto, false, 0.9f, this.ds.minOvhdToReport);
        this.b.println(DASH_SEPARATOR);
        this.b.startSection("19. STRING LENGTH STATISTICS:", "High memory consumption by Strings of length", 10.0);
        List<LengthHistogram.Entry> list5 = this.hs.stringLengthHistogram.getPrunedAndSortedEntries(this.ds.minOvhdToReport);
        this.b.println("\n    Length         Count              Size");
        this.b.println("----------------------------------------------");
        for (LengthHistogram.Entry entry : list5) {
            int strLen = entry.getLength();
            String formattedLen = strLen >= 0 ? String.format("%,d", strLen) : "other";
            this.b.format(" %9s    %,10d     %16s\n", formattedLen, entry.getCount(), this.b.k(entry.getSize()));
            this.b.criticalCheck(entry.getSize(), formattedLen);
        }
    }

    private void printClassesWithProblemKind(Constants.ProblemKind problemKind, boolean selectArrays, boolean selectPrimitiveArrays) {
        for (CollectionClassDescriptor cd : this.hs.overheadsByClass) {
            JavaClass clazz = cd.getClazz();
            if (!clazz.isArray() ? selectArrays : !selectArrays || (clazz.isAnyDimPrimitiveArray() ? !selectPrimitiveArrays : selectPrimitiveArrays)) continue;
            int ovhd = cd.getProblematicCollectionsOverhead(problemKind);
            if (ovhd < this.ds.minOvhdToReport) continue;
            this.b.format("%39s   %,8d        %14s\n", clazz.getHumanFriendlyName(), cd.getNumProblematicCollections(problemKind), this.b.k(ovhd));
        }
    }

    private void printProblemFieldsHistogram(ObjectHistogram objHisto, boolean nullFields, float percentile, int minOverheadToReport) {
        List<ObjectHistogram.ProblemFieldsEntry> problemClasses = nullFields ? objHisto.getListSortedByNullFieldsOvhd(percentile) : objHisto.getListSortedByUnusedHiByteFieldsOvhd(percentile);
        int nClasses = problemClasses.size();
        int nObjects = 0;
        long totalOverhead = 0L;
        for (ObjectHistogram.ProblemFieldsEntry probClazz : problemClasses) {
            nObjects += probClazz.getNumInstances();
            totalOverhead += probClazz.getAllProblemFieldsOvhd();
        }
        int percentileAsInt = (int)(percentile * 100.0f);
        String subIssue = String.format("%d%% of instances", percentileAsInt);
        if (nullFields) {
            this.b.format("\nClasses with some fields null/zero in %s, or no fields: %,d\n", subIssue, nClasses);
            this.b.format("Objects: %,d  Overhead: %s\n", nObjects, this.b.k(totalOverhead));
            this.b.criticalCheck(totalOverhead, subIssue);
            this.b.println("Null fields ovhd  #instances        Class name   /   Null fields");
        } else {
            this.b.format("\nClasses with primitive fields that don't use high byte(s) in %s: %,d\n", subIssue, nClasses);
            this.b.format("Objects: %,d  Overhead: %s\n", nObjects, this.b.k(totalOverhead));
            this.b.criticalCheck(totalOverhead, subIssue);
            this.b.println("Bad fields ovhd   #instances        Class name   /   Null fields");
        }
        this.b.println("----------------------------------------------------------------");
        for (ObjectHistogram.ProblemFieldsEntry nfClass : problemClasses) {
            if (nfClass.getAllProblemFieldsOvhd() < (long)minOverheadToReport) break;
            this.b.format("%15s %,10d   %38s\n", this.b.k(nfClass.getAllProblemFieldsOvhd()), nfClass.getNumInstances(), nfClass.getClazz().getHumanFriendlyNameWithLoaderIfNeeded());
            this.b.print("       ");
            this.b.println(nfClass.getFieldsAsString());
        }
    }

    private static String getFieldDefiningClassFromFieldRefChain(RefChainElement desc) {
        int fieldIdx;
        if (!(desc instanceof RefChainElementImpl.AbstractField)) {
            return null;
        }
        RefChainElementImpl.AbstractField fieldDesc = (RefChainElementImpl.AbstractField)desc;
        JavaClass clazz = fieldDesc.getJavaClass();
        JavaClass defClazz = clazz.getDeclaringClassForField(fieldIdx = fieldDesc.getFieldIdx());
        if (defClazz == clazz || defClazz == null) {
            return null;
        }
        return defClazz.getName();
    }
}

