/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.descriptors;

import org.openjdk.jmc.joverflow.descriptors.AbstractCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.AbstractLinkedCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;

public class LinkedCollectionDescriptor
extends AbstractLinkedCollectionDescriptor {
    private int cachedSize = -1;

    private LinkedCollectionDescriptor(JavaObject col, Factory factory) {
        super(col, factory);
    }

    @Override
    public int doGetImplSize() {
        int result = this.col.getSize();
        JavaThing rootField = this.col.getField(this.factory.rootFieldIdx);
        if (rootField == null || !(rootField instanceof JavaObject)) {
            return result;
        }
        JavaObject entry = (JavaObject)rootField;
        int nextFieldIdx = this.factory.getEntryNextFieldIdx(entry);
        long rootEntryObjOfsInFile = entry.getObjOfsInFile();
        JavaThing[] entryFields = null;
        while (!entry.isVisitedAsCollectionImpl()) {
            entry.setVisitedAsCollectionImpl();
            result += entry.getSize();
            entryFields = entry.getFields(entryFields);
            JavaObject prevEntry = entry;
            JavaThing entryThing = entryFields[nextFieldIdx];
            if (entryThing == null || !(entryThing instanceof JavaObject) || (entry = (JavaObject)entryThing).getObjOfsInFile() == prevEntry.getObjOfsInFile() || entry.getObjOfsInFile() == rootEntryObjOfsInFile) break;
        }
        return result;
    }

    @Override
    public void iterateList(CollectionInstanceDescriptor.ListIteratorCallback cb) {
        JavaHeapObject payload;
        JavaThing payloadThing;
        int numElements = this.getNumElements();
        if (numElements == 0) {
            return;
        }
        JavaThing rootField = this.col.getField(this.factory.rootFieldIdx);
        if (rootField == null || !(rootField instanceof JavaObject)) {
            return;
        }
        JavaObject entry = (JavaObject)rootField;
        int nextFieldIdx = this.factory.getEntryNextFieldIdx(entry);
        int elementFieldIdx = this.factory.getElementFieldIdx(entry);
        long rootEntryObjOfsInFile = entry.getObjOfsInFile();
        JavaThing[] entryFields = null;
        while (cb.scanImplementationObject(entry) && ((payloadThing = (entryFields = entry.getFields(entryFields))[elementFieldIdx]) == null || !(payloadThing instanceof JavaHeapObject) || cb.scanListElement(payload = (JavaHeapObject)payloadThing))) {
            JavaObject prevEntry = entry;
            JavaThing entryThing = entryFields[nextFieldIdx];
            if (entryThing != null && entryThing instanceof JavaObject && (entry = (JavaObject)entryThing).getObjOfsInFile() != prevEntry.getObjOfsInFile() && entry.getObjOfsInFile() != rootEntryObjOfsInFile) continue;
        }
    }

    @Override
    protected int getSizeByCountingElements() {
        JavaObject prevEntry;
        JavaThing entryThing;
        if (this.cachedSize != -1) {
            return this.cachedSize;
        }
        JavaThing rootField = this.col.getField(this.factory.rootFieldIdx);
        if (rootField == null || !(rootField instanceof JavaObject)) {
            this.cachedSize = 0;
            return this.cachedSize;
        }
        int result = 0;
        JavaObject entry = (JavaObject)rootField;
        int nextFieldIdx = this.factory.getEntryNextFieldIdx(entry);
        long rootEntryObjOfsInFile = entry.getObjOfsInFile();
        JavaThing[] entryFields = null;
        do {
            ++result;
            entryFields = entry.getFields(entryFields);
            prevEntry = entry;
        } while ((entryThing = entryFields[nextFieldIdx]) != null && entryThing instanceof JavaObject && (entry = (JavaObject)entryThing).getObjOfsInFile() != prevEntry.getObjOfsInFile() && entry.getObjOfsInFile() != rootEntryObjOfsInFile);
        this.cachedSize = result;
        return result;
    }

    @Override
    public void iterateMap(CollectionInstanceDescriptor.MapIteratorCallback cb) {
        throw new UnsupportedOperationException();
    }

    /* synthetic */ LinkedCollectionDescriptor(JavaObject javaObject, Factory factory, LinkedCollectionDescriptor linkedCollectionDescriptor) {
        this(javaObject, factory);
    }

    static class Factory
    extends AbstractLinkedCollectionDescriptor.Factory {
        Factory(JavaClass clazz, String sizeFieldName, String rootFieldName, String elementFieldName, JavaClass[] implClasses) {
            super(clazz, false, sizeFieldName, rootFieldName, elementFieldName, implClasses);
        }

        private Factory(JavaClass clazz, AbstractCollectionDescriptor.Factory superclassFactory) {
            super(clazz, superclassFactory);
        }

        @Override
        AbstractCollectionDescriptor.Factory cloneForSubclass(JavaClass clazz) {
            return new Factory(clazz, this);
        }

        @Override
        CollectionInstanceDescriptor get(JavaObject col) {
            return new LinkedCollectionDescriptor(col, this, null);
        }
    }
}

