/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.heap.parser;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import org.openjdk.jmc.joverflow.heap.parser.FileReadBuffer;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;

public class CachedReadBuffer
extends ReadBuffer {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.joverflow.heap.parser");
    private static final int PAGE_SIZE_MAGNITUDE = 19;
    private static final int PAGE_SIZE = 524288;
    private static final int PAGE_START_MASK = -524288;
    private final int numPagesInPool;
    private final FileReadBuffer frb;
    private final long fileSize;
    private final byte[] buffer;
    private final Page[] pageIdxInFileToPage;
    private Page mostRecentlyUsed;
    private Page leastRecentlyUsed;
    private byte[] tmpBuf = new byte[8];
    private final int[] numBytesReadFromFilePage;
    private int pass = 1;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_PERF = false;
    private volatile long numReads;
    private volatile long numPageSwaps;
    private volatile long lastReadPos;
    private volatile int numChanges;

    static CachedReadBuffer createInstance(RandomAccessFile file, int preferredSize) throws IOException {
        long memForCache;
        long fileSize = file.length();
        long l = memForCache = preferredSize <= 0 ? CachedReadBuffer.determineCacheSizeFromFreeMem(fileSize) : (long)preferredSize;
        if (memForCache > fileSize) {
            memForCache = fileSize;
        }
        int numPages = (int)((memForCache + 524288L - 1L) / 524288L);
        return new CachedReadBuffer(file, numPages);
    }

    private CachedReadBuffer(RandomAccessFile file, int numPgsInPool) throws IOException {
        this.numPagesInPool = numPgsInPool;
        Page[] pagePool = new Page[numPgsInPool];
        this.buffer = new byte[numPgsInPool * 524288];
        int i = 0;
        while (i < numPgsInPool) {
            pagePool[i] = new Page(i);
            ++i;
        }
        this.frb = new FileReadBuffer(file);
        this.fileSize = file.length();
        int numPagesInFile = (int)((this.fileSize >> 19) + 1L);
        this.pageIdxInFileToPage = new Page[numPagesInFile];
        this.numBytesReadFromFilePage = new int[numPagesInFile];
        this.prereadPages(pagePool);
        long memForCache = (long)numPgsInPool * 524288L;
        LOGGER.fine("\nDisk cache size set to " + (memForCache >> 20) + "MB");
    }

    @Override
    public void get(long pos, byte[] buf) throws IOException {
        this.get(pos, buf, buf.length);
    }

    @Override
    public void get(long pos, byte[] buf, int numBytesToRead) throws IOException {
        int numBytesLeft = numBytesToRead;
        int posInBuf = 0;
        while (numBytesLeft > 0) {
            int startPosInPage;
            int numBytesToEndOfPage;
            int pageIdxInFile = (int)(pos >> 19);
            Page page = this.pageIdxInFileToPage[pageIdxInFile];
            if (page == null) {
                page = this.leastRecentlyUsed;
                if (this.pass == 2) {
                    Page candidate = page;
                    int threshold = 419430;
                    int i = 0;
                    while (i < this.numPagesInPool / 8) {
                        int candidateBytes = this.numBytesReadFromFilePage[candidate.pageIdxInFile];
                        if (candidateBytes > threshold) {
                            page = candidate;
                            break;
                        }
                        candidate = candidate.next;
                        if (candidate == null) break;
                        ++i;
                    }
                }
                this.pageIdxInFileToPage[((Page)page).pageIdxInFile] = null;
                page.fill(pos & 0xFFFFFFFFFFF80000L, pageIdxInFile);
                ++this.numPageSwaps;
                this.pageIdxInFileToPage[pageIdxInFile] = page;
            }
            if (page != this.mostRecentlyUsed) {
                Page oldPreviousPage = page.previous;
                Page oldNextPage = page.next;
                page.previous = this.mostRecentlyUsed;
                if (oldPreviousPage != null) {
                    oldPreviousPage.next = oldNextPage;
                }
                if (oldNextPage != null) {
                    oldNextPage.previous = oldPreviousPage;
                }
                this.mostRecentlyUsed.next = page;
                this.mostRecentlyUsed = page;
                if (page == this.leastRecentlyUsed) {
                    this.leastRecentlyUsed = this.leastRecentlyUsed.next;
                }
                page.next = null;
            }
            int numBytesToCopy = numBytesLeft < (numBytesToEndOfPage = 524288 - (startPosInPage = (int)(pos - page.startPosInFile))) ? numBytesLeft : numBytesToEndOfPage;
            System.arraycopy(this.buffer, page.startPosInBuffer + startPosInPage, buf, posInBuf, numBytesToCopy);
            int n = pageIdxInFile;
            this.numBytesReadFromFilePage[n] = this.numBytesReadFromFilePage[n] + numBytesToCopy;
            if ((numBytesLeft -= numBytesToCopy) > 0) {
                posInBuf += numBytesToCopy;
                pos += (long)numBytesToCopy;
            }
            if (numBytesToCopy != 524288) continue;
            Page oldPreviousPage = page.previous;
            page.previous = null;
            page.next = this.leastRecentlyUsed;
            this.leastRecentlyUsed = page;
            this.mostRecentlyUsed = oldPreviousPage;
            this.mostRecentlyUsed.next = null;
        }
    }

    @Override
    public int getInt(long pos) throws IOException {
        this.get(pos, this.tmpBuf, 4);
        return (this.tmpBuf[0] & 0xFF) << 24 | (this.tmpBuf[1] & 0xFF) << 16 | (this.tmpBuf[2] & 0xFF) << 8 | this.tmpBuf[3] & 0xFF;
    }

    @Override
    public long getLong(long pos) throws IOException {
        this.get(pos, this.tmpBuf, 8);
        int word1 = (this.tmpBuf[0] & 0xFF) << 24 | (this.tmpBuf[1] & 0xFF) << 16 | (this.tmpBuf[2] & 0xFF) << 8 | this.tmpBuf[3] & 0xFF;
        int word2 = (this.tmpBuf[4] & 0xFF) << 24 | (this.tmpBuf[5] & 0xFF) << 16 | (this.tmpBuf[6] & 0xFF) << 8 | this.tmpBuf[7] & 0xFF;
        return (long)word1 << 32 | (long)word2 & 0xFFFFFFFFL;
    }

    @Override
    public void close() {
        this.frb.close();
    }

    public void incrementPass() {
        ++this.pass;
    }

    private static long determineCacheSizeFromFreeMem(long fileSize) {
        long maxCacheFromFileSize;
        Runtime runtime = Runtime.getRuntime();
        System.gc();
        long freeMem = runtime.freeMemory();
        long totalMem = runtime.totalMemory();
        long maxMem = runtime.maxMemory();
        long usedMem = totalMem - freeMem;
        long maxMemForWholeApp = maxMem * 58L / 100L;
        long minMemForWholeApp = totalMem * 58L / 100L;
        long maxMemForCache = maxMemForWholeApp - usedMem;
        long minMemForCache = minMemForWholeApp - usedMem;
        long memForCache = maxMemForCache;
        if (memForCache <= 0L) {
            memForCache = fileSize / 12L;
        }
        if (memForCache > (maxCacheFromFileSize = fileSize / 4L) && (memForCache = maxCacheFromFileSize) < minMemForCache) {
            memForCache = minMemForCache;
        }
        if (memForCache > Integer.MAX_VALUE) {
            memForCache = Integer.MAX_VALUE;
        }
        return memForCache;
    }

    private void prereadPages(Page[] pagePool) throws IOException {
        int bytesToRead = (int)Math.min((long)this.buffer.length, this.fileSize);
        this.frb.get(0L, this.buffer, bytesToRead);
        int numPages = pagePool.length;
        int i = 0;
        while (i < numPages) {
            Page page;
            this.pageIdxInFileToPage[i] = page = pagePool[i];
            page.startPosInFile = (long)i * 524288L;
            page.pageIdxInFile = i;
            if (i > 0) {
                page.previous = pagePool[i - 1];
            }
            if (i < numPages - 1) {
                page.next = pagePool[i + 1];
            }
            ++i;
        }
        this.leastRecentlyUsed = pagePool[0];
        this.mostRecentlyUsed = pagePool[numPages - 1];
    }

    private void checkListConsistency(Page page) {
        this.assertTrue(page.previous != null || page == this.leastRecentlyUsed, "page.previous is null", page);
        this.assertTrue(page.next != null || page == this.mostRecentlyUsed, "page.next is null", page);
        this.assertTrue(this.leastRecentlyUsed != this.mostRecentlyUsed, "mru == lru", page);
        int listSize = 1;
        page = this.leastRecentlyUsed;
        while (page != this.mostRecentlyUsed) {
            page = page.next;
            ++listSize;
        }
        this.assertTrue(listSize == this.numPagesInPool, "listSize = " + listSize, page);
    }

    private void assertTrue(boolean v, String errorKind, Page page) {
        if (!v) {
            throw new Error(this.reportPageListError(errorKind, page));
        }
    }

    private String reportPageListError(String errorKind, Page page) {
        return "In-heap file cache internal error: " + errorKind + '\n' + "page = " + page + '\n' + "LRU = " + this.leastRecentlyUsed + ";  MRU = " + this.mostRecentlyUsed + '\n' + ", numPagesInPool = " + this.numPagesInPool;
    }

    private class Page {
        private final int startPosInBuffer;
        private long startPosInFile;
        private int pageIdxInFile;
        Page next;
        Page previous;
        private final int idxInPagePool;

        Page(int idxInPagePool) {
            this.startPosInBuffer = idxInPagePool * 524288;
            this.idxInPagePool = idxInPagePool;
        }

        void fill(long startPosInFile, int pageIdxInFile) throws IOException {
            this.pageIdxInFile = pageIdxInFile;
            this.startPosInFile = startPosInFile;
            long numBytesToEnd = CachedReadBuffer.this.fileSize - startPosInFile;
            int numBytesToRead = numBytesToEnd < 524288L ? (int)numBytesToEnd : 524288;
            CachedReadBuffer.this.frb.get(startPosInFile, CachedReadBuffer.this.buffer, this.startPosInBuffer, numBytesToRead);
        }

        public String toString() {
            return "Page " + this.idxInPagePool + ", idxInFile = " + this.pageIdxInFile + ", previous = " + (this.previous != null ? Integer.valueOf(this.previous.idxInPagePool) : "null") + ", next = " + (this.next != null ? Integer.valueOf(this.next.idxInPagePool) : "null");
        }
    }
}

