/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.stats.InterimRefChain;
import org.openjdk.jmc.joverflow.support.ProblemRecorder;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.support.RefChainElementImpl;

class InterimRefChainTree
extends InterimRefChain {
    private JavaHeapObject curParent;
    private ParentType curParentType;
    private int curIndexInParent;

    InterimRefChainTree(ProblemRecorder problemRecorder) {
        super(problemRecorder);
    }

    @Override
    protected void onCurrentRootReset() {
        this.curParent = null;
    }

    @Override
    protected JavaObject getPointingJavaObject() {
        if (!(this.curParent instanceof JavaObject)) {
            return null;
        }
        return (JavaObject)this.curParent;
    }

    @Override
    protected RefChainElement getLastRefChainElement() {
        if (this.curParent == null) {
            return this.curCondensedRefChainElement;
        }
        JavaClass curParentClazz = this.curParent.getClazz();
        switch (this.curParentType) {
            case INSTANCE: {
                RefChainElementImpl.InstanceFieldOrLinkedList crc;
                if (this.curCondensedRefChainElement instanceof RefChainElementImpl.InstanceFieldOrLinkedList && (crc = (RefChainElementImpl.InstanceFieldOrLinkedList)this.curCondensedRefChainElement).getFieldIdx() == this.curIndexInParent && curParentClazz.isSameOrHierarchicallyRelated(crc.getJavaClass())) {
                    crc.switchToLinkedList();
                    return this.curCondensedRefChainElement;
                }
                return RefChainElementImpl.getInstanceFieldElement(curParentClazz, this.curIndexInParent, this.curCondensedRefChainElement);
            }
            case COLLECTION: {
                return RefChainElementImpl.getCompoundCollectionElement(curParentClazz, this.curCondensedRefChainElement);
            }
            case ARRAY: {
                return RefChainElementImpl.getCompoundArrayElement(curParentClazz, this.curCondensedRefChainElement);
            }
            case CLAZZ: {
                return RefChainElementImpl.getStaticFieldElement((JavaClass)this.curParent, this.curIndexInParent, this.curCondensedRefChainElement);
            }
        }
        return null;
    }

    void setCurParent(JavaHeapObject curParent, ParentType curParentType, RefChainElement referer) {
        this.curParent = curParent;
        this.curParentType = curParentType;
        this.curIndexInParent = -1;
        this.curCondensedRefChainElement = referer;
    }

    void setCurIndexInParent(int index) {
        this.curIndexInParent = index;
    }

    void incCurIndexInParent() {
        ++this.curIndexInParent;
    }

    static enum ParentType {
        INSTANCE,
        COLLECTION,
        ARRAY,
        CLAZZ;

    }
}

