/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.ui.common.util.Environment;

public final class LoggingToolkit {
    private static final String KEY_FILE_HANDLER_PATTERN = "java.util.logging.FileHandler.pattern";
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.rcp.application");

    private LoggingToolkit() {
        throw new AssertionError((Object)"Toolkit!");
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static void initializeLogging() {
        block20: {
            String file = System.getProperty("java.util.logging.config.file");
            if (Environment.isDebug()) {
                try {
                    LoggingToolkit.readConfiguration(LoggingToolkit.class.getClassLoader().getResourceAsStream("logging_debug.properties"));
                    LoggingToolkit.getLogger().log(Level.INFO, "Debug settings enabled - loaded debug settings for the logger from logging_debug.properties.");
                }
                catch (Exception e) {
                    LoggingToolkit.getLogger().log(Level.WARNING, "Could not initialize debug logger", e);
                    System.err.println("WARNING: Could not initialize debug logger");
                    LoggingToolkit.getLogger().log(Level.WARNING, "", e);
                    e.printStackTrace();
                }
            } else if (file == null || file.trim().equals("")) {
                try {
                    LoggingToolkit.readConfiguration(LoggingToolkit.class.getClassLoader().getResourceAsStream("logging.properties"));
                }
                catch (Exception e) {
                    LoggingToolkit.getLogger().log(Level.WARNING, "Could not initialize default logger", e);
                    System.err.println("WARNING: Could not initialize default logger");
                    LoggingToolkit.getLogger().log(Level.WARNING, "", e);
                    e.printStackTrace();
                }
            } else {
                try {
                    if (new File(file).exists()) {
                        Throwable e = null;
                        Object var2_6 = null;
                        try (FileInputStream fis = new FileInputStream(file);){
                            LoggingToolkit.readConfiguration(fis);
                            LoggingToolkit.getLogger().log(Level.INFO, "Loaded user specified logging settings from " + file + ".");
                            break block20;
                        }
                        catch (Throwable throwable) {
                            if (e == null) {
                                e = throwable;
                            } else if (e != throwable) {
                                e.addSuppressed(throwable);
                            }
                            throw e;
                        }
                    }
                    LoggingToolkit.getLogger().log(Level.WARNING, "Could not find user specified logging settings at " + file + ".");
                }
                catch (Exception e) {
                    LoggingToolkit.getLogger().log(Level.WARNING, "Could not initialize user logger", e);
                    System.err.println("WARNING: Could not initialize user logger");
                    LoggingToolkit.getLogger().log(Level.WARNING, "", e);
                    e.printStackTrace();
                }
            }
        }
        LoggingToolkit.getLogger().log(Level.FINE, "Logger initialized");
        System.out.flush();
    }

    private static void readConfiguration(InputStream resourceAsStream) throws SecurityException, IOException {
        Properties props = new Properties();
        InputStream is = null;
        try {
            props.load(resourceAsStream);
            LoggingToolkit.resolveProperties(props);
            LoggingToolkit.createFolders(props);
            is = LoggingToolkit.getAsInputStream(props);
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently((Closeable)resourceAsStream);
            IOToolkit.closeSilently(is);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)resourceAsStream);
        IOToolkit.closeSilently((Closeable)is);
    }

    private static InputStream getAsInputStream(Properties props) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            props.store(baos, "");
            String newProps = baos.toString();
            return new ByteArrayInputStream(newProps.getBytes("UTF-8"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void createFolders(Properties props) {
        String loggingFolder = props.getProperty(KEY_FILE_HANDLER_PATTERN);
        if (loggingFolder == null) {
            return;
        }
        String parentStr = new File(loggingFolder).getParent();
        if (parentStr.contains("%")) {
            return;
        }
        new File(parentStr).mkdirs();
    }

    private static void resolveProperties(Properties props) {
        props.setProperty(KEY_FILE_HANDLER_PATTERN, LoggingToolkit.resolvePath(props.getProperty(KEY_FILE_HANDLER_PATTERN)));
    }

    private static String resolvePath(String t) {
        String newStr = t;
        if (newStr.contains("%t")) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null) {
                tmpDir = System.getProperty("user.home");
            }
            newStr = newStr.replace("%t", System.getProperty("java.io.tmpdir"));
        }
        if (newStr.contains("%h")) {
            newStr = newStr.replace("%h", System.getProperty("user.home"));
        }
        if (newStr.contains("%w")) {
            String location = Platform.getInstanceLocation().getURL().getFile();
            location = new File(location).getPath();
            newStr = newStr.replace("%w", location);
        }
        return newStr;
    }
}

