/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.tree;

import java.util.ArrayList;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.rules.tree.ITreeNode;
import org.openjdk.jmc.flightrecorder.rules.tree.TreeNode;

public class ItemTreeBuilder {
    private static IItemTreeBuilderCallback DEFAULT_CALLBACK = new IItemTreeBuilderCallback(){

        @Override
        public boolean shouldContinue() {
            return true;
        }
    };

    public static ITreeNode<IItem> buildEncapsulationTree(IItemCollection items, boolean allowInstants) {
        return ItemTreeBuilder.buildEncapsulationTree(items, allowInstants, false);
    }

    public static ITreeNode<IItem> buildEncapsulationTree(IItemCollection items, boolean allowInstants, boolean ignoreThread) {
        return ItemTreeBuilder.buildEncapsulationTree(items, allowInstants, ignoreThread, DEFAULT_CALLBACK);
    }

    public static ITreeNode<IItem> buildEncapsulationTree(IItemCollection items, boolean allowInstants, boolean ignoreThread, IItemTreeBuilderCallback callback) {
        TreeNode<Object> root = new TreeNode<Object>(null);
        for (IItemIterable itemIterable : items) {
            IMemberAccessor durationAccessor = JfrAttributes.DURATION.getAccessor(itemIterable.getType());
            IMemberAccessor startTimeAccessor = JfrAttributes.START_TIME.getAccessor(itemIterable.getType());
            IMemberAccessor endTimeAccessor = JfrAttributes.END_TIME.getAccessor(itemIterable.getType());
            IMemberAccessor threadAccessor = JfrAttributes.EVENT_THREAD.getAccessor(itemIterable.getType());
            for (IItem item : itemIterable) {
                IMCThread thread;
                if (!callback.shouldContinue()) {
                    return root;
                }
                IQuantity duration = (IQuantity)durationAccessor.getMember((Object)item);
                boolean hasDuration = duration.longValue() != 0L;
                IMCThread iMCThread = thread = threadAccessor == null ? null : (IMCThread)threadAccessor.getMember((Object)item);
                if (!hasDuration && !allowInstants) continue;
                ItemTreeBuilder.addTimeSplitNode(root, item, hasDuration, (IQuantity)startTimeAccessor.getMember((Object)item), (IQuantity)endTimeAccessor.getMember((Object)item), thread, callback, ignoreThread);
            }
        }
        return root;
    }

    private static void addTimeSplitNode(TreeNode<IItem> node, IItem item, boolean itemHasDuration, IQuantity itemStartTime, IQuantity itemEndTime, IMCThread itemThread, IItemTreeBuilderCallback callback, boolean ignoreThread) {
        TreeNode<IItem> addedNode = null;
        ArrayList<ITreeNode<IItem>> children = new ArrayList<ITreeNode<IItem>>(node.getChildren());
        for (ITreeNode iTreeNode : children) {
            if (!callback.shouldContinue()) {
                return;
            }
            if (ItemTreeBuilder.treeItemEncloses((TreeNode)iTreeNode, itemStartTime, itemEndTime, itemThread, ignoreThread)) {
                ItemTreeBuilder.addTimeSplitNode((TreeNode)iTreeNode, item, itemHasDuration, itemStartTime, itemEndTime, itemThread, callback, ignoreThread);
                return;
            }
            if (!ItemTreeBuilder.enclosesTreeItem(itemHasDuration, itemStartTime, itemEndTime, itemThread, (TreeNode)iTreeNode, ignoreThread)) continue;
            ((TreeNode)iTreeNode).detach();
            if (addedNode == null) {
                addedNode = new TreeNode<IItem>(item, itemHasDuration, itemStartTime, itemEndTime, itemThread);
                node.addChild(addedNode);
            }
            addedNode.addChild((TreeNode)iTreeNode);
        }
        if (addedNode == null) {
            node.addChild(new TreeNode<IItem>(item, itemHasDuration, itemStartTime, itemEndTime, itemThread));
        }
    }

    private static boolean enclosesTreeItem(boolean encloserHasDuration, IQuantity encloserStartTime, IQuantity encloserEndTime, IMCThread encloserThread, TreeNode<IItem> enclosee, boolean ignoreThread) {
        if (encloserHasDuration) {
            return encloserStartTime.compareTo((Object)enclosee.getStartTime()) <= 0 && encloserEndTime.compareTo((Object)enclosee.getEndTime()) >= 0 && (ignoreThread || encloserThread.equals(enclosee.getThread()));
        }
        return false;
    }

    private static boolean treeItemEncloses(TreeNode<IItem> encloser, IQuantity encloseeStartTime, IQuantity encloseeEndTime, IMCThread encloseeThread, boolean ignoreThread) {
        if (encloser.hasDuration()) {
            return encloser.getStartTime().compareTo((Object)encloseeStartTime) <= 0 && encloser.getEndTime().compareTo((Object)encloseeEndTime) >= 0 && (ignoreThread || encloser.getThread().equals(encloseeThread));
        }
        return false;
    }

    public static interface IItemTreeBuilderCallback {
        public boolean shouldContinue();
    }
}

