/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventConfiguration;
import org.openjdk.jmc.flightrecorder.configuration.events.SchemaVersion;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.EventConfiguration;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.PrivateStorageDelegate;

public class EventConfigurationRepository
extends Observable {
    private static Pattern NAME_WITH_COUNT_PATTERN = Pattern.compile("^(.*)\\s*\\((\\d+)\\)$");
    private static Pattern COUNT_SUFFIX_PATTERN = Pattern.compile("^\\s*\\((\\d+)\\)$");
    private static Comparator<IEventConfiguration> COMPARATOR = new Comparator<IEventConfiguration>(){

        @Override
        public int compare(IEventConfiguration first, IEventConfiguration second) {
            return first.getName().compareTo(second.getName());
        }
    };
    private final List<IEventConfiguration> m_templates = new ArrayList<IEventConfiguration>();
    private IEventConfiguration prototype = null;

    public void remove(IEventConfiguration t) {
        if (this.m_templates.remove(t)) {
            this.setChanged();
        }
    }

    public void add(IEventConfiguration t) {
        if (!this.m_templates.contains(t)) {
            this.m_templates.add(t);
            this.setChanged();
        }
    }

    public boolean contains(IEventConfiguration t) {
        return this.m_templates.contains(t);
    }

    public boolean replaceOriginalContentsFor(IEventConfiguration workingCopy) {
        EventConfiguration original = (EventConfiguration)workingCopy.getOriginal();
        if (original != null && original.replaceWithContentsFrom(workingCopy)) {
            original.save();
            this.setChanged();
            return true;
        }
        return false;
    }

    @Override
    public void notifyObservers(Object arg) {
        this.m_templates.sort(COMPARATOR);
        super.notifyObservers(arg);
    }

    public boolean isAllowedName(String name) {
        name = name.trim();
        for (IEventConfiguration rt : this.m_templates) {
            if (!name.equals(rt.getName().trim())) continue;
            return false;
        }
        return true;
    }

    public boolean addAsUnique(IEventConfiguration template) {
        String newName = this.nextUniqueName(template.getName());
        template.setName(newName);
        if (template.save()) {
            this.add(template);
            return true;
        }
        return false;
    }

    public String nextUniqueName(String originalName) {
        String baseName = originalName = originalName.trim();
        long proposedCount = -1L;
        Matcher matcher = NAME_WITH_COUNT_PATTERN.matcher(originalName);
        if (matcher.matches()) {
            try {
                long count = Long.parseLong(matcher.group(2));
                baseName = matcher.group(1).trim();
                proposedCount = count;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int baseLen = baseName.length();
        for (IEventConfiguration template : this.m_templates) {
            String tempName = template.getName().trim();
            if (!tempName.startsWith(baseName)) continue;
            if (tempName.equals(baseName) && proposedCount < 1L) {
                proposedCount = 1L;
                continue;
            }
            Matcher tempMatch = COUNT_SUFFIX_PATTERN.matcher(tempName.substring(baseLen));
            if (!tempMatch.matches()) continue;
            try {
                long count = Long.parseLong(tempMatch.group(1));
                if (count >= Long.MAX_VALUE) continue;
                proposedCount = Math.max(proposedCount, count + 1L);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (proposedCount == -1L) {
            return baseName;
        }
        return String.valueOf(baseName) + " (" + proposedCount + ')';
    }

    public void setPrototypeTemplate(IEventConfiguration prototype) {
        if (prototype != this.prototype) {
            this.prototype = prototype;
            this.setChanged();
        }
    }

    public boolean canCreateTemplates() {
        return this.prototype != null;
    }

    public IEventConfiguration createTemplate() throws IOException {
        return this.prototype != null ? this.prototype.createCloneWithStorage(PrivateStorageDelegate.getDelegate()) : null;
    }

    public boolean isEmpty() {
        return this.m_templates.isEmpty();
    }

    public List<IEventConfiguration> getTemplates(SchemaVersion version) {
        if (version == null) {
            return Collections.unmodifiableList(this.m_templates);
        }
        return this.m_templates.stream().filter(rc -> rc.getVersion().equals((Object)version)).collect(Collectors.toList());
    }
}

