/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders;

import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;

public class StacktraceDataProvider {
    private static final int MAX_TAIL_FRAMES = 5;

    public static List<IMCMethod> getRelevantTraceList(StacktraceModel.Branch branch, int rootItems) {
        double threshold = (double)rootItems / 5.0;
        ArrayList<IMCMethod> frames = new ArrayList<IMCMethod>();
        if ((double)branch.getFirstFrame().getItemCount() >= threshold) {
            IMCMethod firstMethod = branch.getFirstFrame().getFrame().getMethod();
            frames.add(firstMethod);
            StacktraceFrame[] tailFrames = branch.getTailFrames();
            for (int i = 0; i < tailFrames.length && i < 5; ++i) {
                StacktraceFrame stacktraceFrame = tailFrames[i];
                IMCMethod method = stacktraceFrame.getFrame().getMethod();
                frames.add(method);
            }
        }
        return frames;
    }
}

