/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.content.ILazySource;
import org.eclipse.core.internal.content.LowLevelIOException;

public class LazyInputStream
extends InputStream
implements ILazySource {
    private final int blockCapacity;
    byte[][] blocks = new byte[0][];
    private long bufferSize;
    private final InputStream in;
    private long mark;
    private long offset;
    private final long maxBufferSize;

    public LazyInputStream(InputStream in, int blockCapacity) {
        this.in = in;
        this.blockCapacity = blockCapacity;
        this.maxBufferSize = (long)blockCapacity * Integer.MAX_VALUE;
    }

    @Override
    public int available() throws IOException {
        try {
            long ret = this.bufferSize - this.offset + (long)this.in.available();
            return ret > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)ret;
        }
        catch (IOException ioe) {
            throw new LowLevelIOException(ioe);
        }
    }

    private int computeBlockSize(int blockIndex) {
        if (blockIndex < this.blocks.length - 1) {
            return this.blockCapacity;
        }
        int blockSize = (int)(this.bufferSize % (long)this.blockCapacity);
        return blockSize == 0 ? this.blockCapacity : blockSize;
    }

    private int copyFromBuffer(byte[] userBuffer, int userOffset, int needed) throws LowLevelIOException {
        int copied = 0;
        int current = this.getCurrentBlockIndex();
        while (needed - copied > 0 && current < this.blocks.length) {
            int blockSize = this.computeBlockSize(current);
            int offsetInBlock = this.getOffsetInCurrentBlock();
            int availableInBlock = blockSize - offsetInBlock;
            int toCopy = Math.min(availableInBlock, needed - copied);
            System.arraycopy(this.blocks[current], offsetInBlock, userBuffer, userOffset + copied, toCopy);
            copied += toCopy;
            ++current;
            this.increaseOffset(toCopy);
        }
        return copied;
    }

    private int getCurrentBlockIndex() {
        return Math.toIntExact(this.offset / (long)this.blockCapacity);
    }

    private int getOffsetInCurrentBlock() {
        return (int)this.offset % this.blockCapacity;
    }

    private void ensureAvailable(long bytesToRead) throws IOException {
        this.checkOffsetIncrease(bytesToRead);
        int loadedBlockSize = this.blockCapacity;
        while (this.bufferSize < this.offset + bytesToRead && loadedBlockSize == this.blockCapacity) {
            try {
                loadedBlockSize = this.loadBlock();
            }
            catch (IOException e) {
                throw new LowLevelIOException(e);
            }
            this.bufferSize += (long)loadedBlockSize;
        }
    }

    private void increaseOffset(long inc) throws LowLevelIOException {
        this.checkOffsetIncrease(inc);
        this.offset += inc;
    }

    private void checkOffsetIncrease(long inc) throws LowLevelIOException {
        if (this.offset + inc >= this.maxBufferSize) {
            throw new LowLevelIOException(new EOFException("This would bring the current offset over the limit: " + this.maxBufferSize));
        }
    }

    protected int getBlockCount() {
        return this.blocks.length;
    }

    protected long getBufferSize() {
        return this.bufferSize;
    }

    protected void setBufferSize(long bufferSize) {
        this.bufferSize = bufferSize;
    }

    protected long getMark() {
        return this.mark;
    }

    protected long getOffset() {
        return this.offset;
    }

    protected void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public boolean isText() {
        return false;
    }

    private int loadBlock() throws IOException {
        byte[] newBlock = new byte[this.blockCapacity];
        int readCount = this.in.read(newBlock);
        if (readCount == -1) {
            return 0;
        }
        byte[][] tmpBlocks = new byte[this.blocks.length + 1][];
        System.arraycopy(this.blocks, 0, tmpBlocks, 0, this.blocks.length);
        this.blocks = tmpBlocks;
        this.blocks[this.blocks.length - 1] = newBlock;
        return readCount;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.offset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        this.ensureAvailable(1L);
        if (this.bufferSize <= this.offset) {
            return -1;
        }
        int nextByte = 0xFF & this.blocks[this.getCurrentBlockIndex()][this.getOffsetInCurrentBlock()];
        this.increaseOffset(1L);
        return nextByte;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureAvailable(len);
        int copied = this.copyFromBuffer(b, off, len);
        return copied == 0 ? -1 : copied;
    }

    @Override
    public synchronized void reset() {
        this.offset = this.mark;
    }

    @Override
    public void rewind() {
        this.mark = 0L;
        this.offset = 0L;
    }

    @Override
    public long skip(long toSkip) throws IOException {
        if (toSkip <= 0L) {
            return 0L;
        }
        this.ensureAvailable(toSkip);
        long skipped = Math.min(toSkip, this.bufferSize - this.offset);
        this.increaseOffset(skipped);
        return skipped;
    }
}

