/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.console.ui.messages.internal.Messages;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.ServiceNotAvailableException;
import org.openjdk.jmc.rjmx.common.subscription.IMBeanHelperService;
import org.openjdk.jmc.rjmx.common.subscription.IMRIValueListener;
import org.openjdk.jmc.rjmx.common.subscription.ISubscriptionService;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.common.subscription.MRIValueEvent;
import org.openjdk.jmc.rjmx.ui.attributes.MRIAttribute;
import org.openjdk.jmc.rjmx.ui.attributes.MRIAttributeInspector;
import org.openjdk.jmc.rjmx.ui.attributes.ReadOnlyMRIAttribute;
import org.openjdk.jmc.rjmx.ui.internal.SectionPartManager;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;

class GcTableSectionPart
extends MCSectionPart {
    private static final String GC_TABLE_ID = "gc";
    private static final String GC_NAME_ID = "gcName";
    private final Map<String, MRIAttributeInspector> tabs = new HashMap<String, MRIAttributeInspector>();

    public GcTableSectionPart(SectionPartManager sectionPartManager, Composite parent, FormToolkit toolkit, IConnectionHandle ch, IMemento state) {
        super(parent, toolkit, Messages.GcTableSectionPart_GC_TABLE_SECTION_TITLE);
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        CTabFolder tabFolder = new CTabFolder(body, 0);
        tabFolder.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        toolkit.adapt((Composite)tabFolder);
        HashMap<String, IMemento> gcStates = new HashMap<String, IMemento>();
        if (state != null) {
            IMemento[] iMementoArray = state.getChildren(GC_TABLE_ID);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento m = iMementoArray[n2];
                gcStates.put(m.getString(GC_NAME_ID), m);
                ++n2;
            }
        }
        for (ObjectName gcName : GcTableSectionPart.findGcNames(ch)) {
            String name = gcName.getKeyProperty("name");
            IMemento gcState = (IMemento)gcStates.get(name);
            if (gcState == null && !gcStates.isEmpty()) {
                gcState = (IMemento)gcStates.values().iterator().next();
            }
            MRIAttributeInspector ai = new MRIAttributeInspector(sectionPartManager, (Composite)tabFolder, gcState, ch, true, new IColumn[0]);
            this.tabs.put(name, ai);
            CTabItem tabItem = new CTabItem(tabFolder, 0);
            tabItem.setControl((Control)ai.getViewer().getTree());
            tabItem.setText(name);
            ArrayList<ReadOnlyMRIAttribute> l = new ArrayList<ReadOnlyMRIAttribute>();
            l.add(GcTableSectionPart.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "CollectionTime"), ai, ch));
            l.add(GcTableSectionPart.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "CollectionCount"), ai, ch));
            l.add(GcTableSectionPart.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/startTime"), ai, ch));
            l.add(GcTableSectionPart.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/endTime"), ai, ch));
            l.add(GcTableSectionPart.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/duration"), ai, ch));
            l.add(GcTableSectionPart.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/id"), ai, ch));
            l.add(GcTableSectionPart.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/GcThreadCount"), ai, ch));
            ai.setInput(l);
        }
        tabFolder.setSelection(0);
    }

    void saveState(IMemento memento) {
        for (Map.Entry<String, MRIAttributeInspector> e : this.tabs.entrySet()) {
            IMemento createChild = memento.createChild(GC_TABLE_ID);
            e.getValue().saveState(createChild);
            createChild.putString(GC_NAME_ID, e.getKey());
        }
    }

    private static List<ObjectName> findGcNames(IConnectionHandle connectionHandle) {
        ArrayList<ObjectName> gcNames = new ArrayList<ObjectName>();
        try {
            IMBeanHelperService h = (IMBeanHelperService)connectionHandle.getServiceOrThrow(IMBeanHelperService.class);
            for (Map.Entry entry : h.getMBeanInfos().entrySet()) {
                ObjectName o = (ObjectName)entry.getKey();
                if (!o.getDomain().equals("java.lang") || !"GarbageCollector".equals(o.getKeyProperty("type"))) continue;
                gcNames.add(o);
            }
        }
        catch (IOException iOException) {
        }
        catch (ServiceNotAvailableException serviceNotAvailableException) {}
        return gcNames;
    }

    private static ReadOnlyMRIAttribute createGcAttribute(MRI mri, final MRIAttributeInspector ai, IConnectionHandle ch) {
        final ReadOnlyMRIAttribute attribute = MRIAttribute.create((IConnectionHandle)ch, (MRI)mri);
        ((ISubscriptionService)ch.getServiceOrDummy(ISubscriptionService.class)).addMRIValueListener(mri, new IMRIValueListener(){

            public void valueChanged(final MRIValueEvent event) {
                DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!ai.getViewer().getControl().isDisposed()) {
                            attribute.updateValue(event.getValue());
                            ai.getViewer().update((Object)attribute, null);
                        }
                    }
                });
            }
        });
        return attribute;
    }
}

