/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.util.function.Consumer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;

public class ItemHistogramWithInput {
    private final ItemHistogram histogram;
    private IItemCollection input = ItemCollectionToolkit.EMPTY;

    public ItemHistogramWithInput(ItemHistogram histogram) {
        this.histogram = histogram;
    }

    public void setInput(IItemCollection items) {
        this.input = items;
        ColumnViewer viewer = this.histogram.getManager().getViewer();
        ISelection prevSelection = viewer.getSelection();
        this.histogram.show(items);
        if (viewer.getSelection().equals(prevSelection)) {
            viewer.setSelection(prevSelection);
        }
    }

    public void addListener(Consumer<? super IItemCollection> listener) {
        this.histogram.getManager().getViewer().addSelectionChangedListener(e -> listener.accept(this.getItems()));
    }

    public IItemCollection getItems() {
        ItemHistogram.HistogramSelection selection = this.histogram.getSelection();
        return selection.getRowCount() == 0 ? this.input : selection.getItems();
    }

    public static Consumer<IItemCollection> chain(ItemHistogram source, Consumer<? super IItemCollection> destination, ItemHistogram ... intermediate) {
        ItemHistogramWithInput top;
        ItemHistogramWithInput prev = top = new ItemHistogramWithInput(source);
        ItemHistogram[] itemHistogramArray = intermediate;
        int n = intermediate.length;
        int n2 = 0;
        while (n2 < n) {
            ItemHistogram ih = itemHistogramArray[n2];
            ItemHistogramWithInput current = new ItemHistogramWithInput(ih);
            prev.addListener(current::setInput);
            prev = current;
            ++n2;
        }
        prev.addListener(destination);
        return top::setInput;
    }
}

