/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.swt;

import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.openjdk.jmc.joverflow.ui.swt.BreadcrumbItem;

public class Breadcrumb
extends Canvas {
    private static final int TRIM = 2;
    private Stack<BreadcrumbItem> items = new Stack();
    private Map<SelectionListener, TypedListener> selectionListeners = new HashMap<SelectionListener, TypedListener>();
    private Cursor cursor;

    public Breadcrumb(Composite parent, int style) {
        super(Breadcrumb.checkNull(parent), style);
        this.addPaintListener(this::onPaintControl);
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                Breadcrumb.this.onMouseDown(mouseEvent);
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.addMouseMoveListener(this::onMouseMove);
    }

    static Composite checkNull(Composite control) {
        if (control == null) {
            SWT.error((int)4);
        }
        return control;
    }

    void createItem(BreadcrumbItem item) {
        this.items.push(item);
        this.redraw();
    }

    private void onPaintControl(PaintEvent paintEvent) {
        Rectangle bounds = this.getClientArea();
        GC gc = paintEvent.gc;
        Color bg = gc.getBackground();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(bounds);
        int dx = 0;
        for (BreadcrumbItem item : this.items) {
            item.paintItem(paintEvent.gc, new Rectangle(bounds.x + dx, bounds.y, bounds.width - dx, bounds.height));
            dx += item.getBounds().width;
        }
        gc.setBackground(bg);
    }

    private void onMouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button != 1) {
            return;
        }
        BreadcrumbItem item = this.getItem(new Point(mouseEvent.x, mouseEvent.y));
        if (item == null) {
            return;
        }
        this.setSelection(item);
    }

    private void onMouseMove(MouseEvent mouseEvent) {
        BreadcrumbItem item = this.getItem(new Point(mouseEvent.x, mouseEvent.y));
        if (this.cursor != null && !this.cursor.isDisposed()) {
            this.cursor.dispose();
        }
        this.cursor = item == null ? new Cursor((Device)Display.getCurrent(), 0) : new Cursor((Device)Display.getCurrent(), 21);
        this.setCursor(this.cursor);
    }

    private Event createEventForItem(int type, BreadcrumbItem item) {
        Event e = new Event();
        e.display = this.getDisplay();
        e.widget = this;
        e.type = type;
        e.item = item;
        e.index = this.indexOf(item);
        if (item != null) {
            e.data = item.getData();
        }
        if (item != null && item.getBounds() != null) {
            Rectangle bounds = item.getBounds();
            e.x = bounds.x;
            e.y = bounds.y;
            e.width = bounds.width;
            e.height = bounds.height;
        }
        return e;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = 0;
        int height = 0;
        GC gc = new GC((Drawable)this);
        for (BreadcrumbItem item : this.items) {
            Point dimension = item.getDimension(gc);
            width += dimension.x;
            height = Math.max(height, dimension.y);
        }
        return new Point(Math.max(width, wHint) + 4, Math.max(height, hHint) + 4);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return new Rectangle(x - 2, y - 2, width + 4, height + 4);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.putIfAbsent(listener, new TypedListener((EventListener)listener));
        TypedListener typedListener = this.selectionListeners.get(listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        TypedListener typedListener;
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if ((typedListener = this.selectionListeners.remove(listener)) == null) {
            return;
        }
        this.removeListener(13, (Listener)typedListener);
        this.removeListener(14, (Listener)typedListener);
    }

    public Rectangle getClientArea() {
        Rectangle bounds = super.getClientArea();
        bounds.x += 2;
        bounds.y += 2;
        bounds.width -= 4;
        bounds.height -= 4;
        return bounds;
    }

    public void popItem() {
        this.checkWidget();
        this.items.pop();
        this.redraw();
    }

    public BreadcrumbItem peekItem() {
        this.checkWidget();
        return this.items.peek();
    }

    public BreadcrumbItem getItem(int index) {
        this.checkWidget();
        return (BreadcrumbItem)((Object)this.items.get(index));
    }

    public BreadcrumbItem getItem(Point point) {
        this.checkWidget();
        for (BreadcrumbItem item : this.items) {
            if (item.getBounds() == null || !item.getBounds().contains(point)) continue;
            return item;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public BreadcrumbItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new BreadcrumbItem[0]);
    }

    public BreadcrumbItem getSelection() {
        this.checkWidget();
        return this.peekItem();
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.removeFrom(index);
        Event e = this.createEventForItem(13, this.peekItem());
        this.notifyListeners(13, e);
        this.redraw();
    }

    public void setSelection(BreadcrumbItem item) {
        this.checkWidget();
        if (item != null && item.getParent() != this) {
            return;
        }
        this.setSelection(this.items.indexOf((Object)item));
    }

    public int indexOf(BreadcrumbItem item) {
        this.checkWidget();
        return this.items.indexOf((Object)item);
    }

    public void removeFrom(int start) {
        this.checkWidget();
        while (this.items.size() > start + 1) {
            this.items.pop();
        }
    }

    public void removeAll() {
        this.checkWidget();
        this.items.clear();
    }
}

