/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.openjdk.jmc.flightrecorder.configuration.events.EventConfiguration;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventConfiguration;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.EventConfigurationModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.EventConfigurationPart;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import org.openjdk.jmc.ui.wizards.IPerformFinishable;

final class AdvancedWizardPage
extends WizardPage
implements IPerformFinishable,
Observer {
    public static final String PAGE_NAME = "advancedOptionWizard";
    private static final int WIZARD_STAGE = 2;
    private EventConfigurationPart m_recordingTemplateViewer;
    private final RecordingWizardModel m_model;
    private EventConfigurationModel m_eventConfigurationModel;

    protected AdvancedWizardPage(RecordingWizardModel model) {
        super(PAGE_NAME);
        this.m_model = model;
        this.setImageDescriptor(ControlPanel.getDefault().getMCImageDescriptor("startjfrwiz.gif"));
    }

    public void createControl(Composite parent) {
        this.setDescription(Messages.ADVANCED_WIZARD_PAGE_DESCRIPTION);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.m_eventConfigurationModel = this.createEditableModel();
        this.m_recordingTemplateViewer = new EventConfigurationPart(this, this.m_eventConfigurationModel, false);
        Control settingsTree = this.m_recordingTemplateViewer.createControl(container);
        GridData gd1 = new GridData(4, 4, true, true);
        settingsTree.setLayoutData((Object)gd1);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.openjdk.jmc.flightrecorder.controlpanel.ui.recording_wizard");
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.openjdk.jmc.flightrecorder.controlpanel.ui.recording_wizard");
    }

    public boolean performFinish() {
        this.m_eventConfigurationModel.pushServerMetadataToLocalConfiguration(false);
        return true;
    }

    private EventConfigurationModel createEditableModel() {
        IEventConfiguration configuration = this.m_model.getCurrentConfigurationAt(2);
        if (configuration == null) {
            return null;
        }
        if (configuration.hasControlElements()) {
            XMLModel ourModel = ((EventConfiguration)configuration).getXMLModel();
            ourModel.setDirty(false);
            ourModel.addObserver((Observer)this);
        }
        this.setTitle(NLS.bind((String)Messages.ADVANCED_WIZARD_PAGE_TITLE, (Object)configuration.getName()));
        return EventConfigurationModel.create(configuration, this.m_model);
    }

    public void setVisible(boolean visible) {
        if (visible && this.m_recordingTemplateViewer != null) {
            this.m_recordingTemplateViewer.setInput(this.createEditableModel());
        }
        super.setVisible(visible);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof XMLModel) {
            IEventConfiguration configuration = this.m_model.getCurrentConfigurationAt(2);
            configuration.removeControlElements();
            o.deleteObserver(this);
        }
    }
}

