/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import java.util.Collection;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.parser.CachedReadBuffer;
import org.openjdk.jmc.joverflow.heap.parser.HprofParsingCancelledException;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;
import org.openjdk.jmc.joverflow.stats.ClassloaderStats;
import org.openjdk.jmc.joverflow.stats.PrimitiveArrayDuplicationMap;
import org.openjdk.jmc.joverflow.stats.StringStatsCollector;
import org.openjdk.jmc.joverflow.support.Constants;
import org.openjdk.jmc.joverflow.support.DupArrayStats;
import org.openjdk.jmc.joverflow.support.HeapStats;
import org.openjdk.jmc.joverflow.support.ShortArrayStats;
import org.openjdk.jmc.joverflow.util.ObjectToIntMap;

class OverallStatsCalculator
implements Constants {
    private final Snapshot snapshot;
    private final int ptrSize;
    private int nObjs;
    private int nObjs2ndPass;
    private volatile boolean cancelled;

    public OverallStatsCalculator(Snapshot snapshot) {
        this.snapshot = snapshot;
        this.ptrSize = snapshot.getPointerSize();
    }

    public HeapStats calculate() throws HprofParsingCancelledException {
        int objHeaderSize = this.snapshot.getObjectHeaderSize();
        long arrHeaderSize = this.snapshot.getArrayHeaderSize();
        StringStatsCollector stringStatsCollector = new StringStatsCollector(this.snapshot);
        PrimitiveArrayDuplicationMap arrayDupMap = new PrimitiveArrayDuplicationMap(this.snapshot);
        Collection<JavaLazyReadObject> allObjects = this.snapshot.getObjects();
        this.nObjs = 0;
        int nInstances = 0;
        int nObjectArrays = 0;
        long totalObjectSize = 0L;
        long totalInstSize = 0L;
        long totalObjArraySize = 0L;
        int nEntryInstances = 0;
        long entryClassSize = 0L;
        int n0LenObjArrays = 0;
        int n1ObjArrays = 0;
        int n4ObjArrays = 0;
        int n8ObjArrays = 0;
        int n0LenValArrays = 0;
        int n1LenValArrays = 0;
        int n4LenValArrays = 0;
        int n8LenValArrays = 0;
        int lenZeroObjArraySize = 0;
        int lenOneObjArraySize = 0;
        int nBoxedNumbers = 0;
        long ovhdBoxedNumbers = 0L;
        int curChunk = 0;
        ObjectToIntMap<String> unmodifiableClassInstanceCount = new ObjectToIntMap<String>(15);
        ObjectToIntMap<String> synchronizedClassInstanceCount = new ObjectToIntMap<String>(15);
        for (JavaLazyReadObject obj : allObjects) {
            ++this.nObjs;
            JavaClass clazz = obj.getClazz();
            clazz.incNumInstances();
            String clazzName = clazz.getName();
            int objSize = obj.getSize();
            totalObjectSize += (long)objSize;
            if (obj instanceof JavaObject) {
                ++nInstances;
                totalInstSize += (long)objSize;
                if (clazzName.endsWith("$Entry")) {
                    ++nEntryInstances;
                    entryClassSize += (long)objSize;
                } else if (clazzName.startsWith("java.util.Collections$Unmodifiable")) {
                    unmodifiableClassInstanceCount.putOneOrIncrement(clazzName);
                } else if (clazzName.startsWith("java.util.Collections$Synchronized")) {
                    synchronizedClassInstanceCount.putOneOrIncrement(clazzName);
                } else if (clazz.isString()) {
                    stringStatsCollector.add((JavaObject)obj);
                } else {
                    int primitiveNumSize = clazz.getBoxedNumberSize();
                    if (primitiveNumSize != 0) {
                        ++nBoxedNumbers;
                        ovhdBoxedNumbers += (long)(objSize - primitiveNumSize + this.ptrSize);
                    }
                }
            } else if (obj instanceof JavaObjectArray) {
                ++nObjectArrays;
                totalObjArraySize += (long)objSize;
                clazz.updateShallowInstanceSize(objSize);
                JavaObjectArray objArray = (JavaObjectArray)obj;
                length = objArray.getLength();
                if (length == 0) {
                    ++n0LenObjArrays;
                    if (lenZeroObjArraySize == 0) {
                        lenZeroObjArraySize = objArray.getSize();
                    }
                } else if (length == 1) {
                    ++n1ObjArrays;
                    if (lenOneObjArraySize == 0) {
                        lenOneObjArraySize = objArray.getSize();
                    }
                } else if (length <= 4) {
                    ++n4ObjArrays;
                } else if (length <= 8) {
                    ++n8ObjArrays;
                }
            } else if (obj instanceof JavaValueArray) {
                clazz.updateShallowInstanceSize(objSize);
                JavaValueArray valArray = (JavaValueArray)obj;
                length = valArray.getLength();
                if (length == 0) {
                    ++n0LenValArrays;
                } else if (length == 1) {
                    ++n1LenValArrays;
                } else if (length <= 4) {
                    ++n4LenValArrays;
                } else if (length <= 8) {
                    ++n8LenValArrays;
                }
                if (!clazz.isCharArray() && !clazz.isByteArray()) {
                    arrayDupMap.add(valArray);
                }
            }
            int newCurChunk = this.nObjs >> 17;
            if (newCurChunk <= curChunk) continue;
            curChunk = newCurChunk;
            if (!this.cancelled) continue;
            throw new HprofParsingCancelledException();
        }
        long ovhdObjectHeaders = this.nObjs * objHeaderSize;
        ObjectToIntMap.Entry<K>[] unmodifiableClasses = unmodifiableClassInstanceCount.getEntriesSortedByValueThenKey();
        ObjectToIntMap.Entry<K>[] synchronizedClasses = synchronizedClassInstanceCount.getEntriesSortedByValueThenKey();
        curChunk = 0;
        for (JavaLazyReadObject obj : allObjects) {
            JavaClass clazz;
            ++this.nObjs2ndPass;
            if (!(obj instanceof JavaValueArray) || !(clazz = obj.getClazz()).isCharArray() && !clazz.isByteArray() || obj.isVisitedAsCollectionImpl()) continue;
            JavaValueArray valArray = (JavaValueArray)obj;
            arrayDupMap.add(valArray);
            int newCurChunk = this.nObjs2ndPass >> 17;
            if (newCurChunk <= curChunk) continue;
            curChunk = newCurChunk;
            if (!this.cancelled) continue;
            throw new HprofParsingCancelledException();
        }
        arrayDupMap.calculateFinalStats();
        DupArrayStats dupArrayStats = new DupArrayStats(arrayDupMap.getNumArrays(), arrayDupMap.getNumUniqueArrays(), arrayDupMap.getNumDifferentDupArrayValues(), arrayDupMap.getDupArrays(), arrayDupMap.getDupArraysOverhead());
        ReadBuffer readBuf = this.snapshot.getReadBuffer();
        if (readBuf instanceof CachedReadBuffer) {
            ((CachedReadBuffer)readBuf).incrementPass();
        }
        ClassloaderStats clStats = new ClassloaderStats(this.snapshot);
        return new HeapStats().setGeneralStats(this.ptrSize, objHeaderSize, this.snapshot.getObjectAlignment(), this.snapshot.usingNarrowPointers(), this.snapshot.getNumClasses(), this.nObjs, nInstances, nObjectArrays, totalObjectSize, totalInstSize, totalObjArraySize).setObjOverheadStats(ovhdObjectHeaders, nEntryInstances, entryClassSize).setClassloaderStats(clStats).setShortObjArrayStats(new ShortArrayStats(n0LenObjArrays, lenZeroObjArraySize * n0LenObjArrays, n1ObjArrays, lenOneObjArraySize * n1ObjArrays, n4ObjArrays, arrHeaderSize * (long)n4ObjArrays, n8ObjArrays, arrHeaderSize * (long)n8ObjArrays)).setShortPrimitiveArrayStats(new ShortArrayStats(n0LenValArrays, arrHeaderSize * (long)n0LenValArrays, n1LenValArrays, arrHeaderSize * (long)n1LenValArrays, n4LenValArrays, arrHeaderSize * (long)n4LenValArrays, n8LenValArrays, arrHeaderSize * (long)n8LenValArrays)).setShortStringStats(stringStatsCollector.getShortStringStats()).setBoxedNumberStats(nBoxedNumbers, ovhdBoxedNumbers).setWrappedCollectionStats(unmodifiableClasses, synchronizedClasses).setDupStringStats(stringStatsCollector.getDuplicationStats()).setCompressibleStringStats(stringStatsCollector.getCompressibleStringStats()).setNumberEncodingStringStats(stringStatsCollector.getNumberEncodingStringStats()).setStringLengthHistogram(stringStatsCollector.getLengthHistogram()).setDupArrayStats(dupArrayStats);
    }

    public synchronized int getProgressPercentage() {
        return (int)((long)((this.nObjs * 3 + this.nObjs2ndPass) / 4) * 100L / (long)this.snapshot.getNumObjects());
    }

    public void cancelCalculation() {
        this.cancelled = true;
    }
}

