/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.osgi;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;
import org.jolokia.server.core.detector.ServerDetectorLookup;
import org.jolokia.server.core.http.AgentServlet;
import org.jolokia.server.core.osgi.DelegatingServerDetectorLookup;
import org.jolokia.server.core.service.api.JolokiaServiceManager;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.api.Restrictor;
import org.jolokia.server.core.service.impl.OsgiJolokiaServiceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiAgentServlet
extends AgentServlet {
    private static final long serialVersionUID = 23L;
    private BundleContext bundleContextGiven;
    private ServiceTracker<LogService, LogService> logTracker;
    private ServerDetectorLookup osgiDetectorLookup;

    public OsgiAgentServlet() {
        this((BundleContext)null);
    }

    public OsgiAgentServlet(BundleContext pContext) {
        this(pContext, null);
    }

    public OsgiAgentServlet(BundleContext pContext, Restrictor pRestrictor) {
        super(pRestrictor);
        this.bundleContextGiven = pContext;
    }

    @Override
    public void init(ServletConfig pServletConfig) throws ServletException {
        BundleContext ctx = this.getBundleContext(pServletConfig);
        this.osgiDetectorLookup = new DelegatingServerDetectorLookup(ctx);
        super.init(pServletConfig);
    }

    @Override
    protected ServerDetectorLookup getServerDetectorLookup() {
        return this.osgiDetectorLookup;
    }

    @Override
    protected LogHandler createLogHandler(ServletConfig pServletConfig, Configuration pConfiguration) {
        BundleContext ctx = this.getBundleContext(pServletConfig);
        if (ctx != null) {
            this.logTracker = new ServiceTracker(ctx, LogService.class.getName(), null);
            this.logTracker.open();
            return new ActivatorLogHandler(this.logTracker, Boolean.parseBoolean(pConfiguration.getConfig(ConfigKey.DEBUG)));
        }
        return super.createLogHandler(pServletConfig, pConfiguration);
    }

    @Override
    protected void initServices(ServletConfig pServletConfig, JolokiaServiceManager pServiceManager) {
        BundleContext ctx = this.getBundleContext(pServletConfig);
        if (ctx != null) {
            pServiceManager.addServiceLookup(new OsgiJolokiaServiceFactory(ctx));
        }
    }

    @Override
    public void destroy() {
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        this.bundleContextGiven = null;
        super.destroy();
    }

    private BundleContext getBundleContext(ServletConfig pServletConfig) {
        if (this.bundleContextGiven == null) {
            ServletContext servletContext = pServletConfig.getServletContext();
            return (BundleContext)servletContext.getAttribute("osgi-bundlecontext");
        }
        return this.bundleContextGiven;
    }

    private final class ActivatorLogHandler
    implements LogHandler {
        private final ServiceTracker<LogService, LogService> logTracker;
        private final boolean debug;

        private ActivatorLogHandler(ServiceTracker<LogService, LogService> pLogTracker, boolean pDebug) {
            this.logTracker = pLogTracker;
            this.debug = pDebug;
        }

        @Override
        public void debug(String message) {
            this.doLog(4, message);
        }

        @Override
        public void info(String message) {
            this.doLog(3, message);
        }

        private void doLog(int level, String message) {
            LogService logService = (LogService)this.logTracker.getService();
            if (logService != null) {
                logService.log(level, message);
            } else if (level != 4 || this.debug) {
                OsgiAgentServlet.this.log(message);
            }
        }

        @Override
        public void error(String message, Throwable t) {
            LogService logService = (LogService)this.logTracker.getService();
            if (logService != null) {
                logService.log(1, message, t);
            } else {
                OsgiAgentServlet.this.log(message, t);
            }
        }

        @Override
        public boolean isDebug() {
            return this.debug;
        }
    }
}

