/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.subscription.internal;

import org.openjdk.jmc.rjmx.common.subscription.IUpdatePolicy;
import org.openjdk.jmc.rjmx.common.subscription.internal.AbstractUpdatePolicy;
import org.openjdk.jmc.rjmx.common.subscription.internal.IIntervalUpdatePolicy;
import org.openjdk.jmc.rjmx.common.subscription.internal.UpdatePolicyToolkit;

public final class SimpleUpdatePolicy
extends AbstractUpdatePolicy
implements IIntervalUpdatePolicy {
    private static final SimpleUpdatePolicy DEFAULT_POLICY = new SimpleUpdatePolicy(UpdatePolicyToolkit.getDefaultUpdateInterval());
    private final int updateTime;

    private SimpleUpdatePolicy(int updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    protected long getFollowingUpdate(long lastUpdate) {
        int updateInterval = this.getIntervalTime();
        return lastUpdate - lastUpdate % (long)updateInterval + (long)updateInterval;
    }

    @Override
    public int getIntervalTime() {
        return this.updateTime;
    }

    @Override
    protected long getFirstUpdate(long now) {
        return now;
    }

    public static IUpdatePolicy newPolicy(int updateTime) {
        if (SimpleUpdatePolicy.DEFAULT_POLICY.updateTime == updateTime) {
            return DEFAULT_POLICY;
        }
        if (updateTime == -1) {
            return DEFAULT_POLICY;
        }
        return new SimpleUpdatePolicy(updateTime);
    }
}

