/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.flightrecorder.ui.DataPageDescriptor;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.JfrEditor;
import org.openjdk.jmc.flightrecorder.ui.PageManager;
import org.openjdk.jmc.flightrecorder.ui.TypeSelectorWizardPage;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.itemhandler.ItemHandlerPage;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.AdaptingLabelProvider;
import org.openjdk.jmc.ui.misc.ClipboardManager;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class JfrOutlinePage
extends ContentOutlinePage {
    private static final String HELP_CONTEXT_ID = "org.openjdk.jmc.flightrecorder.ui.JfrOutlinePage";
    static final ITreeContentProvider CONTENT_PROVIDER = new ITreeContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return ((DataPageDescriptor)parentElement).getChildren();
        }

        public Object getParent(Object element) {
            return ((DataPageDescriptor)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((DataPageDescriptor)element).hasChildren();
        }
    };
    public static final String Outline_TREE_NAME = "org.openjdk.jmc.flightrecorder.ui.editor.JfrOutlineTree";
    private static final int DND_OPERATIONS = 3;
    private static final Transfer[] DND_TRANSFER = new Transfer[]{LocalSelectionTransfer.getTransfer()};
    private static final ImageDescriptor RESET_ICON = UIPlugin.getDefault().getMCImageDescriptor("undo.gif");
    private static final IAction RESET_ALL_PAGES_ACTION = new Action(Messages.JFR_OUTLINE_RESET_ALL_ACTION, RESET_ICON){

        public void run() {
            if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.JFR_OUTLINE_RESET_ALL_CONFIRM_TITLE, (String)Messages.JFR_OUTLINE_RESET_ALL_CONFIRM_MESSAGE)) {
                FlightRecorderUI.getDefault().getPageManager().reset();
            }
        }
    };
    private static final IAction PAGE_STRUCTURE_LOCK_ACTION = JfrOutlinePage.createPageStructureLockAction();
    private final JfrEditor editor;
    private IPropertyChangeListener analysisEnabledListener;

    public JfrOutlinePage(JfrEditor editor) {
        this.editor = editor;
        this.analysisEnabledListener = e -> {
            if (e.getProperty().equals("flightrecorder.controlpanel.enable.recording.analysis")) {
                DisplayToolkit.safeAsyncExec(() -> this.refresh(true));
            }
        };
        FlightRecorderUI.getDefault().getPreferenceStore().addPropertyChangeListener(this.analysisEnabledListener);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider(this.editor.getSite().getSelectionProvider());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().getTree().setData("name", (Object)Outline_TREE_NAME);
        this.getTreeViewer().setContentProvider((IContentProvider)CONTENT_PROVIDER);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getTreeViewer().getControl(), HELP_CONTEXT_ID);
        IAction copyAction = ActionToolkit.commandAction(this::copyToClipboard, (String)"org.eclipse.ui.edit.copy");
        IAction pasteAction = ActionToolkit.commandAction(this::pasteFromClipboard, (String)"org.eclipse.ui.edit.paste");
        IAction deleteAction = ActionToolkit.commandAction(this::deleteSelected, (String)"org.eclipse.ui.edit.delete");
        IActionBars ab = this.getSite().getActionBars();
        ab.setGlobalActionHandler(copyAction.getActionDefinitionId(), copyAction);
        ab.setGlobalActionHandler(pasteAction.getActionDefinitionId(), pasteAction);
        ab.setGlobalActionHandler(deleteAction.getActionDefinitionId(), deleteAction);
        ab.updateActionBars();
        MCContextMenuManager mm = MCContextMenuManager.create((Control)this.getTreeViewer().getControl());
        mm.appendToGroup("group.new", (IContributionItem)this.createNewPageMenuManager());
        mm.appendToGroup("group.edit", ActionToolkit.action(() -> this.moveSelectedLeft(true), (String)Messages.JFR_OUTLINE_MOVE_LEFT));
        mm.appendToGroup("group.edit", ActionToolkit.action(() -> this.moveSelectedLeft(false), (String)Messages.JFR_OUTLINE_MOVE_RIGHT));
        mm.appendToGroup("group.edit", ActionToolkit.action(() -> this.moveSelectedUp(true), (String)Messages.JFR_OUTLINE_MOVE_UP));
        mm.appendToGroup("group.edit", ActionToolkit.action(() -> this.moveSelectedUp(false), (String)Messages.JFR_OUTLINE_MOVE_DOWN));
        mm.appendToGroup("group.edit", copyAction);
        mm.appendToGroup("group.edit", pasteAction);
        mm.appendToGroup("group.edit", deleteAction);
        mm.appendToGroup("group.edit", ActionToolkit.action(this::resetSelected, (String)Messages.JFR_OUTLINE_RESET_ACTION, (ImageDescriptor)RESET_ICON));
        ab.getMenuManager().add((IContributionItem)this.createNewPageMenuManager());
        ab.getToolBarManager().add(PAGE_STRUCTURE_LOCK_ACTION);
        ab.getToolBarManager().add(RESET_ALL_PAGES_ACTION);
        this.getTreeViewer().addDoubleClickListener(e -> this.expandSelected());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer());
        this.getTreeViewer().addDragSupport(3, DND_TRANSFER, (DragSourceListener)new OutlineDragListener());
        this.getTreeViewer().addDropSupport(3, DND_TRANSFER, (DropTargetListener)new OutlineDropListener(this.getTreeViewer()));
        DisplayToolkit.safeAsyncExec(this::refresh);
    }

    private MenuManager createNewPageMenuManager() {
        MenuManager newPageMenu = new MenuManager(Messages.JFR_OUTLINE_NEW_PAGE);
        newPageMenu.setRemoveAllWhenShown(true);
        newPageMenu.addMenuListener(this::fillNewPageMenu);
        return newPageMenu;
    }

    private void fillNewPageMenu(IMenuManager manager) {
        manager.add(ActionToolkit.action(this::openCreateCustomPageDialog, (String)Messages.JFR_OUTLINE_CUSTOM_PAGE));
        FlightRecorderUI.getDefault().getPageManager().getInitialPages().map(dataPageDescriptor -> new NewPageAction((DataPageDescriptor)dataPageDescriptor)).forEach(arg_0 -> ((IMenuManager)manager).add(arg_0));
    }

    private void copyToClipboard() {
        Object selected = ((IStructuredSelection)this.getTreeViewer().getSelection()).getFirstElement();
        if (selected != null) {
            ClipboardManager.setClipboardContents((Object[])new Object[]{selected}, (Transfer[])new Transfer[]{ClipboardManager.getClipboardLocalTransfer()});
        }
    }

    private void pasteFromClipboard() {
        Object onClipboard = ClipboardManager.getClipboardContents((Transfer)ClipboardManager.getClipboardLocalTransfer());
        if (onClipboard instanceof DataPageDescriptor) {
            this.addChildToSelected((DataPageDescriptor)onClipboard);
        }
    }

    private void addChildToSelected(DataPageDescriptor child) {
        Object selected = ((IStructuredSelection)this.getTreeViewer().getSelection()).getFirstElement();
        if (selected == null) {
            FlightRecorderUI.getDefault().getPageManager().makeRoot(new DataPageDescriptor(child));
        } else if (selected instanceof DataPageDescriptor) {
            FlightRecorderUI.getDefault().getPageManager().makeChild(new DataPageDescriptor(child), (DataPageDescriptor)selected, 0);
            this.getTreeViewer().setExpandedState(selected, true);
        }
    }

    private void deleteSelected() {
        Object selected = ((IStructuredSelection)this.getTreeViewer().getSelection()).getFirstElement();
        if (selected instanceof DataPageDescriptor && MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.JFR_OUTLINE_DELETE_CONFIRM_TITLE, (String)Messages.JFR_OUTLINE_DELETE_CONFIRM_MESSAGE)) {
            DataPageDescriptor dpd = (DataPageDescriptor)selected;
            DataPageDescriptor parent = dpd.getParent();
            FlightRecorderUI.getDefault().getPageManager().deletePage(dpd);
            this.getTreeViewer().refresh((Object)parent);
        }
    }

    private void resetSelected() {
        Object selected = ((IStructuredSelection)this.getTreeViewer().getSelection()).getFirstElement();
        if (selected instanceof DataPageDescriptor && MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.JFR_OUTLINE_RESET_CONFIRM_TITLE, (String)Messages.JFR_OUTLINE_RESET_CONFIRM_MESSAGE)) {
            DataPageDescriptor dpd = (DataPageDescriptor)selected;
            FlightRecorderUI.getDefault().getPageManager().resetPage(dpd);
            this.editor.displayPage(dpd);
            this.getTreeViewer().update((Object)dpd, null);
        }
    }

    private void moveSelectedUp(boolean up) {
        Object selected = ((IStructuredSelection)this.getTreeViewer().getSelection()).getFirstElement();
        if (selected instanceof DataPageDescriptor) {
            DataPageDescriptor dpd = (DataPageDescriptor)selected;
            FlightRecorderUI.getDefault().getPageManager().makeSibling(dpd, dpd, up ? -1 : 2);
        }
    }

    private void moveSelectedLeft(boolean left) {
        Object selected = ((IStructuredSelection)this.getTreeViewer().getSelection()).getFirstElement();
        if (selected instanceof DataPageDescriptor) {
            DataPageDescriptor dpd = (DataPageDescriptor)selected;
            if (!left) {
                FlightRecorderUI.getDefault().getPageManager().makeChild(dpd, dpd, -1);
            } else if (dpd.getParent() != null) {
                FlightRecorderUI.getDefault().getPageManager().makeSibling(dpd, dpd.getParent(), 1);
            }
        }
    }

    private void expandSelected() {
        Object selected = ((IStructuredSelection)this.getTreeViewer().getSelection()).getFirstElement();
        if (selected != null) {
            this.getTreeViewer().setExpandedState(selected, !this.getTreeViewer().getExpandedState(selected));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (selected != null) {
            this.editor.navigateTo((DataPageDescriptor)selected);
        }
    }

    protected int getTreeStyle() {
        return 0x10010B00;
    }

    public void dispose() {
        FlightRecorderUI.getDefault().getPreferenceStore().removePropertyChangeListener(this.analysisEnabledListener);
        super.dispose();
    }

    void refresh() {
        this.refresh(false);
    }

    private void refresh(boolean forceRefreshPages) {
        TreeViewer tv = this.getTreeViewer();
        DataPageDescriptor editorPage = this.editor.getCurrentPage();
        if (editorPage != null && tv != null && !tv.getControl().isDisposed()) {
            if (tv.getInput() == null || forceRefreshPages) {
                tv.setInput(FlightRecorderUI.getDefault().getPageManager().getRootPages());
                tv.expandToLevel(2);
            } else {
                tv.refresh();
            }
            if (((IStructuredSelection)tv.getSelection()).getFirstElement() != editorPage) {
                tv.setSelection((ISelection)new StructuredSelection((Object)editorPage));
            }
        }
    }

    private static IAction createPageStructureLockAction() {
        ImageDescriptor lockIcon = UIPlugin.getDefault().getMCImageDescriptor("lock_tree.png");
        IAction lockAction = ActionToolkit.checkAction(FlightRecorderUI.getDefault()::setPageStructureLocked, (String)Messages.JFR_OUTLINE_LOCK_PAGES_ACTION, (ImageDescriptor)lockIcon);
        lockAction.setChecked(FlightRecorderUI.getDefault().isPageStructureLocked());
        return lockAction;
    }

    private void openCreateCustomPageDialog() {
        TypeSelectorWizardPage.openDialog(this.editor.getModel().getTypeTree(), types -> {
            PageManager pm = FlightRecorderUI.getDefault().getPageManager();
            this.addChildToSelected(pm.createPage(ItemHandlerPage.Factory.class, new ItemHandlerPage.ItemHandlerUiStandIn((Set<? extends IType<?>>)types)));
        }, Messages.JFR_OUTLINE_CREATE_CUSTOM_TITLE, Messages.JFR_OUTLINE_CREATE_CUSTOM_MESSAGE);
    }

    private final class NewPageAction
    extends Action {
        private final DataPageDescriptor page;

        NewPageAction(DataPageDescriptor page) {
            super(page.getName(), page.getImageDescriptor());
            this.page = page;
        }

        public void run() {
            JfrOutlinePage.this.addChildToSelected(this.page);
        }
    }

    private final class OutlineDragListener
    extends DragSourceAdapter {
        private OutlineDragListener() {
        }

        public void dragStart(DragSourceEvent event) {
            if (PAGE_STRUCTURE_LOCK_ACTION.isChecked()) {
                event.doit = false;
            } else {
                LocalSelectionTransfer.getTransfer().setSelection(JfrOutlinePage.this.getTreeViewer().getSelection());
            }
        }

        public void dragSetData(DragSourceEvent event) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                event.data = LocalSelectionTransfer.getTransfer().getSelection();
            }
        }

        public void dragFinished(DragSourceEvent event) {
            LocalSelectionTransfer.getTransfer().setSelection(null);
        }
    }

    private static final class OutlineDropListener
    extends ViewerDropAdapter {
        public OutlineDropListener(TreeViewer viewer) {
            super((Viewer)viewer);
        }

        public boolean performDrop(Object data) {
            if (data instanceof IStructuredSelection) {
                Object selected = ((IStructuredSelection)data).getFirstElement();
                Object target = this.getCurrentTarget();
                if (selected instanceof DataPageDescriptor && (target instanceof DataPageDescriptor || target == null)) {
                    DataPageDescriptor sDPD = (DataPageDescriptor)selected;
                    DataPageDescriptor tDPD = (DataPageDescriptor)target;
                    switch (this.getCurrentOperation()) {
                        case 1: {
                            sDPD = new DataPageDescriptor(sDPD);
                        }
                        case 2: {
                            switch (this.getCurrentLocation()) {
                                case 2: {
                                    FlightRecorderUI.getDefault().getPageManager().makeSibling(sDPD, tDPD, 1);
                                    return true;
                                }
                                case 1: {
                                    FlightRecorderUI.getDefault().getPageManager().makeSibling(sDPD, tDPD, 0);
                                    return true;
                                }
                                case 3: {
                                    FlightRecorderUI.getDefault().getPageManager().makeChild(sDPD, tDPD, 0);
                                    return true;
                                }
                                case 4: {
                                    FlightRecorderUI.getDefault().getPageManager().makeRoot(sDPD);
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
            return false;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            Object selected;
            ISelection s = LocalSelectionTransfer.getTransfer().getSelection();
            if (s instanceof IStructuredSelection && !PAGE_STRUCTURE_LOCK_ACTION.isChecked() && (selected = ((IStructuredSelection)s).getFirstElement()) instanceof DataPageDescriptor) {
                boolean cyclic = target instanceof DataPageDescriptor && ((DataPageDescriptor)selected).contains((DataPageDescriptor)target);
                return !cyclic;
            }
            return false;
        }
    }

    private class OutlineLabelProvider
    extends AdaptingLabelProvider {
        private OutlineLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof DataPageDescriptor) {
                return JfrOutlinePage.this.editor.getDisplayablePage((DataPageDescriptor)element).getName();
            }
            return super.getText(element);
        }

        public String getToolTipText(Object element) {
            if (element instanceof DataPageDescriptor) {
                if (FlightRecorderUI.getDefault().isAnalysisEnabled()) {
                    return JfrOutlinePage.this.editor.getDisplayablePage((DataPageDescriptor)element).getDescription();
                }
                return null;
            }
            return super.getToolTipText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof DataPageDescriptor) {
                ImageDescriptor imageDescriptor = JfrOutlinePage.this.editor.getDisplayablePage((DataPageDescriptor)element).getImageDescriptor();
                return imageDescriptor == null ? null : (Image)this.getResourceManager().get((DeviceResourceDescriptor)imageDescriptor);
            }
            return super.getImage(element);
        }
    }
}

