/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.owasp.encoder.Encode;

public class FileReadRule
implements IRule {
    public static final TypedPreference<IQuantity> READ_WARNING_LIMIT = new TypedPreference("io.file.read.warning.limit", Messages.getString("FileReadRule_CONFIG_WARNING_LIMIT"), Messages.getString("FileReadRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(4000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(READ_WARNING_LIMIT);
    private static final String RESULT_ID = "FileRead";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.FileRead", RulesToolkit.EventAvailability.ENABLED).build();
    public static final TypedResult<IQuantity> LONGEST_READ_AMOUNT = new TypedResult("longestReadAmount", "Longest Read (Amount)", "The amount read for the longest file read.", (ContentType)UnitLookup.MEMORY, IQuantity.class);
    public static final TypedResult<IQuantity> LONGEST_READ_TIME = new TypedResult("longestReadTime", "Longest Read (Time)", "The longest time it took to perform a file read.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<String> LONGEST_READ_PATH = new TypedResult("longestReadPath", "Longest Read (Path)", "The path of the file read that took the longest time.", UnitLookup.PLAIN_TEXT, String.class);
    public static final TypedResult<IQuantity> LONGEST_TOTAL_READ = new TypedResult("totalReadForLongest", "Total Read (Top File)", "The total duration of all file reads for the file with the longest read.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> AVERAGE_FILE_READ = new TypedResult("averageFileRead", "Average File Read", "The average duration of all file reads.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> TOTAL_FILE_READ = new TypedResult("totalFileRead", "Total File Read", "The total duration of all file reads.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, LONGEST_READ_AMOUNT, LONGEST_READ_PATH, LONGEST_READ_TIME, LONGEST_TOTAL_READ, AVERAGE_FILE_READ, TOTAL_FILE_READ);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider resultProvider) {
        IQuantity warningLimit = (IQuantity)vp.getPreferenceValue(READ_WARNING_LIMIT);
        IQuantity infoLimit = warningLimit.multiply(0.5);
        IItemCollection fileReadEvents = items.apply(JdkFilters.FILE_READ);
        IItem longestEvent = (IItem)fileReadEvents.getAggregate(Aggregators.itemWithMax((IAttribute)JfrAttributes.DURATION));
        if (longestEvent == null) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).setSummary(Messages.getString("FileReadRuleFactory_TEXT_NO_EVENTS")).build();
        }
        IQuantity longestDuration = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JfrAttributes.DURATION);
        double score = RulesToolkit.mapExp100((double)longestDuration.doubleValueIn((IUnit)UnitLookup.SECOND), (double)infoLimit.doubleValueIn((IUnit)UnitLookup.SECOND), (double)warningLimit.doubleValueIn((IUnit)UnitLookup.SECOND));
        Severity severity = Severity.get((double)score);
        if (severity == Severity.WARNING || severity == Severity.INFO) {
            String longestIOPath = (String)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_PATH);
            String fileName = FileReadRule.sanitizeFileName(longestIOPath);
            IQuantity amountRead = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_FILE_BYTES_READ);
            IQuantity avgDuration = (IQuantity)fileReadEvents.getAggregate(Aggregators.avg((String)"jdk.FileRead", (IAttribute)JfrAttributes.DURATION));
            IQuantity totalDuration = (IQuantity)fileReadEvents.getAggregate(Aggregators.sum((String)"jdk.FileRead", (IAttribute)JfrAttributes.DURATION));
            IItemCollection eventsFromLongestIOPath = fileReadEvents.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.IO_PATH, (Object)longestIOPath));
            IQuantity totalLongestIOPath = (IQuantity)eventsFromLongestIOPath.getAggregate(Aggregators.sum((String)"jdk.FileRead", (IAttribute)JfrAttributes.DURATION));
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(severity).setSummary(Messages.getString("FileReadRuleFactory_TEXT_WARN")).setExplanation(Messages.getString("FileReadRuleFactory_TEXT_WARN_LONG")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(LONGEST_READ_AMOUNT, (Object)amountRead).addResult(LONGEST_READ_TIME, (Object)longestDuration).addResult(AVERAGE_FILE_READ, (Object)avgDuration).addResult(TOTAL_FILE_READ, (Object)totalDuration).addResult(LONGEST_TOTAL_READ, (Object)totalLongestIOPath).addResult(LONGEST_READ_PATH, (Object)fileName).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(severity).setSummary(Messages.getString("FileReadRuleFactory_TEXT_OK")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(LONGEST_READ_TIME, (Object)longestDuration).build();
    }

    static String sanitizeFileName(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return Encode.forHtml((String)Messages.getString("General_UNKNOWN_FILE_NAME"));
        }
        return Encode.forHtml((String)fileName);
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return FileReadRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("FileReadRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "file_io";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

