/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import io.github.bric3.fireplace.core.ui.Colors;
import io.github.bric3.fireplace.core.ui.LightDarkColor;
import io.github.bric3.fireplace.flamegraph.FrameBox;
import io.github.bric3.fireplace.flamegraph.FrameColorProvider;
import io.github.bric3.fireplace.flamegraph.FrameRenderingFlags;
import java.awt.Color;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class DimmingFrameColorProvider<T>
implements FrameColorProvider<T> {
    public static final Color DIMMED_TEXT_COLOR = new LightDarkColor(Colors.rgba(28, 43, 52, 0.68f), Colors.rgba(255, 255, 255, 0.51f));
    public static final Color ROOT_BACKGROUND_COLOR = new LightDarkColor(new Color(-1378564), new Color(-16182750));
    @NotNull
    private final @NotNull Function<@NotNull FrameBox<@NotNull T>, @NotNull Color> baseColorFunction;
    private final FrameColorProvider.ColorModel reusedColorModelForMainCanvas = new FrameColorProvider.ColorModel();
    private final FrameColorProvider.ColorModel reusedColorModelForMinimap = new FrameColorProvider.ColorModel();
    private final ConcurrentHashMap<Color, Color> dimmedColorCache = new ConcurrentHashMap();
    private Color rootBackGroundColor = ROOT_BACKGROUND_COLOR;
    private Color dimmedTextColor = DIMMED_TEXT_COLOR;

    public DimmingFrameColorProvider(@NotNull @NotNull Function<@NotNull FrameBox<@NotNull T>, @NotNull Color> baseColorFunction) {
        this.baseColorFunction = baseColorFunction;
    }

    @Override
    @NotNull
    public FrameColorProvider.ColorModel getColors(@NotNull @NotNull FrameBox<@NotNull T> frame, int flags) {
        Color foreground;
        Color backgroundColor;
        boolean rootNode = frame.isRoot();
        Color baseBackgroundColor = rootNode ? (backgroundColor = this.rootBackGroundColor) : (backgroundColor = this.baseColorFunction.apply(frame));
        if (FrameRenderingFlags.isMinimapMode(flags)) {
            return this.reusedColorModelForMinimap.set(backgroundColor, FrameColorProvider.ColorModel.DEFAULT_FRAME_FOREGROUND_COLOR);
        }
        if (!rootNode && this.shouldDim(flags)) {
            backgroundColor = this.dimmedBackground(backgroundColor);
            foreground = this.dimmedTextColor;
        } else {
            foreground = Colors.foregroundColor(backgroundColor);
        }
        if (FrameRenderingFlags.isHovered(flags)) {
            backgroundColor = this.hoverBackground(baseBackgroundColor);
            foreground = Colors.foregroundColor(backgroundColor);
        }
        if (FrameRenderingFlags.isHoveredSibling(flags)) {
            backgroundColor = this.hoverSiblingBackground(baseBackgroundColor);
            foreground = Colors.foregroundColor(backgroundColor);
        }
        return this.reusedColorModelForMainCanvas.set(backgroundColor, foreground);
    }

    @NotNull
    private Color hoverBackground(@NotNull Color backgroundColor) {
        return Colors.isDarkMode() ? Colors.brighter(backgroundColor, 1.1f, 0.95f) : Colors.darker(backgroundColor, 1.25f);
    }

    @NotNull
    private Color hoverSiblingBackground(@NotNull Color backgroundColor) {
        return this.hoverBackground(backgroundColor);
    }

    @NotNull
    protected Color dimmedBackground(@NotNull Color backgroundColor) {
        return this.cachedDim(backgroundColor);
    }

    private boolean shouldDim(int flags) {
        boolean highlighting = FrameRenderingFlags.isHighlighting(flags);
        boolean highlightedFrame = FrameRenderingFlags.isHighlightedFrame(flags);
        boolean focusing = FrameRenderingFlags.isFocusing(flags);
        boolean focusedFrame = FrameRenderingFlags.isFocusedFrame(flags);
        boolean dimmedForHighlighting = highlighting && !highlightedFrame;
        boolean dimmedForFocus = focusing && !focusedFrame;
        return (dimmedForHighlighting || dimmedForFocus) && (!highlighting || !focusing || !highlightedFrame && !focusedFrame);
    }

    @NotNull
    private Color cachedDim(@NotNull Color color) {
        return this.dimmedColorCache.computeIfAbsent(color, Colors::dim);
    }

    @NotNull
    public DimmingFrameColorProvider<T> withRootBackgroundColor(@NotNull Color rootBackgroundColor) {
        this.rootBackGroundColor = Objects.requireNonNull(rootBackgroundColor);
        return this;
    }

    @NotNull
    public DimmingFrameColorProvider<T> withDimmedTextColor(@NotNull Color dimmedTextColor) {
        this.dimmedTextColor = Objects.requireNonNull(dimmedTextColor);
        return this;
    }
}

