/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import java.util.ArrayList;
import java.util.HashMap;
import org.openjdk.jmc.joverflow.descriptors.CollectionClassDescriptor;
import org.openjdk.jmc.joverflow.descriptors.CollectionDescriptors;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.HeapStringReader;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.parser.CachedReadBuffer;
import org.openjdk.jmc.joverflow.heap.parser.HprofParsingCancelledException;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;
import org.openjdk.jmc.joverflow.stats.BarArrayHandler;
import org.openjdk.jmc.joverflow.stats.BreadthFirstHeapScanner;
import org.openjdk.jmc.joverflow.stats.DataFieldStats;
import org.openjdk.jmc.joverflow.stats.DepthFirstHeapScaner;
import org.openjdk.jmc.joverflow.stats.DupArrayHandler;
import org.openjdk.jmc.joverflow.stats.DupStringHandler;
import org.openjdk.jmc.joverflow.stats.HeapScaner;
import org.openjdk.jmc.joverflow.stats.InterimRefChain;
import org.openjdk.jmc.joverflow.stats.ObjectHistogram;
import org.openjdk.jmc.joverflow.stats.PrimitiveArrayHandler;
import org.openjdk.jmc.joverflow.stats.ProblemChecker;
import org.openjdk.jmc.joverflow.stats.SystemPropertiesReader;
import org.openjdk.jmc.joverflow.stats.WeakMapHandler;
import org.openjdk.jmc.joverflow.support.Constants;
import org.openjdk.jmc.joverflow.support.DupStringStats;
import org.openjdk.jmc.joverflow.support.HeapStats;
import org.openjdk.jmc.joverflow.support.ProblemRecorder;

class DetailedStatsCalculator
implements ProblemChecker,
Constants {
    private final Snapshot snapshot;
    private final HeapScaner scaner;
    private final ProblemRecorder problemRecorder;
    private final InterimRefChain refChain;
    private final CollectionDescriptors colDescriptors;
    private final HeapStats heapStats;
    private final int ptrSize;
    private final int objHeaderSize;
    private final int arrayHeaderSize;
    private int numCols;
    private long totalColImplSize;
    private int numEmptyUnusedCols;
    private int numEmptyUsedCols;
    private int numEmptyCols;
    private int numSmallCols;
    private int numSparseSmallCols;
    private int numSparseLargeCols;
    private int numBoxedNumberCols;
    private int numBarCols;
    private long emptyUsedColsOvhd;
    private long emptyUnusedColsOvhd;
    private long emptyColsOvhd;
    private long smallColsOvhd;
    private long sparseSmallColsOvhd;
    private long sparseLargeColsOvhd;
    private long boxedNumberColsOvhd;
    private long barColsOvhd;
    private int numObjArrays;
    private long totalObjArraysShallowSize;
    private int numLengthZeroObjArrays;
    private int numLengthOneObjArrays;
    private int numEmptyObjArrays;
    private int numSparseArrays;
    private int numBoxedNumberArrays;
    private int numBarObjArrays;
    private long lengthZeroObjArraysOvhd;
    private long lengthOneObjArraysOvhd;
    private long emptyObjArraysOvhd;
    private long sparseObjArraysOvhd;
    private long boxNumObjArraysOvhd;
    private long barObjArraysOvhd;
    private int numValueArrays;
    private int numLengthZeroValueArrays;
    private int numLengthOneValueArrays;
    private int numEmptyValueArrays;
    private int numLZTValueArrays;
    private int numUnusedHiBytesValueArrays;
    private long lengthZeroValueArraysOvhd;
    private long lengthOneValueArraysOvhd;
    private long emptyValueArraysOvhd;
    private long lztValueArraysOvhd;
    private long unusedHiBytesArraysOvhd;
    private final HeapStringReader stringReader;
    private final int stringInstShallowSize;
    private final DupStringHandler dupStringHandler;
    private final DupArrayHandler dupArrayHandler;

    public DetailedStatsCalculator(Snapshot snapshot, HeapStats heapStats, ProblemRecorder problemRecorder, boolean useBreadthFirstScan) {
        this.snapshot = snapshot;
        this.problemRecorder = problemRecorder;
        this.colDescriptors = new CollectionDescriptors(snapshot);
        this.scaner = useBreadthFirstScan ? new BreadthFirstHeapScanner(snapshot, this, problemRecorder) : new DepthFirstHeapScaner(snapshot, this, problemRecorder, this.colDescriptors);
        this.refChain = this.scaner.getRefChain();
        this.heapStats = heapStats;
        this.ptrSize = snapshot.getPointerSize();
        this.objHeaderSize = snapshot.getObjectHeaderSize();
        this.arrayHeaderSize = this.objHeaderSize + 4;
        DupStringStats dupStringStats = heapStats.dupStringStats;
        this.stringReader = snapshot.getStringReader();
        this.stringInstShallowSize = dupStringStats.stringInstShallowSize;
        this.dupStringHandler = new DupStringHandler(this.stringReader, dupStringStats.dupStrings, this.refChain, this.stringInstShallowSize);
        this.dupArrayHandler = new DupArrayHandler(heapStats.dupArrayStats.dupArrays, this.refChain);
        JavaClass[] javaClassArray = snapshot.getClasses();
        int n = javaClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass clazz = javaClassArray[n2];
            if (!clazz.isArray()) {
                clazz.setAttachment(DataFieldStats.newInstance(clazz));
            }
            ++n2;
        }
    }

    public void calculate() throws HprofParsingCancelledException {
        this.scaner.analyzeViaRoots();
        this.scaner.analyzeViaAllObjectsEnum();
        this.scaner.done();
        HashMap<String, String> systemProps = SystemPropertiesReader.readProperties(this.snapshot, this.colDescriptors);
        ReadBuffer readBuf = this.snapshot.getReadBuffer();
        if (readBuf instanceof CachedReadBuffer) {
            ((CachedReadBuffer)readBuf).incrementPass();
        }
        ArrayList<CollectionClassDescriptor> overheadsByClass = this.colDescriptors.getOverheadsByClass();
        ObjectHistogram objHisto = new ObjectHistogram(this.snapshot);
        this.heapStats.setObjectHistogram(objHisto).setCollectionNumberStats(this.numCols, this.numEmptyUnusedCols, this.numEmptyUsedCols, this.numEmptyCols, this.numSmallCols, this.numSparseSmallCols, this.numSparseLargeCols, this.numBoxedNumberCols, this.numBarCols).setCollectionOverhead(this.emptyUnusedColsOvhd, this.emptyUsedColsOvhd, this.emptyColsOvhd, this.smallColsOvhd, this.sparseSmallColsOvhd, this.sparseLargeColsOvhd, this.boxedNumberColsOvhd, this.barColsOvhd).setObjArrayNumberStats(this.numObjArrays, this.numLengthZeroObjArrays, this.numLengthOneObjArrays, this.numEmptyObjArrays, this.numSparseArrays, this.numBoxedNumberArrays, this.numBarObjArrays).setObjArrayOverhead(this.lengthZeroObjArraysOvhd, this.lengthOneObjArraysOvhd, this.emptyObjArraysOvhd, this.sparseObjArraysOvhd, this.boxNumObjArraysOvhd, this.barObjArraysOvhd).setCollectionOverheadByClass(overheadsByClass).setValueArrayNumberStats(this.numValueArrays, this.numLengthZeroValueArrays, this.numLengthOneValueArrays, this.numEmptyValueArrays, this.numLZTValueArrays, this.numUnusedHiBytesValueArrays).setValueArrayOverhead(this.lengthZeroValueArraysOvhd, this.lengthOneValueArraysOvhd, this.emptyValueArraysOvhd, this.lztValueArraysOvhd, this.unusedHiBytesArraysOvhd).setSystemProperties(systemProps);
    }

    @Override
    public CollectionInstanceDescriptor handleInstance(JavaObject obj, JavaThing[] fields) {
        JavaClass clazz = obj.getClazz();
        DataFieldStats fieldStats = (DataFieldStats)clazz.getAttachment();
        fieldStats.handleFields(fields);
        if (obj.isVisitedAsCollectionImpl()) {
            return null;
        }
        if (clazz.isCollection()) {
            return this.handleCollection(obj);
        }
        clazz.updateInclusiveInstanceSize(clazz.getInstanceSize());
        if (this.problemRecorder.shouldRecordGoodInstance(obj)) {
            this.refChain.recordCurrentRefChainForGoodInstance(obj);
        }
        return null;
    }

    private CollectionInstanceDescriptor handleCollection(JavaObject col) {
        BarArrayHandler barHandler;
        WeakMapHandler.Result result;
        WeakMapHandler wmHandler;
        CollectionInstanceDescriptor.CapacityDifferentFromSize arColDesc;
        int ovhd;
        CollectionInstanceDescriptor colDesc = this.colDescriptors.getDescriptor(col);
        CollectionClassDescriptor classDesc = colDesc.getClassDescriptor();
        JavaObject potentialParentCol = this.refChain.getPointingJavaObject();
        if (potentialParentCol != null && classDesc.isInImplementationOf(potentialParentCol.getClazz().getName())) {
            return null;
        }
        ++this.numCols;
        int implSize = colDesc.getImplSize();
        col.getClazz().updateInclusiveInstanceSize(implSize);
        this.totalColImplSize += (long)implSize;
        int nEls = colDesc.getNumElements();
        if (nEls == 0) {
            Constants.ProblemKind problemKind;
            if (colDesc.getClassDescriptor().canDetermineModCount()) {
                if (colDesc.getModCount() != 0L) {
                    problemKind = Constants.ProblemKind.EMPTY_USED;
                    ++this.numEmptyUsedCols;
                    this.emptyUsedColsOvhd += (long)implSize;
                } else {
                    problemKind = Constants.ProblemKind.EMPTY_UNUSED;
                    ++this.numEmptyUnusedCols;
                    this.emptyUnusedColsOvhd += (long)implSize;
                }
            } else {
                problemKind = Constants.ProblemKind.EMPTY;
                ++this.numEmptyCols;
                this.emptyColsOvhd += (long)implSize;
            }
            classDesc.addProblematicCollection(problemKind, implSize);
            this.refChain.recordCurrentRefChainForColCluster(col, colDesc, problemKind, implSize);
            return colDesc;
        }
        boolean goodCollection = true;
        if (colDesc instanceof CollectionInstanceDescriptor.CapacityDifferentFromSize && (ovhd = (arColDesc = (CollectionInstanceDescriptor.CapacityDifferentFromSize)((Object)colDesc)).getSparsenessOverhead(this.ptrSize)) > 0) {
            Constants.ProblemKind problemKind;
            goodCollection = false;
            if (arColDesc.getCapacity() <= arColDesc.getDefaultCapacity()) {
                problemKind = Constants.ProblemKind.SPARSE_SMALL;
                ++this.numSparseSmallCols;
                this.sparseSmallColsOvhd += (long)ovhd;
            } else {
                problemKind = Constants.ProblemKind.SPARSE_LARGE;
                ++this.numSparseLargeCols;
                this.sparseLargeColsOvhd += (long)ovhd;
            }
            classDesc.addProblematicCollection(problemKind, ovhd);
            this.refChain.recordCurrentRefChainForColCluster(col, colDesc, problemKind, ovhd);
        }
        if (nEls <= 4) {
            goodCollection = false;
            int multiplier = colDesc.getClassDescriptor().isMap() ? 2 : 1;
            ovhd = colDesc.getImplSize() - multiplier * (nEls * this.ptrSize + this.arrayHeaderSize);
            ++this.numSmallCols;
            this.smallColsOvhd += (long)ovhd;
            classDesc.addProblematicCollection(Constants.ProblemKind.SMALL, ovhd);
            this.refChain.recordCurrentRefChainForColCluster(col, colDesc, Constants.ProblemKind.SMALL, ovhd);
        }
        ovhd = 0;
        if (classDesc.isMap()) {
            JavaHeapObject[] entryObjs = colDesc.getSampleKeyAndValue();
            int totalObjSize = 0;
            int totalBoxedSize = 0;
            int numPtrs = 0;
            JavaHeapObject[] javaHeapObjectArray = entryObjs;
            int n = entryObjs.length;
            int n2 = 0;
            while (n2 < n) {
                int boxedNumSize;
                JavaHeapObject keyOrValue = javaHeapObjectArray[n2];
                if (keyOrValue != null && (boxedNumSize = keyOrValue.getClazz().getBoxedNumberSize()) > 0) {
                    totalBoxedSize += boxedNumSize;
                    totalObjSize += keyOrValue.getSize();
                    ++numPtrs;
                }
                ++n2;
            }
            if (totalBoxedSize > 0) {
                ovhd = colDesc.getImplSize() + (totalObjSize + this.ptrSize * numPtrs - totalBoxedSize) * nEls - this.arrayHeaderSize * numPtrs;
            }
        } else {
            int boxedNumSize;
            JavaHeapObject obj = colDesc.getSampleElement();
            if (obj != null && (boxedNumSize = obj.getClazz().getBoxedNumberSize()) > 0) {
                ovhd = colDesc.getImplSize() + (obj.getSize() + this.ptrSize - boxedNumSize) * nEls - this.arrayHeaderSize;
            }
        }
        if (ovhd > 0) {
            goodCollection = false;
            ++this.numBoxedNumberCols;
            this.boxedNumberColsOvhd += (long)ovhd;
            classDesc.addProblematicCollection(Constants.ProblemKind.BOXED, ovhd);
            this.refChain.recordCurrentRefChainForColCluster(col, colDesc, Constants.ProblemKind.BOXED, ovhd);
        }
        if ((wmHandler = WeakMapHandler.createInstance(colDesc)) != null && (result = wmHandler.calculateOverhead()) != null) {
            goodCollection = false;
            classDesc.addProblematicCollection(Constants.ProblemKind.WEAK_MAP_WITH_BACK_REFS, result.overhead);
            this.refChain.recordCurrentRefChainForWeakHashMapWithBackRefs(col, colDesc, result.overhead, result.valueTypeAndFieldSample);
        }
        if ((barHandler = BarArrayHandler.createInstance(colDesc, this.colDescriptors)) != null && (ovhd = barHandler.calculateOverhead()) > 0) {
            goodCollection = false;
            ++this.numBarCols;
            this.barColsOvhd += (long)ovhd;
            classDesc.addProblematicCollection(Constants.ProblemKind.BAR, ovhd);
            this.refChain.recordCurrentRefChainForColCluster(col, colDesc, Constants.ProblemKind.BAR, ovhd);
        }
        if (goodCollection) {
            this.refChain.recordCurrentRefChainForGoodCollection(col, colDesc);
        }
        return colDesc;
    }

    @Override
    public void handleObjectArray(JavaObjectArray objArray, JavaHeapObject[] elements) {
        int ovhd;
        BarArrayHandler barHandler;
        if (objArray.isVisitedAsCollectionImpl()) {
            return;
        }
        ++this.numObjArrays;
        int arraySize = objArray.getSize();
        this.totalObjArraysShallowSize += (long)arraySize;
        objArray.getClazz().updateInclusiveInstanceSize(arraySize);
        boolean goodArray = true;
        if (elements.length == 0) {
            CollectionClassDescriptor classDesc = this.colDescriptors.getStandaloneArrayDescriptor(objArray);
            ++this.numLengthZeroObjArrays;
            int ovhd2 = arraySize;
            this.lengthZeroObjArraysOvhd += (long)ovhd2;
            classDesc.addProblematicCollection(Constants.ProblemKind.LENGTH_ZERO, ovhd2);
            this.refChain.recordCurrentRefChainForColCluster(objArray, new ArrayObjDescriptor(classDesc, 0, arraySize), Constants.ProblemKind.LENGTH_ZERO, ovhd2);
            return;
        }
        if (elements.length == 1) {
            goodArray = false;
            CollectionClassDescriptor classDesc = this.colDescriptors.getStandaloneArrayDescriptor(objArray);
            ++this.numLengthOneObjArrays;
            int ovhd3 = arraySize;
            this.lengthOneObjArraysOvhd += (long)ovhd3;
            classDesc.addProblematicCollection(Constants.ProblemKind.LENGTH_ONE, ovhd3);
            this.refChain.recordCurrentRefChainForColCluster(objArray, new ArrayObjDescriptor(classDesc, 0, arraySize), Constants.ProblemKind.LENGTH_ONE, ovhd3);
        }
        int nNullEntries = 0;
        boolean boxedNumsPresent = false;
        int totalBoxedNumOvhd = 0;
        JavaHeapObject[] javaHeapObjectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            JavaHeapObject element = javaHeapObjectArray[n2];
            if (element != null) {
                int primitiveNumSize = element.getClazz().getBoxedNumberSize();
                if (primitiveNumSize > 0) {
                    boxedNumsPresent = true;
                    totalBoxedNumOvhd += this.ptrSize - primitiveNumSize;
                    JavaLazyReadObject elementObj = (JavaLazyReadObject)element;
                    if (!elementObj.isVisitedAsOther()) {
                        elementObj.setVisitedAsOther();
                        totalBoxedNumOvhd += element.getSize();
                    }
                }
            } else {
                ++nNullEntries;
            }
            ++n2;
        }
        CollectionClassDescriptor classDesc = this.colDescriptors.getStandaloneArrayDescriptor(objArray);
        ArrayObjDescriptor arrayDesc = new ArrayObjDescriptor(classDesc, elements.length, arraySize);
        if (nNullEntries > elements.length / 2) {
            goodArray = false;
            if (nNullEntries == elements.length) {
                ++this.numEmptyObjArrays;
                ovhd = objArray.getSize();
                this.emptyObjArraysOvhd += (long)ovhd;
                classDesc.addProblematicCollection(Constants.ProblemKind.EMPTY, ovhd);
                this.refChain.recordCurrentRefChainForColCluster(objArray, arrayDesc, Constants.ProblemKind.EMPTY, ovhd);
            } else {
                ++this.numSparseArrays;
                ovhd = nNullEntries * this.ptrSize;
                this.sparseObjArraysOvhd += (long)ovhd;
                classDesc.addProblematicCollection(Constants.ProblemKind.SPARSE_ARRAY, ovhd);
                this.refChain.recordCurrentRefChainForColCluster(objArray, arrayDesc, Constants.ProblemKind.SPARSE_ARRAY, ovhd);
            }
        }
        if (boxedNumsPresent) {
            ++this.numBoxedNumberArrays;
            if (totalBoxedNumOvhd > 0) {
                goodArray = false;
                this.boxNumObjArraysOvhd += (long)totalBoxedNumOvhd;
                classDesc.addProblematicCollection(Constants.ProblemKind.BOXED, totalBoxedNumOvhd);
                this.refChain.recordCurrentRefChainForColCluster(objArray, arrayDesc, Constants.ProblemKind.BOXED, totalBoxedNumOvhd);
            }
        }
        if ((barHandler = BarArrayHandler.createInstance(elements, this.colDescriptors)) != null && (ovhd = barHandler.calculateOverhead()) > 0) {
            goodArray = false;
            ++this.numBarObjArrays;
            this.barObjArraysOvhd += (long)ovhd;
            classDesc.addProblematicCollection(Constants.ProblemKind.BAR, ovhd);
            this.refChain.recordCurrentRefChainForColCluster(objArray, arrayDesc, Constants.ProblemKind.BAR, ovhd);
        }
        if (goodArray) {
            this.refChain.recordCurrentRefChainForGoodCollection(objArray, arrayDesc);
        }
    }

    @Override
    public void handleValueArray(JavaValueArray valueArray) {
        int ovhd;
        if (valueArray.isVisitedAsCollectionImpl()) {
            return;
        }
        ++this.numValueArrays;
        valueArray.getClazz().updateInclusiveInstanceSize(valueArray.getSize());
        boolean goodArray = true;
        byte[] data = valueArray.getValue();
        int elSize = valueArray.getElementSize();
        int numElements = data.length / elSize;
        CollectionClassDescriptor classDesc = this.colDescriptors.getStandaloneArrayDescriptor(valueArray);
        ArrayObjDescriptor arrayDesc = new ArrayObjDescriptor(classDesc, numElements, valueArray.getSize());
        char elementType = valueArray.getElementType();
        PrimitiveArrayHandler pah = PrimitiveArrayHandler.createInstance(data, elSize, elementType == 'F' || elementType == 'D');
        if (pah.isLength0()) {
            ++this.numLengthZeroValueArrays;
            int ovhd2 = valueArray.getSize();
            this.lengthZeroValueArraysOvhd += (long)ovhd2;
            classDesc.addProblematicCollection(Constants.ProblemKind.LENGTH_ZERO, ovhd2);
            this.refChain.recordCurrentRefChainForColCluster(valueArray, arrayDesc, Constants.ProblemKind.LENGTH_ZERO, ovhd2);
            return;
        }
        if (pah.isLength1()) {
            goodArray = false;
            ++this.numLengthOneValueArrays;
            ovhd = valueArray.getSize() + this.ptrSize - elSize;
            this.lengthOneValueArraysOvhd += (long)ovhd;
            classDesc.addProblematicCollection(Constants.ProblemKind.LENGTH_ONE, ovhd);
            this.refChain.recordCurrentRefChainForColCluster(valueArray, arrayDesc, Constants.ProblemKind.LENGTH_ONE, ovhd);
        }
        if (pah.isEmpty()) {
            goodArray = false;
            ++this.numEmptyValueArrays;
            ovhd = valueArray.getSize();
            this.emptyValueArraysOvhd += (long)ovhd;
            classDesc.addProblematicCollection(Constants.ProblemKind.EMPTY, ovhd);
            this.refChain.recordCurrentRefChainForColCluster(valueArray, arrayDesc, Constants.ProblemKind.EMPTY, ovhd);
        }
        if ((ovhd = pah.getLztOverhead()) > 0) {
            goodArray = false;
            ++this.numLZTValueArrays;
            this.lztValueArraysOvhd += (long)ovhd;
            classDesc.addProblematicCollection(Constants.ProblemKind.LZT, ovhd);
            this.refChain.recordCurrentRefChainForColCluster(valueArray, arrayDesc, Constants.ProblemKind.LZT, ovhd);
        }
        if ((ovhd = pah.getUnusedHighBytesOvhd()) > 0) {
            goodArray = false;
            ++this.numUnusedHiBytesValueArrays;
            this.unusedHiBytesArraysOvhd += (long)ovhd;
            classDesc.addProblematicCollection(Constants.ProblemKind.UNUSED_HI_BYTES, ovhd);
            this.refChain.recordCurrentRefChainForColCluster(valueArray, arrayDesc, Constants.ProblemKind.UNUSED_HI_BYTES, ovhd);
        }
        if (goodArray) {
            this.refChain.recordCurrentRefChainForGoodCollection(valueArray, arrayDesc);
        }
        this.dupArrayHandler.handleArray(valueArray);
    }

    @Override
    public void handleString(JavaObject strObj) {
        JavaValueArray backingCharArray;
        JavaClass stringClazz = strObj.getClazz();
        stringClazz.updateInclusiveInstanceSize(this.stringInstShallowSize);
        boolean duplicated = this.dupStringHandler.handleString(strObj);
        int implInclusiveSize = this.stringInstShallowSize;
        JavaValueArray javaValueArray = backingCharArray = duplicated ? this.dupStringHandler.getLastReadBackingArray() : this.stringReader.getCharArrayForString(strObj);
        if (backingCharArray != null && !backingCharArray.isVisited()) {
            int backingCharArraySize = backingCharArray.getSize();
            stringClazz.updateInclusiveInstanceSize(backingCharArraySize);
            backingCharArray.setVisited();
            implInclusiveSize += backingCharArraySize;
            this.scaner.incrementCurrentProcessedObjNo();
        }
        if (!duplicated) {
            this.refChain.recordCurrentRefChainForNonDupString(strObj, implInclusiveSize);
        }
    }

    public int getProgressPercentage() {
        return this.scaner.getProgressPercentage();
    }

    public void cancelCalculation() {
        this.scaner.cancelCalculation();
    }

    private static class ArrayObjDescriptor
    implements CollectionInstanceDescriptor {
        private static final String NOT_SUPPORTED = "is not supported for arrays";
        private final CollectionClassDescriptor classDesc;
        private final int numElements;
        private final int arraySize;

        ArrayObjDescriptor(CollectionClassDescriptor classDesc, int numElements, int arraySize) {
            this.classDesc = classDesc;
            this.numElements = numElements;
            this.arraySize = arraySize;
        }

        @Override
        public CollectionClassDescriptor getClassDescriptor() {
            return this.classDesc;
        }

        @Override
        public int getNumElements() {
            return this.numElements;
        }

        @Override
        public int getImplSize() {
            return this.arraySize;
        }

        @Override
        public void iterateList(CollectionInstanceDescriptor.ListIteratorCallback cb) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void iterateMap(CollectionInstanceDescriptor.MapIteratorCallback cb) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JavaHeapObject getSampleElement() {
            throw new UnsupportedOperationException("Getting sample element is not supported for arrays");
        }

        @Override
        public JavaHeapObject[] getSampleKeyAndValue() {
            throw new UnsupportedOperationException("Getting sample key/value is not supported for arrays");
        }

        @Override
        public long getModCount() {
            throw new UnsupportedOperationException("Getting modCount is not supported for arrays");
        }

        @Override
        public boolean hasExtraObjFields() {
            return false;
        }

        @Override
        public void filterExtraObjFields(JavaThing[] fields) {
            throw new UnsupportedOperationException("Filtering extra obj fields is not supported for arrays");
        }
    }
}

