/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards;

import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormText;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.unit.IDescribedMap;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.Environment;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventConfiguration;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.TemplateLabelProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.TemplateManagerWizardPage;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.TemplateProvider;
import org.openjdk.jmc.ui.common.resource.MCFile;
import org.openjdk.jmc.ui.misc.QuantityKindProposal;

public class RecordingWizardPage
extends WizardPage {
    private static final int VISIBLE_ITEMS_IN_COMBO = 10;
    public static final String COMPONENT_ID = "recordingwizard";
    public static final String PAGE_NAME = "startRecordingWizard";
    public static final String EDIT_PAGE_NAME = "editRecordingWizard";
    private static final int WIZARD_STAGE = 0;
    private TemplateProvider m_comboProvider;
    private ComboViewer m_comboViewer;
    private Text m_description;
    private Text m_filenameText;
    private Button m_fixedOption;
    private Text m_durationText;
    private Text m_delayText;
    private Button m_continuousOption;
    private Text m_maxSizeText;
    private Text m_maxAgeText;
    private FormText m_infoText;
    protected Text m_nameText;
    private final RecordingWizardModel m_model;
    private final boolean m_displayMaxAge;
    private final boolean m_displayMaxSize;
    private final boolean m_displaySettingsDescription;
    private final boolean m_displayInfo;
    private final boolean m_displayHelp;
    private final boolean m_displayDelay;
    private boolean m_disableSettingsForContinuous;
    private boolean m_disableNameForContinuous;
    private final Observer m_modelObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            RecordingWizardPage.this.setMessage(RecordingWizardPage.this.getModel().getWarningMessage(), 2);
            RecordingWizardPage.this.setErrorMessage(RecordingWizardPage.this.getModel().checkForErrors(RecordingWizardPage.this.m_comboProvider.hasExtraTemplate()));
            RecordingWizardPage.this.setPageComplete(RecordingWizardPage.this.getErrorMessage() == null);
            if (arg != null && arg.equals("jreVersionChanged")) {
                RecordingWizardPage.this.m_comboProvider.setVersion(RecordingWizardPage.this.m_model.getVersion());
                RecordingWizardPage.this.refreshTemplateCombo();
            }
        }
    };

    public RecordingWizardPage(RecordingWizardModel model, boolean displayMaxAge, boolean displayMaxSize, boolean displaySettingsDescription, boolean displayInfo, boolean displayHelp, boolean displayDelay, boolean disableSettingsForContinuous, boolean disableNameForContinuous) {
        super(model.isEditing() ? EDIT_PAGE_NAME : PAGE_NAME);
        this.m_model = model;
        this.m_displayMaxAge = displayMaxAge;
        this.m_displayMaxSize = displayMaxSize;
        this.m_displaySettingsDescription = displaySettingsDescription;
        this.m_displayInfo = displayInfo;
        this.m_displayHelp = displayHelp;
        this.m_displayDelay = displayDelay;
        this.m_disableSettingsForContinuous = disableSettingsForContinuous;
        this.m_disableNameForContinuous = disableNameForContinuous;
        this.setImageDescriptor(ControlPanel.getDefault().getMCImageDescriptor("startjfrwiz.gif"));
        this.m_model.addObserver(this.m_modelObserver);
    }

    public RecordingWizardPage(RecordingWizardModel model) {
        this(model, true, true, true, true, true, false, false, false);
    }

    public IWizardPage getNextPage() {
        IWizardPage next = this.m_model.getCurrentConfigurationAt(0).hasControlElements() ? this.getWizard().getPage("recordingEventOptionsWizard") : this.getWizard().getPage("advancedOptionWizard");
        return next;
    }

    public void createControl(Composite parent) {
        Shell shell;
        FormText infoText;
        this.initializeDialogUnits((Control)parent);
        int indent = this.convertWidthInCharsToPixels(4);
        if (this.m_model.isEditing()) {
            this.setTitle(Messages.EDIT_RECORDING_WIZARD_PAGE_TITLE);
            this.setDescription(Messages.EDIT_RECORDING_WIZARD_PAGE_DESCRIPTION);
        } else {
            this.setTitle(Messages.START_RECORDING_WIZARD_PAGE_TITLE);
            this.setDescription(Messages.START_RECORDING_WIZARD_PAGE_DESCRIPTION);
        }
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite container = new Composite((Composite)sc, 0);
        sc.setContent((Control)container);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, true, false);
        Composite settingsContainer = this.createSettingsContainer(container, indent);
        settingsContainer.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        Label separator = this.createSeparator(container);
        separator.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, true, false);
        Composite templateContainer = this.createTemplateContainer(container);
        templateContainer.setLayoutData((Object)gd3);
        Composite descriptionContainer = this.createDescriptionControls(container);
        if (descriptionContainer != null) {
            GridData gdd = new GridData(4, 4, true, true);
            descriptionContainer.setLayoutData((Object)gdd);
        }
        if ((infoText = this.createInfoText(container)) != null) {
            GridData gd4 = new GridData(4, 4, true, false);
            infoText.setLayoutData((Object)gd4);
        }
        this.refreshTemplateCombo();
        this.selectInitialOption();
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(container.computeSize(-1, -1));
        this.setControl((Control)sc);
        if (Environment.getOSType() == Environment.OSType.LINUX && (shell = this.getShell()) != null) {
            shell.layout();
        }
        if (this.m_displayHelp) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.openjdk.jmc.flightrecorder.controlpanel.ui.recording_wizard");
        }
    }

    public void performHelp() {
        if (this.m_displayHelp) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.openjdk.jmc.flightrecorder.controlpanel.ui.recording_wizard");
        }
    }

    private FormText createInfoText(Composite parent) {
        if (this.m_displayInfo) {
            this.m_infoText = new FormText(parent, 0);
            return this.m_infoText;
        }
        return null;
    }

    void selectInitialOption() {
        boolean fixedRecording = this.m_model.isFixedRecording();
        this.setContinuous(!fixedRecording);
    }

    public boolean isPageComplete() {
        return this.getModel().checkForErrors(this.m_comboProvider.hasExtraTemplate()) == null;
    }

    private void createTemplateControls(Composite parent, int cols) {
        GridData gd0 = new GridData(4, 4, false, false);
        Label label = this.createLabel(parent, Messages.LABEL_TEMPLATE);
        label.setLayoutData((Object)gd0);
        GridData gd1 = new GridData(4, 4, true, true);
        gd1.horizontalSpan = cols - 2;
        this.m_comboProvider = this.createTemplateProvider();
        this.m_comboViewer = this.createSelector(parent, (IContentProvider)this.m_comboProvider);
        this.m_comboViewer.getControl().setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, false, false);
        Button templateManagerButton = this.createTemplateManagerButton(parent);
        templateManagerButton.setLayoutData((Object)gd2);
        this.hookSelectionListener();
    }

    protected TemplateProvider createTemplateProvider() {
        return new TemplateProvider(this.m_model.getVersion());
    }

    private void hookSelectionListener() {
        this.m_comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IEventConfiguration config = RecordingWizardPage.this.getSelectedTemplate();
                if (config == null || RecordingWizardPage.this.m_comboProvider.clearExtraTemplateUnless(config)) {
                    RecordingWizardPage.this.m_comboViewer.refresh();
                }
                RecordingWizardPage.this.setDescriptionText(config);
                RecordingWizardPage.this.m_model.setActiveConfigurationTemplate(RecordingWizardPage.this.getSelectedTemplate());
            }
        });
    }

    private Button createTemplateManagerButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.BUTTON_TEMPLATE_MANAGER_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecordingWizardPage.this.openTemplateManager();
            }
        });
        return button;
    }

    public void refreshTemplateCombo() {
        IEventConfiguration config = this.m_model.getCurrentConfigurationAt(0);
        if (config != null && config.isDeletable() && !this.m_model.getTemplateRepository().contains(config)) {
            this.m_comboProvider.setExtraTemplate(config);
        } else {
            this.m_comboProvider.setExtraTemplate(null);
        }
        this.m_comboViewer.refresh();
        this.setTemplate(config);
    }

    private IEventConfiguration getSelectedTemplate() {
        IStructuredSelection ss = (IStructuredSelection)this.m_comboViewer.getSelection();
        return (IEventConfiguration)(!ss.isEmpty() ? ss.getFirstElement() : null);
    }

    private void setDescriptionText(IEventConfiguration rt) {
        if (this.m_description != null && !this.m_description.isDisposed()) {
            String description = rt != null ? rt.getDescription() : "";
            this.m_description.setText(description);
            this.m_description.setToolTipText(description);
        }
    }

    private Composite createSettingsContainer(Composite parent, int indent) {
        Composite container = new Composite(parent, 0);
        int cols = 5;
        GridLayout layout = new GridLayout(cols, false);
        layout.horizontalSpacing = 8;
        container.setLayout((Layout)layout);
        this.createFileNameInput(container, cols);
        this.createName(container, cols);
        this.createTimeFixedOptions(container, indent, cols);
        this.createContinuousOptions(container, indent, cols);
        this.setContinuous(this.m_model.isContinuous());
        return container;
    }

    private void createContinuousOptions(Composite container, int indent, int cols) {
        if (this.shouldHaveContinuousControls()) {
            this.createContinuousOption(container, cols);
            this.createMaxSize(container, indent, cols);
            this.createMaxAge(container, indent, cols);
        }
    }

    private void createFileNameInput(Composite parent, int cols) {
        GridData gd1 = new GridData(1, 0x1000000, false, false);
        Label label = this.createLabel(parent, Messages.LABEL_FILENAME_TEXT);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 0x1000000, true, true);
        gd2.horizontalSpan = cols - 2;
        this.m_filenameText = this.createFilenameText(parent);
        gd2.minimumWidth = 0;
        gd2.widthHint = 400;
        this.m_filenameText.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, false, true);
        Button browseButton = this.createFilenameBrowseButton(parent);
        browseButton.setLayoutData((Object)gd3);
        this.setFileName(this.m_model.getPath());
    }

    private Text createFilenameText(Composite parent) {
        Text text = new Text(parent, 2056);
        text.setEnabled(false);
        return text;
    }

    private Button createFilenameBrowseButton(Composite parent) {
        final Button button = new Button(parent, 0);
        button.setText(Messages.BUTTON_BROWSE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MCFile path = ControlPanel.openRecordingFileBrowser(RecordingWizardPage.this.getModel().getPath());
                if (path != null) {
                    RecordingWizardPage.this.setFileName(path);
                    RecordingWizardPage.this.getModel().setPath(path);
                }
                button.setFocus();
            }
        });
        return button;
    }

    private void createName(Composite parent, int cols) {
        GridData gd1 = new GridData(4, 4, false, true);
        Label label = this.createLabel(parent, Messages.LABEL_NAME_TEXT);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = cols - 1;
        this.m_nameText = this.createNameText(parent);
        this.m_nameText.setLayoutData((Object)gd2);
    }

    private Text createNameText(Composite parent) {
        final Text text = new Text(parent, 2048);
        this.findToolTipText((Control)text, "name");
        text.setText(this.m_model.getName());
        text.setEditable(!this.m_model.isEditing());
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingWizardPage.this.getModel().setName(text.getText());
            }
        });
        return text;
    }

    private void createTimeFixedOptions(Composite parent, int indent, int cols) {
        if (this.shouldHaveDurationControl()) {
            this.createTimeFixedOption(parent, cols);
            this.createDuration(parent, indent, cols);
            this.createDelay(parent, indent, cols);
        }
    }

    private void createTimeFixedOption(Composite parent, int cols) {
        GridData gd1 = new GridData(4, 4, true, true);
        gd1.horizontalSpan = cols;
        this.m_fixedOption = new Button(parent, 16);
        this.m_fixedOption.setText(Messages.BUTTON_TIME_FIXED_RECORDING_TEXT);
        this.m_fixedOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RecordingWizardPage.this.m_fixedOption.getSelection()) {
                    RecordingWizardPage.this.setContinuous(false);
                    RecordingWizardPage.this.storeContinuous(false);
                }
            }
        });
        this.m_fixedOption.setLayoutData((Object)gd1);
    }

    private void createDuration(Composite parent, int indent, int cols) {
        GridData gd1 = new GridData(4, 4, false, true);
        gd1.horizontalIndent = indent;
        Label label = this.createLabel(parent, Messages.LABEL_RECORDING_TIME_TEXT);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = cols - 1;
        Text text = this.createDurationText(parent);
        text.setLayoutData((Object)gd2);
    }

    private Text createDurationText(Composite parent) {
        this.m_durationText = new Text(parent, 2048);
        this.findToolTipText((Control)this.m_durationText, "duration");
        this.m_durationText.setText(this.m_model.getDurationString());
        QuantityKindProposal.install((Text)this.m_durationText, (KindOfQuantity)UnitLookup.TIMESPAN);
        this.m_durationText.setData("name", (Object)"recordingwizard.duration");
        this.m_durationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingWizardPage.this.getModel().setDuration(RecordingWizardPage.this.m_durationText.getText());
            }
        });
        return this.m_durationText;
    }

    private void createDelay(Composite parent, int indent, int cols) {
        if (this.m_displayDelay) {
            GridData gd1 = new GridData(4, 4, false, true);
            gd1.horizontalIndent = indent;
            Label label = this.createLabel(parent, Messages.LABEL_DELAY_TIME_TEXT);
            label.setLayoutData((Object)gd1);
            GridData gd2 = new GridData(4, 4, true, true);
            gd2.horizontalSpan = cols - 1;
            Text text = this.createDelayText(parent);
            text.setLayoutData((Object)gd2);
        }
    }

    private Text createDelayText(Composite parent) {
        this.m_delayText = new Text(parent, 2048);
        this.m_delayText.setText(this.getModel().getDelayString());
        QuantityKindProposal.install((Text)this.m_delayText, (KindOfQuantity)UnitLookup.TIMESPAN);
        this.m_delayText.setData("name", (Object)"recordingwizard.delay");
        this.m_delayText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingWizardPage.this.getModel().setDelay(RecordingWizardPage.this.m_delayText.getText());
            }
        });
        return this.m_delayText;
    }

    private void createMaxSize(Composite parent, int indent, int cols) {
        if (this.m_displayMaxSize) {
            GridData gd1 = new GridData(4, 4, false, true);
            gd1.horizontalIndent = indent;
            Label label = this.createLabel(parent, Messages.LABEL_MAX_SIZE);
            label.setLayoutData((Object)gd1);
            GridData gd2 = new GridData(4, 4, true, true);
            gd2.horizontalSpan = cols - 1;
            Text text = this.createMaxSizeText(parent);
            text.setLayoutData((Object)gd2);
        }
    }

    private Text createMaxSizeText(Composite parent) {
        this.m_maxSizeText = new Text(parent, 2048);
        this.m_maxSizeText.setText(this.m_model.getMaxSizeString());
        QuantityKindProposal.install((Text)this.m_maxSizeText, (KindOfQuantity)UnitLookup.MEMORY);
        this.findToolTipText((Control)this.m_maxSizeText, "maxSize");
        this.m_maxSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingWizardPage.this.getModel().setMaxSize(RecordingWizardPage.this.m_maxSizeText.getText());
            }
        });
        return this.m_maxSizeText;
    }

    private void createMaxAge(Composite parent, int indent, int cols) {
        if (this.m_displayMaxAge) {
            GridData gd1 = new GridData(4, 4, false, true);
            gd1.horizontalIndent = indent;
            Label label = this.createLabel(parent, Messages.LABEL_MAX_AGE);
            label.setLayoutData((Object)gd1);
            GridData gd2 = new GridData(4, 4, true, true);
            gd2.horizontalSpan = cols - 1;
            Text text = this.createMaxAgeText(parent);
            text.setLayoutData((Object)gd2);
        }
    }

    private Text createMaxAgeText(Composite parent) {
        this.m_maxAgeText = new Text(parent, 2048);
        this.m_maxAgeText.setText(this.m_model.getMaxAgeString());
        QuantityKindProposal.install((Text)this.m_maxAgeText, (KindOfQuantity)UnitLookup.TIMESPAN);
        this.findToolTipText((Control)this.m_maxAgeText, "maxAge");
        this.m_maxAgeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingWizardPage.this.getModel().setMaxAge(RecordingWizardPage.this.m_maxAgeText.getText());
            }
        });
        return this.m_maxAgeText;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    protected void setFixedRecordingControlsEnabled(boolean fixed) {
        if (this.m_fixedOption != null) {
            this.m_fixedOption.setSelection(fixed);
        }
        if (this.m_durationText != null) {
            this.m_durationText.setEnabled(fixed);
        }
        if (this.m_delayText != null) {
            this.m_delayText.setEnabled(fixed);
        }
        if (fixed) {
            this.setInfoText(Messages.RECORDING_WIZARD_PAGE_DURATION_NOTE);
        }
    }

    protected void setContinuousRecordingControlsEnabled(boolean continuous) {
        if (this.m_continuousOption != null) {
            this.m_continuousOption.setSelection(continuous);
        }
        if (this.m_maxAgeText != null) {
            this.m_maxSizeText.setEnabled(continuous);
        }
        if (this.m_maxSizeText != null) {
            this.m_maxAgeText.setEnabled(continuous);
        }
        if (this.m_nameText != null) {
            this.m_nameText.setEnabled(!continuous || !this.m_disableNameForContinuous);
        }
        if (this.m_comboViewer != null) {
            this.m_comboViewer.getControl().setEnabled(!continuous || !this.m_disableSettingsForContinuous);
        }
        if (continuous) {
            this.setInfoText(Messages.RECORDING_WIZARD_PAGE_CONTINUOUS_NOTE);
        }
    }

    protected void setInfoText(String info) {
        if (this.m_infoText != null) {
            this.m_infoText.setText(info, true, false);
        }
    }

    private void createContinuousOption(Composite parent, int cols) {
        GridData gd1 = new GridData(4, 4, true, true);
        gd1.horizontalSpan = cols;
        this.m_continuousOption = new Button(parent, 16);
        this.m_continuousOption.setText(Messages.BUTTON_CONTINUOUS_RECORDING_TEXT);
        this.m_continuousOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RecordingWizardPage.this.m_continuousOption.getSelection()) {
                    RecordingWizardPage.this.setContinuous(true);
                    RecordingWizardPage.this.storeContinuous(true);
                }
            }
        });
        this.m_continuousOption.setLayoutData((Object)gd1);
    }

    private void storeContinuous(boolean continuous) {
        if (!this.getModel().isEditing()) {
            this.getModel().setFixedRecording(!continuous);
        }
    }

    private boolean shouldHaveDurationControl() {
        return !this.m_model.isEditing() || this.m_model.isFixedRecording();
    }

    private boolean shouldHaveContinuousControls() {
        return !this.m_model.isEditing() || !this.m_model.isFixedRecording();
    }

    private void findToolTipText(Control control, String key) {
        IDescribable descriptor;
        IDescribedMap<String> options = this.m_model.getAvailableRecordingOptions();
        if (options != null && (descriptor = options.getDescribable((Object)key)) != null) {
            control.setToolTipText(descriptor.getDescription());
        }
    }

    protected void openTemplateManager() {
        Dialog dialog = TemplateManagerWizardPage.createDialogFor(this.getShell(), this.m_model.getTemplateRepository(), this.m_model.getEventOptions(), this.m_model.getEventTypeInfoMap(), this.m_model.getVersion());
        dialog.open();
        this.refreshTemplateCombo();
    }

    private Composite createTemplateContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        int cols = 5;
        GridLayout layout = new GridLayout(cols, false);
        container.setLayout((Layout)layout);
        this.createTemplateControls(container, cols);
        return container;
    }

    protected Composite createDescriptionControls(Composite parent) {
        if (this.m_displaySettingsDescription) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout());
            GridData gd1 = new GridData(4, 4, false, false);
            Label label = this.createLabel(container, Messages.LABEL_TEMPLATE_DESCRIPTION);
            label.setLayoutData((Object)gd1);
            GridData gd2 = new GridData(4, 4, true, true);
            gd2.heightHint = 40;
            gd2.minimumWidth = 0;
            Control description = this.createDescriptionText(container);
            description.setLayoutData((Object)gd2);
            return container;
        }
        return null;
    }

    private Control createDescriptionText(Composite parent) {
        this.m_description = new Text(parent, 2634);
        this.m_description.setEnabled(true);
        return this.m_description;
    }

    protected Label createSeparator(Composite parent) {
        return new Label(parent, 258);
    }

    private ComboViewer createSelector(Composite parent, IContentProvider contentProvider) {
        ComboViewer comboViewer = new ComboViewer(parent);
        comboViewer.getCombo().setVisibleItemCount(10);
        comboViewer.setContentProvider(contentProvider);
        comboViewer.setInput((Object)this.m_model.getTemplateRepository());
        comboViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider(false));
        return comboViewer;
    }

    public void setContinuous(boolean continuous) {
        this.setContinuousRecordingControlsEnabled(continuous);
        this.setFixedRecordingControlsEnabled(!continuous);
    }

    public void setDuration(String duration) {
        this.m_durationText.setText(duration);
    }

    public void setDelay(String delayString) {
        this.m_delayText.setText(delayString);
    }

    public void setName(String name) {
        this.m_nameText.setText(name);
    }

    public void setFileName(MCFile path) {
        this.m_filenameText.setText(path.getPath());
        this.m_filenameText.setToolTipText(path.getPath());
    }

    public void setBehaviorForContinuous(boolean disableSettingsForContinuous, boolean disableNameForContinous) {
        this.m_disableSettingsForContinuous = disableSettingsForContinuous;
        this.m_disableNameForContinuous = disableNameForContinous;
        this.setContinuous(this.m_continuousOption.getSelection());
    }

    public void setTemplate(IEventConfiguration selectConfig) {
        if (selectConfig != null) {
            if (Arrays.asList(this.m_comboProvider.getElements(this.getModel().getTemplateRepository())).contains(selectConfig)) {
                this.m_comboViewer.setSelection((ISelection)new StructuredSelection((Object)selectConfig), true);
            } else {
                this.m_comboViewer.setSelection(null, true);
            }
        }
    }

    private RecordingWizardModel getModel() {
        return this.m_model;
    }
}

