/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.viewers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.ui.model.MemoryStatisticsItem;
import org.openjdk.jmc.joverflow.ui.model.ObjectCluster;
import org.openjdk.jmc.joverflow.ui.swt.ArcItem;
import org.openjdk.jmc.joverflow.ui.swt.FilterList;
import org.openjdk.jmc.joverflow.ui.util.ColorIndexedArcAttributeProvider;
import org.openjdk.jmc.joverflow.ui.viewers.BaseViewer;
import org.openjdk.jmc.joverflow.ui.viewers.MemoryStatisticsTableViewer;
import org.openjdk.jmc.joverflow.ui.viewers.PieChartViewer;

public class AncestorViewer
extends BaseViewer {
    private final SashForm mContainer;
    private final PieChartViewer mPieChart;
    private final FilterList<RefChainElement> mFilterList;
    private final Text mInput;
    private final MemoryStatisticsTableViewer mTableViewer;
    private String mPrefix = "";
    private RefChainElement lastRef;
    private MemoryStatisticsItem lastItem;
    private final Map<Object, MemoryStatisticsItem> items = new HashMap<Object, MemoryStatisticsItem>();
    private boolean mAllIncluded = false;

    public AncestorViewer(Composite parent, int style) {
        this.mContainer = new SashForm(parent, style);
        Composite leftContainer = new Composite((Composite)this.mContainer, 2048);
        leftContainer.setLayout((Layout)new FormLayout());
        Label title = new Label(leftContainer, 0);
        title.setText("Ancestor Referrer");
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        title.setLayoutData((Object)data);
        Button update = new Button(leftContainer, 0);
        update.setText("Update");
        update.addListener(13, event -> this.updatePrefixFilter());
        FormData data2 = new FormData();
        data2.bottom = new FormAttachment(100, -10);
        data2.right = new FormAttachment(100, -10);
        update.setLayoutData((Object)data2);
        this.mInput = new Text(leftContainer, 2048);
        this.mInput.setMessage("Ancestor prefix");
        this.mInput.addListener(31, event -> {
            if (event.detail == 4) {
                this.updatePrefixFilter();
            }
        });
        FormData fd_text = new FormData();
        fd_text.right = new FormAttachment((Control)update, -10);
        fd_text.bottom = new FormAttachment((Control)update, 0, 0x1000000);
        fd_text.left = new FormAttachment(0, 10);
        this.mInput.setLayoutData((Object)fd_text);
        SashForm container = new SashForm(leftContainer, 512);
        FormData fd_sashForm = new FormData();
        fd_sashForm.bottom = new FormAttachment((Control)update, -10);
        fd_sashForm.top = new FormAttachment((Control)title, 10);
        fd_sashForm.right = new FormAttachment(100, -10);
        fd_sashForm.left = new FormAttachment(0, 10);
        container.setLayoutData((Object)fd_sashForm);
        this.mPieChart = new PieChartViewer((Composite)container, 0);
        this.mPieChart.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColorIndexedArcAttributeProvider provider = new ColorIndexedArcAttributeProvider(){

            @Override
            public int getWeight(Object element) {
                return (int)((MemoryStatisticsItem)element).getMemory();
            }
        };
        provider.setMinimumArcAngle(5);
        this.mPieChart.setArcAttributeProvider(provider);
        this.mPieChart.setMinimumArcAngle(5);
        this.mPieChart.getPieChart().setZoomRatio(1.2);
        this.mPieChart.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return (int)(((MemoryStatisticsItem)e2).getMemory() - ((MemoryStatisticsItem)e1).getMemory());
            }
        });
        this.mFilterList = new FilterList((Composite)container, 0);
        this.mFilterList.addFilterChangedListener(this::notifyFilterChangedListeners);
        container.setWeights(new int[]{3, 2});
        Composite tableContainer = new Composite((Composite)this.mContainer, 2048);
        tableContainer.setLayout((Layout)new FillLayout(256));
        this.mTableViewer = new MemoryStatisticsTableViewer(tableContainer, 0);
        final BiConsumer<MemoryStatisticsItem, Boolean> addFilter = (item, exclusion) -> {
            if (item.getId() == null) {
                return;
            }
            this.mFilterList.addFilter(new Predicate<RefChainElement>(item, exclusion){
                final String ancestor;
                final boolean excluded;
                {
                    this.ancestor = memoryStatisticsItem.getId().toString();
                    this.excluded = bl;
                }

                @Override
                public boolean test(RefChainElement referrer) {
                    while (referrer != null) {
                        String refName = referrer.toString();
                        if (this.ancestor.equals(refName)) {
                            return !this.excluded;
                        }
                        referrer = referrer.getReferer();
                    }
                    return this.excluded;
                }

                public String toString() {
                    return "Ancestors" + (this.excluded ? " \u220c " : " \u220b ") + this.ancestor;
                }

                public int hashCode() {
                    return this.ancestor.hashCode();
                }

                public boolean equals(Object obj) {
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    return this.hashCode() == obj.hashCode();
                }
            });
        };
        this.mPieChart.getPieChart().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                ArcItem item = AncestorViewer.this.mPieChart.getPieChart().getHighlightedItem();
                if (item == null) {
                    return;
                }
                if (item.getData() == null) {
                    return;
                }
                addFilter.accept((MemoryStatisticsItem)item.getData(), e.button != 1);
            }
        });
        this.mTableViewer.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                if (e.button != 1 && e.button != 3) {
                    return;
                }
                if (AncestorViewer.this.mTableViewer.getSelection().isEmpty()) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)AncestorViewer.this.mTableViewer.getSelection();
                MemoryStatisticsItem item = (MemoryStatisticsItem)selection.getFirstElement();
                addFilter.accept(item, e.button != 1);
            }
        });
        this.mContainer.setWeights(new int[]{1, 2});
        this.mTableViewer.setPieChartViewer(this.mPieChart);
        this.mPieChart.setTableViewer(this.mTableViewer);
    }

    public Control getControl() {
        return this.mContainer;
    }

    public ISelection getSelection() {
        return this.mTableViewer.getSelection();
    }

    public void refresh() {
        this.mTableViewer.refresh();
        this.mPieChart.refresh();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.mTableViewer.setSelection(selection, reveal);
        this.mPieChart.setSelection(selection, reveal);
    }

    private String getAncestorReferrer(RefChainElement referrer) {
        while (referrer != null) {
            if (referrer.getJavaClass() == null) {
                if (referrer.getReferer() == null) break;
                FlightRecorderUI.getDefault().getLogger().warning("JavaClass for " + String.valueOf(referrer) + " is null but referrer is " + String.valueOf(referrer.getReferer()));
                break;
            }
            if (referrer.toString().startsWith(this.mPrefix)) {
                return referrer.toString();
            }
            referrer = referrer.getReferer();
        }
        return null;
    }

    @Override
    public void include(ObjectCluster oc, RefChainElement ref) {
        if (this.mAllIncluded) {
            for (MemoryStatisticsItem item : this.items.values()) {
                item.reset();
            }
            this.mAllIncluded = false;
        }
        if (ref != this.lastRef) {
            this.lastRef = ref;
            String s = this.getAncestorReferrer(ref);
            this.lastItem = this.items.get(s);
            if (this.lastItem == null) {
                this.lastItem = new MemoryStatisticsItem(s, 0L, 0L, 0);
                this.items.put(s, this.lastItem);
            }
        }
        this.lastItem.addObjectCluster(oc);
    }

    @Override
    public void allIncluded() {
        Collection<MemoryStatisticsItem> values = this.items.values();
        ((MemoryStatisticsTableViewer.MemoryStatisticsContentProvider)this.mTableViewer.getContentProvider()).setInput(values);
        this.mPieChart.setInput(values);
        this.mAllIncluded = true;
        this.lastRef = null;
    }

    private void updatePrefixFilter() {
        this.mPrefix = this.mInput.getText();
        if (this.mTableViewer != null) {
            this.notifyFilterChangedListeners();
        }
    }

    @Override
    public void setHeapSize(long size) {
        this.mTableViewer.setHeapSize(size);
    }

    @Override
    public boolean filter(ObjectCluster oc) {
        return true;
    }

    @Override
    public boolean filter(RefChainElement rce) {
        return this.mFilterList.filter(rce);
    }

    @Override
    public void reset() {
        this.mFilterList.reset();
        this.mInput.setText("");
        this.updatePrefixFilter();
    }
}

