/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.batch;

import org.openjdk.jmc.joverflow.util.MemNumFormatter;

final class FormattedOutputBuffer {
    private final StringBuilder sb = new StringBuilder(32000);
    private final StringBuilder csb = new StringBuilder(1000);
    private final MemNumFormatter nf;
    private final long totalHeapSize;
    private String currentSection;
    private String currentIssue;
    private double currentCriticalLevelInPercent;
    private boolean criticalIssuesInCurrentSectionFound;

    FormattedOutputBuffer(long totalHeapSize) {
        this.totalHeapSize = totalHeapSize;
        this.nf = new MemNumFormatter(totalHeapSize);
    }

    void print(String s) {
        this.sb.append(s);
    }

    void println(String s) {
        this.sb.append(s);
        this.sb.append('\n');
    }

    void println() {
        this.sb.append('\n');
    }

    void format(String format, Object ... args) {
        String result = String.format(format, args);
        this.sb.append(result);
    }

    String k(long num) {
        return this.nf.getNumInKAndPercent(num);
    }

    void startSection(String sectionName, String issueName, double criticalLevelInPercent) {
        this.currentSection = sectionName;
        this.currentIssue = issueName;
        this.currentCriticalLevelInPercent = criticalLevelInPercent;
        this.sb.append('\n');
        this.sb.append(sectionName);
        this.sb.append("\n");
        this.criticalIssuesInCurrentSectionFound = false;
    }

    void startSection(String sectionName) {
        this.startSection(sectionName, "", 0.0);
    }

    void criticalCheck(long ovhd, String issueQualifier) {
        if ((double)ovhd / (double)this.totalHeapSize * 100.0 <= this.currentCriticalLevelInPercent) {
            return;
        }
        if (!this.criticalIssuesInCurrentSectionFound) {
            this.csb.append("\n Section ");
            this.csb.append(this.currentSection);
            this.csb.append(" (overhead > ");
            this.csb.append((int)this.currentCriticalLevelInPercent);
            this.csb.append("% reported):\n");
            this.criticalIssuesInCurrentSectionFound = true;
        }
        this.csb.append("  ");
        this.csb.append(this.currentIssue);
        this.csb.append(" ");
        this.csb.append(issueQualifier);
        this.csb.append(" ");
        this.csb.append(this.nf.getNumInKAndPercent(ovhd));
        this.csb.append('\n');
    }

    MemNumFormatter getMemNumFormatter() {
        return this.nf;
    }

    String getOutput() {
        if (this.csb.length() > 0) {
            this.csb.insert(0, "0. IMPORTANT ISSUES OVERVIEW:\n");
            this.csb.append('\n');
            this.sb.insert(0, this.csb);
        }
        return this.sb.toString();
    }
}

