/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.wizard;

import java.util.Collection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.console.ui.notification.NotificationPlugin;
import org.openjdk.jmc.console.ui.notification.wizard.ActionWizardPage;
import org.openjdk.jmc.console.ui.notification.wizard.ConstraintWizardPage;
import org.openjdk.jmc.console.ui.notification.wizard.Messages;
import org.openjdk.jmc.console.ui.notification.wizard.NameWizardPage;
import org.openjdk.jmc.console.ui.notification.wizard.TriggerConditionWizardPage;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.common.subscription.IMRIService;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.MRIMetadataToolkit;
import org.openjdk.jmc.rjmx.triggers.ITriggerAction;
import org.openjdk.jmc.rjmx.triggers.IValueEvaluator;
import org.openjdk.jmc.rjmx.triggers.TriggerRule;
import org.openjdk.jmc.rjmx.triggers.condition.internal.TriggerCondition;
import org.openjdk.jmc.rjmx.triggers.extension.internal.TriggerFactory;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationRegistry;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationTrigger;
import org.openjdk.jmc.rjmx.triggers.internal.ValueEvaluatorStringMatch;
import org.openjdk.jmc.rjmx.ui.internal.AttributeConfiguratorWizardPage;
import org.openjdk.jmc.rjmx.ui.internal.AttributeSelectionContentModel;
import org.openjdk.jmc.rjmx.ui.internal.AttributeSelectionViewModel;
import org.openjdk.jmc.rjmx.ui.internal.AttributeSelectorWizardPage;
import org.openjdk.jmc.rjmx.ui.internal.IAttributeSelectionContentListener;

public class RuleWizard
extends Wizard {
    private final TriggerRule m_noticationRule;
    private final IConnectionHandle m_connectionHandle;
    private final NotificationRegistry m_notificationModel;
    private final String NAME_NOT_SET = Messages.RuleWizard_DEFAULT_RULE_NAME;
    private AttributeSelectionContentModel m_selectorModel;

    public RuleWizard(IConnectionHandle connectionHandle, TriggerRule rule, String ruleGroupName, NotificationRegistry notificationModel) {
        this.initializeDefaultPageImageDescriptor();
        this.m_connectionHandle = connectionHandle;
        this.setDialogSettings(NotificationPlugin.getDefault().getDialogSettings());
        if (rule == null) {
            this.m_noticationRule = this.createRule((TriggerFactory)notificationModel.getFactory());
            this.m_noticationRule.setRulePath(ruleGroupName);
            this.setWindowTitle(Messages.RuleWizard_WINDOW_TITLE);
        } else {
            this.m_noticationRule = rule;
            this.setWindowTitle(NLS.bind((String)Messages.RuleWizard_WINDOW_TITLE_EDIT, (Object)this.m_noticationRule.getName()));
        }
        this.m_notificationModel = notificationModel;
    }

    public void addPages() {
        AttributeSelectionViewModel viewModel = new AttributeSelectionViewModel(null, false, false, Messages.RuleWizard_WINDOW_TITLE, Messages.AttributeSelectionWizardPage_TITLE, Messages.AttributeSelectionWizardPage_DESCRIPTION, Messages.AttributeConfigurationWizardPage_TITLE, Messages.AttributeConfigurationWizardPage_DESCRIPTION);
        this.m_selectorModel = new AttributeSelectionContentModel((IMRIService)this.m_connectionHandle.getServiceOrDummy(IMRIService.class), (IMRIMetadataService)this.m_connectionHandle.getServiceOrDummy(IMRIMetadataService.class), null, null);
        this.addPage((IWizardPage)new AttributeSelectorWizardPage(viewModel, this.m_selectorModel));
        this.addPage((IWizardPage)new AttributeConfiguratorWizardPage(viewModel, this.m_selectorModel));
        this.addPage((IWizardPage)new TriggerConditionWizardPage(this.m_selectorModel, this.m_notificationModel, this.m_connectionHandle, this.m_noticationRule));
        this.addPage((IWizardPage)new ActionWizardPage(this.m_notificationModel, this.m_connectionHandle, this.m_noticationRule));
        this.addPage((IWizardPage)new ConstraintWizardPage(this.m_notificationModel, this.m_noticationRule));
        this.addPage((IWizardPage)new NameWizardPage(this.m_notificationModel, this.m_noticationRule));
        this.m_selectorModel.addListener(new IAttributeSelectionContentListener(){

            public void selectionChanged(AttributeSelectionContentModel selectorModel) {
                MRI[] selectedAttributes = selectorModel.getSelectedAttributes();
                if (selectedAttributes.length > 0) {
                    boolean linkConfigurePage = false;
                    IMRIMetadataService metadataService = selectorModel.getMetadataService();
                    MRI[] mRIArray = selectedAttributes;
                    int n = selectedAttributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IUnit unit;
                        MRI mri = mRIArray[n2];
                        IMRIMetadata metadata = metadataService.getMetadata(mri);
                        if (MRIMetadataToolkit.isNumerical((IMRIMetadata)metadata) && (unit = UnitLookup.getUnitOrNull((String)metadata.getUnitString())) == null) {
                            linkConfigurePage = true;
                        }
                        ++n2;
                    }
                    if (linkConfigurePage) {
                        RuleWizard.this.getAttributeSelectorWizardPage().setNextPage((IWizardPage)RuleWizard.this.getAttributeConfiguratorWizardPage());
                    } else {
                        RuleWizard.this.getAttributeSelectorWizardPage().setNextPage((IWizardPage)RuleWizard.this.getTriggerConditionWizardPage());
                    }
                }
            }
        });
    }

    private AttributeSelectorWizardPage getAttributeSelectorWizardPage() {
        return (AttributeSelectorWizardPage)this.getPage("org.openjdk.jmc.rjmx.attribute.selection");
    }

    private AttributeConfiguratorWizardPage getAttributeConfiguratorWizardPage() {
        return (AttributeConfiguratorWizardPage)this.getPage("org.openjdk.jmc.rjmx.attribute.configuration");
    }

    private TriggerConditionWizardPage getTriggerConditionWizardPage() {
        return (TriggerConditionWizardPage)this.getPage("org.openjdk.jmc.notification.trigger.condition");
    }

    private TriggerRule createRule(TriggerFactory factory) {
        TriggerCondition condition = (TriggerCondition)factory.createTrigger();
        condition.setValueEvaluator((IValueEvaluator)new ValueEvaluatorStringMatch("*"));
        if (condition.getFieldHolder() == null) {
            condition.initFieldHolder();
        }
        ITriggerAction action = null;
        Collection actions = factory.getActionExtensions().getPrototypes();
        for (Object protoAction : actions) {
            String className = protoAction.getClass().getName();
            if (!className.endsWith("ApplicationAlert")) continue;
            try {
                action = factory.createAction(protoAction.getClass().getName());
            }
            catch (Exception exception) {
                NotificationPlugin.getDefault().getLogger().warning("Could not instantiate the default application alert action! Looking for any action next.");
            }
        }
        if (action == null && actions.size() > 0) {
            try {
                action = factory.createAction(actions.iterator().next().getClass().getName());
            }
            catch (Exception exception) {
                NotificationPlugin.getDefault().getLogger().severe("Could not instantiate any default action when creating the rule!");
            }
        }
        return new TriggerRule(this.NAME_NOT_SET, (NotificationTrigger)condition, action);
    }

    public TriggerRule getRule() {
        return this.m_noticationRule;
    }

    public boolean performFinish() {
        this.m_selectorModel.commitUnitChanges();
        if (this.m_noticationRule.getName().equals(this.NAME_NOT_SET)) {
            this.m_noticationRule.setName(this.getSuggestedName());
        }
        return true;
    }

    public String getSuggestedName() {
        NotificationTrigger trigger = this.m_noticationRule.getTrigger();
        IMRIMetadataService manager = (IMRIMetadataService)this.m_connectionHandle.getServiceOrDummy(IMRIMetadataService.class);
        IMRIMetadata info = manager.getMetadata(trigger.getAttributeDescriptor());
        String attributeName = MRIMetadataToolkit.getDisplayName((IConnectionHandle)this.m_connectionHandle, (MRI)info.getMRI());
        String evalCondition = trigger.getValueEvaluator().getEvaluationConditionString();
        String sugggestedName = attributeName + " " + evalCondition;
        int i = 2;
        while (!this.m_notificationModel.isNameAvailable(sugggestedName)) {
            sugggestedName = attributeName + " " + evalCondition + " " + i;
            ++i;
        }
        return sugggestedName;
    }

    private void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(NotificationPlugin.getDefault().getMCImageDescriptor("new-trigger-wiz.gif"));
    }
}

