/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.attributes;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.rjmx.subscription.internal.UpdatePolicyToolkit;
import org.openjdk.jmc.rjmx.ui.attributes.Messages;
import org.openjdk.jmc.ui.misc.QuantityKindProposal;

public class UpdateIntervalDialog
extends InputDialog {
    public UpdateIntervalDialog(Shell parentShell, int initialValue) {
        super(parentShell, Messages.UpdateIntervalDialog_DIALOG_TITLE, Messages.UpdateIntervalDialog_DIALOG_MESSAGE, UnitLookup.MILLISECOND.quantity((long)initialValue).interactiveFormat(), UpdateIntervalDialog.createValidator());
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        QuantityKindProposal.install((Text)this.getText(), (KindOfQuantity)UnitLookup.TIMESPAN);
        return control;
    }

    private static IInputValidator createValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                try {
                    UpdateIntervalDialog.parseInterval(newText);
                    return null;
                }
                catch (QuantityConversionException e) {
                    return e.getLocalizedMessage();
                }
            }
        };
    }

    public int getUpdateInterval() {
        try {
            return UpdateIntervalDialog.parseInterval(this.getValue());
        }
        catch (QuantityConversionException quantityConversionException) {
            return UpdatePolicyToolkit.getDefaultUpdateInterval();
        }
    }

    private static int parseInterval(String value) throws QuantityConversionException {
        ITypedQuantity q = UnitLookup.TIMESPAN.parseInteractive(value);
        int interval = (int)q.longValueIn((IUnit)UnitLookup.MILLISECOND, Integer.MAX_VALUE);
        if (interval <= 0) {
            throw QuantityConversionException.tooLow((IQuantity)q, (IQuantity)UnitLookup.MILLISECOND.quantity(1L));
        }
        return interval;
    }
}

