/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.management.MalformedObjectNameException;
import org.jolokia.server.core.request.JolokiaExecRequest;
import org.jolokia.server.core.request.JolokiaListRequest;
import org.jolokia.server.core.request.JolokiaNotificationRequest;
import org.jolokia.server.core.request.JolokiaReadRequest;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.JolokiaSearchRequest;
import org.jolokia.server.core.request.JolokiaVersionRequest;
import org.jolokia.server.core.request.JolokiaWriteRequest;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.request.RequestCreator;
import org.jolokia.server.core.util.EscapeUtil;
import org.jolokia.server.core.util.RequestType;

public final class JolokiaRequestFactory {
    private static final Map<RequestType, RequestCreator<?>> CREATOR_MAP = new HashMap();

    private JolokiaRequestFactory() {
    }

    public static <R extends JolokiaRequest> R createGetRequest(String pPathInfo, ProcessingParameters pProcessingParameters) {
        RequestType type = null;
        try {
            String pathInfo = JolokiaRequestFactory.extractPathInfo(pPathInfo, pProcessingParameters);
            Stack<String> elements = EscapeUtil.extractElementsFromPath(pathInfo);
            type = !elements.isEmpty() ? RequestType.getTypeByName(elements.pop()) : RequestType.VERSION;
            return (R)JolokiaRequestFactory.getCreator(type).create(elements, pProcessingParameters);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name. " + e.getMessage(), e);
        }
        catch (EmptyStackException exp) {
            throw new IllegalArgumentException("Invalid arguments in pathinfo " + pPathInfo + (String)(type != null ? " for command " + String.valueOf(type) : ""), exp);
        }
    }

    public static <R extends JolokiaRequest> R createPostRequest(Map<String, ?> pRequestMap, ProcessingParameters pProcessingParams) {
        try {
            ProcessingParameters paramsMerged = pProcessingParams.mergedParams((Map)pRequestMap.get("config"));
            RequestType type = RequestType.getTypeByName((String)pRequestMap.get("type"));
            return (R)JolokiaRequestFactory.getCreator(type).create(pRequestMap, paramsMerged);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name. " + e.getMessage(), e);
        }
    }

    public static List<JolokiaRequest> createPostRequests(List<?> pJsonRequests, ProcessingParameters pProcessingParams) {
        ArrayList<JolokiaRequest> ret = new ArrayList<JolokiaRequest>();
        for (Object o : pJsonRequests) {
            if (!(o instanceof Map)) {
                throw new IllegalArgumentException("Not a request within the list of requests " + String.valueOf(pJsonRequests) + ". Expected map, but found: " + String.valueOf(o));
            }
            ret.add((JolokiaRequest)JolokiaRequestFactory.createPostRequest((Map)o, pProcessingParams));
        }
        return ret;
    }

    private static String extractPathInfo(String pPathInfo, ProcessingParameters pProcessingParams) {
        String pathInfo = pPathInfo;
        if (pProcessingParams != null && (pPathInfo == null || pPathInfo.isEmpty() || pathInfo.matches("^/+$"))) {
            pathInfo = pProcessingParams.getPathInfo();
        }
        return JolokiaRequestFactory.normalizePathInfo(pathInfo);
    }

    private static String normalizePathInfo(String pPathInfo) {
        if (pPathInfo != null && !pPathInfo.isEmpty()) {
            return pPathInfo.startsWith("/") ? pPathInfo.substring(1) : pPathInfo;
        }
        return "";
    }

    private static RequestCreator<?> getCreator(RequestType pType) {
        RequestCreator<?> creator = CREATOR_MAP.get((Object)pType);
        if (creator == null) {
            throw new UnsupportedOperationException("Type " + String.valueOf((Object)pType) + " is not supported (yet)");
        }
        return creator;
    }

    static {
        CREATOR_MAP.put(RequestType.READ, JolokiaReadRequest.newCreator());
        CREATOR_MAP.put(RequestType.WRITE, JolokiaWriteRequest.newCreator());
        CREATOR_MAP.put(RequestType.EXEC, JolokiaExecRequest.newCreator());
        CREATOR_MAP.put(RequestType.LIST, JolokiaListRequest.newCreator());
        CREATOR_MAP.put(RequestType.VERSION, JolokiaVersionRequest.newCreator());
        CREATOR_MAP.put(RequestType.SEARCH, JolokiaSearchRequest.newCreator());
        CREATOR_MAP.put(RequestType.NOTIFICATION, JolokiaNotificationRequest.newCreator());
    }
}

