/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.jvm;

import org.openjdk.jmc.common.jvm.Connectable;
import org.openjdk.jmc.common.jvm.JVMArch;
import org.openjdk.jmc.common.jvm.JVMType;

public class JVMDescriptor {
    private final String javaVersion;
    private final JVMType jvmType;
    private final String jvmName;
    private final String jvmVendor;
    private final JVMArch jvmArch;
    private final String javaCommand;
    private final String jvmArguments;
    private final Integer pid;
    private final Boolean debug;
    private final Connectable connectable;

    public JVMDescriptor(String javaVersion, JVMType jvmType, JVMArch jvmArch, String javaCommand, String jvmArguments, String jvmName, String jvmVendor, Integer pid, boolean debug, Connectable attachable) {
        this.javaVersion = javaVersion;
        this.jvmType = jvmType;
        this.jvmArch = jvmArch;
        this.javaCommand = javaCommand;
        this.jvmArguments = jvmArguments;
        this.jvmName = jvmName;
        this.jvmVendor = jvmVendor;
        this.pid = pid;
        this.debug = debug;
        this.connectable = attachable;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public JVMType getJvmType() {
        return this.jvmType;
    }

    public JVMArch getJvmArch() {
        return this.jvmArch;
    }

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public String getJVMArguments() {
        return this.jvmArguments;
    }

    public String getJvmName() {
        return this.jvmName;
    }

    public String getJvmVendor() {
        return this.jvmVendor;
    }

    public Integer getPid() {
        return this.pid;
    }

    public Boolean isDebug() {
        return this.debug;
    }

    public Boolean isUnconnectable() {
        return this.connectable.isUnconnectable();
    }

    public Boolean isAttachable() {
        return this.connectable.isAttachable();
    }

    public String toString() {
        return "[JVMDescriptor] Java command: " + this.getJavaCommand() + " PID: " + this.getPid();
    }
}

