/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.dial;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.ui.accessibility.FocusTracker;
import org.openjdk.jmc.ui.dial.DialConfiguration;
import org.openjdk.jmc.ui.dial.DialConfigurationPage;
import org.openjdk.jmc.ui.dial.DialInformationProvider;
import org.openjdk.jmc.ui.dial.DialInformationViewer;
import org.openjdk.jmc.ui.dial.DialViewer;
import org.openjdk.jmc.ui.dial.Messages;
import org.openjdk.jmc.ui.dial.MovingDial;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;
import org.openjdk.jmc.ui.wizards.OnePageWizardDialog;

public class Dial
extends Composite {
    private static final String LAST_DIAL_ID = "last";
    private static final String MAX_DIAL_ID = "max";
    private DialConfiguration m_dialConfiguration;
    private final DialViewer m_dialViewer;
    private final DialInformationViewer m_dialInformationViewer;
    private final StackLayout stackLayout = new StackLayout();

    public Dial(Composite parent, FormToolkit formToolkit, DialConfiguration dialConfiguration) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.m_dialViewer = new DialViewer(this, 0);
        FocusTracker.enableFocusTracking(this.m_dialViewer);
        this.m_dialViewer.setLayoutData(new GridData(4, 4, true, false));
        formToolkit.adapt((Composite)this.m_dialViewer);
        Composite infoPart = new Composite((Composite)this, 0);
        infoPart.setLayoutData((Object)new GridData(4, 4, true, false));
        infoPart.setLayout((Layout)this.stackLayout);
        CLabel noValuesYetLabel = new CLabel(infoPart, 0x1000000);
        noValuesYetLabel.setText(Messages.DialViewer_NO_VALUE_YET_TEXT);
        formToolkit.adapt((Composite)noValuesYetLabel);
        this.stackLayout.topControl = noValuesYetLabel;
        this.m_dialInformationViewer = new DialInformationViewer(infoPart, formToolkit, 262144);
        formToolkit.adapt((Composite)this.m_dialInformationViewer);
        formToolkit.paintBordersFor((Composite)this);
        formToolkit.adapt((Composite)this);
        this.setDialConfiguration(dialConfiguration);
    }

    public void setTitle(String title) {
        this.m_dialViewer.setTitle(title);
    }

    public void setUnit(IUnit unit) {
        this.m_dialViewer.setUnit(unit);
        this.updateDials();
    }

    private void updateDials() {
        IUnit unit = this.m_dialViewer.getUnit();
        if (unit != null) {
            if (this.m_dialConfiguration.getUseWatermark()) {
                this.m_dialInformationViewer.setProviders(new DialInformationProvider(LAST_DIAL_ID, unit, Messages.DIAL_LAST_VALUE_TEXT), new DialInformationProvider(MAX_DIAL_ID, unit, Messages.DIAL_MAX_VALUE_TEXT));
                this.m_dialViewer.setProviders(new MovingDial(MAX_DIAL_ID, this.m_dialConfiguration.getWatermarkColor()), new MovingDial(LAST_DIAL_ID));
            } else {
                this.m_dialInformationViewer.setProviders(new DialInformationProvider(LAST_DIAL_ID, unit, Messages.DIAL_LAST_VALUE_TEXT));
                this.m_dialViewer.setProviders(new MovingDial(LAST_DIAL_ID));
            }
        }
    }

    public void setDialConfiguration(DialConfiguration dialConfiguration) {
        this.m_dialConfiguration = dialConfiguration;
        this.m_dialViewer.setGradientRange(dialConfiguration.getGradientBeginValue(), dialConfiguration.getGradientEndValue(), SWTColorToolkit.asRGB(dialConfiguration.getGradientBeginColor()), SWTColorToolkit.asRGB(dialConfiguration.getGradientEndColor()));
        this.updateDials();
    }

    public void setInput(Number last, Number max, boolean refreshNeedles) {
        this.m_dialViewer.setInput(LAST_DIAL_ID, last);
        this.m_dialInformationViewer.setInput(LAST_DIAL_ID, last);
        if (this.m_dialConfiguration.getUseWatermark()) {
            this.m_dialViewer.setInput(MAX_DIAL_ID, max);
            this.m_dialInformationViewer.setInput(MAX_DIAL_ID, max);
        }
        if (refreshNeedles) {
            this.m_dialViewer.refresh();
        }
        this.m_dialInformationViewer.refresh();
        if (this.stackLayout.topControl != this.m_dialInformationViewer) {
            this.stackLayout.topControl = this.m_dialInformationViewer;
            this.layout(true, true);
        }
    }

    public boolean setFocus() {
        if (this.m_dialViewer != null && !this.m_dialViewer.isDisposed()) {
            return this.m_dialViewer.setFocus();
        }
        return this.setFocus();
    }

    public DialConfiguration getDialConfiguration() {
        return this.m_dialConfiguration;
    }

    public DialViewer getDialViewer() {
        return this.m_dialViewer;
    }

    public IAction getPropertiesAction() {
        return new Action(Messages.DIAL_PROPERTIES_ACTION_TEXT){

            public void run() {
                DialConfigurationPage dp = new DialConfigurationPage(Dial.this.getDialConfiguration(), Dial.this.m_dialViewer.getUnit().getContentType());
                OnePageWizardDialog dialog = new OnePageWizardDialog(Dial.this.getShell(), (IWizardPage)dp);
                dialog.setWidthConstraint(450, 450);
                dialog.setHeightConstraint(450, 450);
                if (dialog.open() == 0) {
                    Dial.this.setDialConfiguration(dp.getConfiguration());
                }
            }
        };
    }
}

