/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.editor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.console.agent.AgentJmxHelper;
import org.openjdk.jmc.console.agent.AgentPlugin;
import org.openjdk.jmc.console.agent.editor.AgentEditor;
import org.openjdk.jmc.console.agent.editor.AgentEditorAction;
import org.openjdk.jmc.console.agent.editor.sections.EventDetailSection;
import org.openjdk.jmc.console.agent.editor.sections.EventListSection;
import org.openjdk.jmc.console.agent.editor.sections.GlobalConfigSection;
import org.openjdk.jmc.console.agent.manager.model.IEvent;
import org.openjdk.jmc.console.agent.manager.model.IPreset;
import org.openjdk.jmc.console.agent.manager.model.PresetRepository;
import org.openjdk.jmc.console.agent.manager.model.PresetRepositoryFactory;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.console.agent.utils.ProbeValidator;
import org.openjdk.jmc.console.agent.utils.ValidationResult;
import org.openjdk.jmc.console.agent.wizards.BaseWizardPage;
import org.openjdk.jmc.ui.misc.AbstractStructuredContentProvider;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.wizards.OnePageWizardDialog;
import org.xml.sax.SAXException;

public class AgentEditorUi {
    private final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    private final AgentJmxHelper helper;
    private final PresetRepository presetRepository = PresetRepositoryFactory.createSingleton();
    private final AgentEditorAction[] actions;
    private GlobalConfigSection globalConfigSection;
    private EventListSection eventListSection;
    private EventDetailSection eventDetailSection;

    public AgentEditorUi(AgentEditor editor, AgentEditorAction[] actions) {
        this.helper = editor.getAgentEditorInput().getAgentJmxHelper();
        this.actions = Arrays.copyOf(actions, actions.length);
        this.bindAgentEditorActions();
    }

    protected void createContent(Form form, FormToolkit toolkit) {
        Composite body = form.getBody();
        body.setLayout(MCLayoutFactory.createFormPageLayout());
        Composite container = new Composite(body, 0);
        container.setLayout((Layout)new FillLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm hSashForm = new SashForm(container, 256);
        SashForm vSashForm = new SashForm((Composite)hSashForm, 512);
        this.globalConfigSection = new GlobalConfigSection((Composite)vSashForm, toolkit);
        this.eventListSection = new EventListSection((Composite)vSashForm, toolkit);
        this.eventDetailSection = new EventDetailSection((Composite)hSashForm, toolkit);
        this.eventListSection.addSelectionChangedListener(selectionChangedEvent -> this.eventDetailSection.setInput((IEvent)selectionChangedEvent.getStructuredSelection().getFirstElement()));
        hSashForm.setWeights(new int[]{3, 7});
        vSashForm.setWeights(new int[]{1, 4});
    }

    protected void refresh(Runnable done) {
        this.EXECUTOR_SERVICE.submit(() -> {
            String probes = this.helper.retrieveEventProbes();
            IPreset[] preset = new IPreset[1];
            if (probes != null && !probes.isEmpty()) {
                preset[0] = this.presetRepository.createPreset();
                try {
                    preset[0].deserialize(probes);
                }
                catch (IOException | SAXException e) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    DialogToolkit.showException((Shell)window.getShell(), (String)Messages.AgentEditorUI_MESSAGE_FAILED_TO_LOAD_PRESET, (Throwable)e);
                    e.printStackTrace();
                }
            }
            DisplayToolkit.inDisplayThread().execute(() -> {
                this.globalConfigSection.setInput(preset[0]);
                this.eventListSection.setInput(preset[0]);
                this.eventDetailSection.setInput(null);
                done.run();
                Stream.of(this.actions).forEach(action -> action.setEnabled(true));
            });
        });
    }

    private void refresh() {
        Stream.of(this.actions).forEach(action -> action.setEnabled(false));
        this.refresh(() -> {});
    }

    private void loadPreset() {
        block6: {
            Stream.of(this.actions).forEach(action -> action.setEnabled(false));
            PresetSelectorWizardPage presetSelector = new PresetSelectorWizardPage();
            if (new OnePageWizardDialog(Display.getCurrent().getActiveShell(), (IWizardPage)presetSelector).open() != 0) {
                Stream.of(this.actions).forEach(action -> action.setEnabled(true));
            }
            try {
                try {
                    String parentPath = PresetRepositoryFactory.getCreatedStorageDir().getAbsolutePath();
                    String filePath = parentPath + File.separator + presetSelector.getSelectedPreset().getFileName();
                    this.applyConfig(filePath);
                    this.refresh(() -> {});
                }
                catch (IOException e) {
                    AgentPlugin.getDefault().getLogger().log(Level.WARNING, "Could not find the file " + presetSelector.getSelectedPreset().getFileName(), e);
                    Stream.of(this.actions).forEach(action -> action.setEnabled(true));
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Stream.of(this.actions).forEach(action -> action.setEnabled(true));
                throw throwable;
            }
            Stream.of(this.actions).forEach(action -> action.setEnabled(true));
        }
    }

    private void savePreset() {
        IPreset preset = this.presetRepository.createPreset();
        try {
            if (!this.helper.retrieveEventProbes().isEmpty()) {
                preset.deserialize(this.helper.retrieveEventProbes());
                this.presetRepository.addPreset(preset);
                DialogToolkit.openConfirmOnUiThread((String)Messages.PresetSelectorWizardPage_SAVE_PRESET_TITLE, (String)MessageFormat.format(Messages.PresetSelectorWizardPage_SAVE_PRESET_MESSAGE, preset.getFileName()));
            } else {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                DialogToolkit.showWarning((Shell)window.getShell(), (String)Messages.AgentEditorUI_MESSAGE_EMPTY_PRESET_TITLE, (String)Messages.AgentEditorUI_MESSAGE_EMPTY_PRESET);
            }
        }
        catch (IOException | SAXException e) {
            System.out.println(preset.getFileName());
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            DialogToolkit.showException((Shell)window.getShell(), (String)Messages.PresetSelectorWizardPage_MESSAGE_FAILED_TO_SAVE_PRESET, (Throwable)e);
            e.printStackTrace();
        }
    }

    private void bindAgentEditorActions() {
        Stream.of(this.actions).forEach(action -> {
            switch (action.getType()) {
                case REFRESH: {
                    action.setRunnable(this::refresh);
                    break;
                }
                case LOAD_PRESET: {
                    action.setRunnable(this::loadPreset);
                    break;
                }
                case SAVE_AS_PRESET: {
                    action.setRunnable(this::savePreset);
                }
            }
        });
    }

    private void applyConfig(String path) {
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(path, new String[0]));
            String validationMessage = this.validateProbeDefinition(new String(bytes, StandardCharsets.UTF_8));
            if (!validationMessage.isEmpty()) {
                DialogToolkit.openConfirmOnUiThread((String)Messages.PresetSelectorWizardPage_ERROR_PAGE_TITLE, (String)validationMessage);
                return;
            }
            this.helper.defineEventProbes(new String(bytes, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            AgentPlugin.getDefault().getLogger().log(Level.WARNING, "Could not apply XML config", e);
        }
    }

    private String validateProbeDefinition(String configuration) {
        ProbeValidator validator = new ProbeValidator();
        try {
            validator.validate(new StreamSource(new ByteArrayInputStream(configuration.getBytes(StandardCharsets.UTF_8))));
        }
        catch (IOException e) {
            return e.getMessage();
        }
        catch (SAXException sAXException) {}
        ValidationResult result = validator.getValidationResult();
        StringBuilder sb = new StringBuilder();
        if (result.getFatalError() != null) {
            sb.append("[FATAL]\t").append(result.getFatalError().getMessage()).append('\n');
        }
        for (SAXException sAXException : result.getErrors()) {
            sb.append("[ERROR]\t").append(sAXException.getMessage()).append('\n');
        }
        for (SAXException sAXException : result.getErrors()) {
            sb.append("[WARN]\t").append(sAXException.getMessage()).append('\n');
        }
        return sb.toString();
    }

    private class PresetSelectorWizardPage
    extends BaseWizardPage {
        private BaseWizardPage.TableInspector tableInspector;
        private IPreset selectedPreset;

        public PresetSelectorWizardPage() {
            super(Messages.PresetSelectorWizardPage_PAGE_NAME);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            this.setTitle(Messages.PresetSelectorWizardPage_MESSAGE_PAGE_TITLE);
            this.setDescription(Messages.PresetSelectorWizardPage_MESSAGE_PAGE_DESCRIPTION);
            ScrolledComposite sc = new ScrolledComposite(parent, 768);
            Composite container = new Composite((Composite)sc, 0);
            sc.setContent((Control)container);
            container.setLayout((Layout)new FillLayout());
            this.createPresetTableContainer(container);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            sc.setMinSize(container.computeSize(-1, -1));
            this.setControl((Control)sc);
        }

        private Composite createPresetTableContainer(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new FillLayout());
            this.tableInspector = new BaseWizardPage.TableInspector(container, 1){

                @Override
                protected void addColumns() {
                    this.addColumn(Messages.PresetSelectorWizardPage_ID_PRESET, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (!(element instanceof IPreset)) {
                                throw new IllegalArgumentException("element must be an IPreset");
                            }
                            IPreset preset = (IPreset)element;
                            return preset.getFileName() + " - " + preset.getEvents().length + " " + Messages.PresetSelectorWizardPage_MESSAGE_EVENTS;
                        }

                        public Image getImage(Object element) {
                            return AgentPlugin.getDefault().getImage("agent.png");
                        }
                    });
                }
            };
            this.tableInspector.setContentProvider((IContentProvider)new PresetTableContentProvider());
            this.tableInspector.getViewer().addSelectionChangedListener(e -> {
                IPreset iPreset = this.selectedPreset = (IPreset)e.getStructuredSelection().getFirstElement();
            });
            this.tableInspector.setInput(AgentEditorUi.this.presetRepository);
            return container;
        }

        public IPreset getSelectedPreset() {
            return this.selectedPreset;
        }
    }

    private static class PresetTableContentProvider
    extends AbstractStructuredContentProvider {
        private PresetTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof PresetRepository)) {
                throw new IllegalArgumentException("input element must be a PresetRepository");
            }
            PresetRepository repository = (PresetRepository)inputElement;
            return repository.listPresets();
        }
    }
}

