/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmc.ui.common.tree.DefaultTreeNode;
import org.openjdk.jmc.ui.common.tree.ITreeNode;

public class TreeNodeBuilder {
    private Object value;
    private final Map<Object, TreeNodeBuilder> children = new HashMap<Object, TreeNodeBuilder>(2);

    public TreeNodeBuilder get(Object childKey) {
        TreeNodeBuilder c = this.children.get(childKey);
        if (c == null) {
            c = new TreeNodeBuilder();
            this.children.put(childKey, c);
        }
        return c;
    }

    public TreeNodeBuilder get(Object childKey, Object childValue) {
        TreeNodeBuilder c = this.get(childKey);
        c.setValue(childValue);
        return c;
    }

    public TreeNodeBuilder getUniqueChild(Object child) {
        return this.get(child, child);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public ITreeNode[] getChildren(ITreeNode parent) {
        ITreeNode[] nodes = new ITreeNode[this.children.size()];
        int i = 0;
        for (TreeNodeBuilder builder : this.children.values()) {
            DefaultTreeNode tn;
            ITreeNode[] subNodes = builder.getChildren((ITreeNode)(tn = new DefaultTreeNode(parent, builder.value)));
            if (subNodes.length > 0) {
                tn.setChildren(subNodes);
            }
            nodes[i++] = tn;
        }
        return nodes;
    }
}

