/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.system;

import jakarta.inject.Inject;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.console.ui.actions.ResetToDefaultsAction;
import org.openjdk.jmc.console.ui.editor.IConsolePageContainer;
import org.openjdk.jmc.console.ui.editor.IConsolePageStateHandler;
import org.openjdk.jmc.console.ui.editor.internal.ConsoleEditor;
import org.openjdk.jmc.console.ui.messages.internal.Messages;
import org.openjdk.jmc.console.ui.tabs.system.SystemPropertiesSectionPart;
import org.openjdk.jmc.console.ui.tabs.system.TableInformationSectionPart;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.subscription.ISubscriptionService;
import org.openjdk.jmc.rjmx.ui.internal.AttributeSectionPart;
import org.openjdk.jmc.ui.misc.MCActionContributionItem;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;

public class SystemTab
implements IConsolePageStateHandler {
    private static final String JVM_STATISTICS_ID = "JVMStatistics";
    private static final String SERVER_INFO_ID = "ServerInformation";
    private static final String SYSTEM_PROPERTIES_ID = "SystemProperties";
    private AttributeSectionPart systemPart;
    private TableInformationSectionPart infoPart;
    private SystemPropertiesSectionPart systemProperties;

    @Inject
    protected void createPageContent(final IConsolePageContainer page, IManagedForm managedForm, IConnectionHandle ch) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite container = managedForm.getForm().getBody();
        container.setLayout(MCLayoutFactory.createFormPageLayout());
        form.getToolBarManager().appendToGroup("first", (IContributionItem)new MCActionContributionItem((IAction)new ResetToDefaultsAction(){

            @Override
            protected void reset() {
                SystemTab.this.systemPart.restoreState(page.getDefaultConfig().getChild(SystemTab.JVM_STATISTICS_ID));
            }
        }));
        form.getToolBarManager().update(true);
        IMemento currentState = page.loadConfig();
        this.infoPart = new TableInformationSectionPart(container, toolkit, ch, currentState.getChild(SERVER_INFO_ID));
        managedForm.addPart((IFormPart)this.infoPart);
        MCLayoutFactory.addGrabOnExpandLayoutData((Section)this.infoPart.getSection());
        this.systemPart = new AttributeSectionPart(((ConsoleEditor)page.getEditor()).getSectionPartManagers().get(0), container, toolkit, Messages.SystemTab_SECTION_SYSTEM_STATISTICS_TEXT, ch, currentState.getChild(JVM_STATISTICS_ID));
        managedForm.addPart((IFormPart)this.systemPart);
        MCLayoutFactory.addGrabOnExpandLayoutData((Section)this.systemPart.getSection());
        ISubscriptionService subscriptionService = (ISubscriptionService)ch.getServiceOrDummy(ISubscriptionService.class);
        this.systemProperties = new SystemPropertiesSectionPart(container, toolkit, subscriptionService, currentState.getChild(SYSTEM_PROPERTIES_ID));
        managedForm.addPart((IFormPart)this.systemProperties);
        MCLayoutFactory.addGrabOnExpandLayoutData((Section)this.systemProperties.getSection());
        this.validateDependencies(page, ch);
    }

    private void validateDependencies(IConsolePageContainer page, IConnectionHandle connectionHandle) {
        MBeanServerConnection connection = (MBeanServerConnection)connectionHandle.getServiceOrNull(MBeanServerConnection.class);
        try {
            if (connection.queryNames(new ObjectName("java.lang:type=Runtime"), null).isEmpty() || connection.queryNames(new ObjectName("java.lang:type=ClassLoading"), null).isEmpty() || connection.queryNames(new ObjectName("java.lang:type=OperatingSystem"), null).isEmpty()) {
                page.presentError(Messages.ConsoleEditor_PLATFORM_MBEANS_UNAVAILABLE);
            }
        }
        catch (Exception exception) {
            page.presentError(Messages.ConsoleEditor_CONNECTION_LOST);
        }
    }

    @Override
    public boolean saveState(IMemento state) {
        this.infoPart.saveState(state.createChild(SERVER_INFO_ID));
        this.systemPart.saveState(state.createChild(JVM_STATISTICS_ID));
        this.systemProperties.saveState(state.createChild(SYSTEM_PROPERTIES_ID));
        return true;
    }

    @Override
    public void dispose() {
    }
}

