/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.batch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openjdk.jmc.joverflow.batch.DetailedStats;
import org.openjdk.jmc.joverflow.batch.ExtendedField;
import org.openjdk.jmc.joverflow.batch.ReferencedObjCluster;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.support.ClassAndOvhdComboList;
import org.openjdk.jmc.joverflow.support.ClassAndSizeComboList;
import org.openjdk.jmc.joverflow.support.Constants;
import org.openjdk.jmc.joverflow.support.HeapStats;
import org.openjdk.jmc.joverflow.support.PrimitiveArrayWrapper;
import org.openjdk.jmc.joverflow.support.ProblemRecorder;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.support.RefChainElementImpl;
import org.openjdk.jmc.joverflow.util.ObjectToIntMap;
import org.openjdk.jmc.joverflow.util.SmallSet;

public class BatchProblemRecorder
implements ProblemRecorder {
    private static final int HIGH_SIZE = 1;
    private IdentityHashMap<RefChainElement, HighSizeObjCluster> refererToHSCluster = new IdentityHashMap(128);
    private IdentityHashMap<RefChainElement, CollectionCluster> refererToColCluster = new IdentityHashMap(128);
    private IdentityHashMap<RefChainElement, DupStringCluster> refererToDSCluster = new IdentityHashMap(256);
    private IdentityHashMap<RefChainElement, DupArrayCluster> refererToDACluster = new IdentityHashMap(32);
    private IdentityHashMap<RefChainElement, WeakHashMapCluster> refererToWMCluster = new IdentityHashMap(4);
    private JavaHeapObject lastObj;

    @Override
    public void initialize(Snapshot snapshot, HeapStats hs) {
        long minOvhdForHSClasses = hs.totalObjSize / 50L;
        JavaClass[] javaClassArray = snapshot.getClasses();
        int n = javaClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass clazz = javaClassArray[n2];
            if (clazz.isCollection() || clazz.getTotalShallowInstanceSize() >= minOvhdForHSClasses) {
                clazz.setFlag(1);
            }
            ++n2;
        }
    }

    @Override
    public void recordProblematicCollection(JavaLazyReadObject col, CollectionInstanceDescriptor colDesc, Constants.ProblemKind ovhdKind, int ovhd, RefChainElement referer) {
        CollectionCluster colCluster = this.refererToColCluster.get(referer);
        if (colCluster == null) {
            colCluster = new CollectionCluster();
            this.refererToColCluster.put(referer, colCluster);
        }
        JavaClass colClazz = col.getClazz();
        if (ovhdKind == Constants.ProblemKind.SMALL || ovhdKind == Constants.ProblemKind.SPARSE_SMALL || ovhdKind == Constants.ProblemKind.SPARSE_LARGE) {
            colCluster.addCollectionInstanceWithNumEls(colClazz, ovhdKind, ovhd, colDesc.getNumElements());
        } else {
            colCluster.addCollectionInstance(colClazz, ovhdKind, ovhd);
        }
        if (col != this.lastObj && colClazz.flagIsSet(1)) {
            this.recordHighSizeObject(col, referer, colDesc.getImplSize());
        }
    }

    @Override
    public void recordGoodCollection(JavaLazyReadObject col, CollectionInstanceDescriptor colDesc, RefChainElement referer) {
        CollectionCluster colCluster = this.refererToColCluster.get(referer);
        if (colCluster == null) {
            colCluster = new CollectionCluster();
            this.refererToColCluster.put(referer, colCluster);
        }
        colCluster.addGoodCollection();
        if (col != this.lastObj && col.getClazz().flagIsSet(1)) {
            this.recordHighSizeObject(col, referer, colDesc.getImplSize());
        }
    }

    @Override
    public void recordDuplicateString(JavaObject stringObj, String stringValue, int implInclusiveSize, int ovhd, boolean hasDupBackingCharArray, RefChainElement referer) {
        DupStringCluster dsCluster = this.refererToDSCluster.get(referer);
        if (dsCluster == null) {
            dsCluster = new DupStringCluster();
            this.refererToDSCluster.put(referer, dsCluster);
        }
        dsCluster.addDupString(stringValue, ovhd, hasDupBackingCharArray);
        if (stringObj != this.lastObj && stringObj.getClazz().flagIsSet(1)) {
            this.recordHighSizeObject(stringObj, referer, implInclusiveSize);
        }
    }

    @Override
    public void recordNonDuplicateString(JavaObject stringObj, int implInclusiveSize, RefChainElement referer) {
        DupStringCluster dsCluster = this.refererToDSCluster.get(referer);
        if (dsCluster == null) {
            dsCluster = new DupStringCluster();
            this.refererToDSCluster.put(referer, dsCluster);
        }
        dsCluster.addNonDupString();
        if (stringObj != this.lastObj && stringObj.getClazz().flagIsSet(1)) {
            this.recordHighSizeObject(stringObj, referer, implInclusiveSize);
        }
    }

    @Override
    public void recordDuplicateArray(JavaValueArray ar, int ovhd, RefChainElement referer) {
        DupArrayCluster daCluster = this.refererToDACluster.get(referer);
        if (daCluster == null) {
            daCluster = new DupArrayCluster();
            this.refererToDACluster.put(referer, daCluster);
        }
        daCluster.addDupArray(ar, ovhd);
        if (ar != this.lastObj && ar.getClazz().flagIsSet(1)) {
            this.recordHighSizeObject(ar, referer, ar.getSize());
        }
    }

    @Override
    public void recordNonDuplicateArray(JavaValueArray ar, RefChainElement referer) {
        DupArrayCluster daCluster = this.refererToDACluster.get(referer);
        if (daCluster == null) {
            daCluster = new DupArrayCluster();
            this.refererToDACluster.put(referer, daCluster);
        }
        daCluster.addNonDupArray();
        if (ar != this.lastObj && ar.getClazz().flagIsSet(1)) {
            this.recordHighSizeObject(ar, referer, ar.getSize());
        }
    }

    @Override
    public void recordWeakHashMapWithBackRefs(JavaObject col, CollectionInstanceDescriptor colDesc, int ovhd, String valueTypeAndFieldSample, RefChainElement referer) {
        WeakHashMapCluster wmCluster = this.refererToWMCluster.get(referer);
        if (wmCluster == null) {
            wmCluster = new WeakHashMapCluster();
            this.refererToWMCluster.put(referer, wmCluster);
        }
        wmCluster.addWeakHashMap(col.getClazz().getHumanFriendlyName(), ovhd, valueTypeAndFieldSample);
        if (col != this.lastObj && col.getClazz().flagIsSet(1)) {
            this.recordHighSizeObject(col, referer, colDesc.getImplSize());
        }
    }

    @Override
    public boolean shouldRecordGoodInstance(JavaObject obj) {
        return obj != this.lastObj && obj.getClazz().flagIsSet(1);
    }

    @Override
    public void recordGoodInstance(JavaObject obj, RefChainElement referer) {
        this.recordHighSizeObject(obj, referer, obj.getSize());
    }

    private void recordHighSizeObject(JavaHeapObject obj, RefChainElement referer, int size) {
        HighSizeObjCluster cluster = this.refererToHSCluster.get(referer);
        if (cluster == null) {
            cluster = new HighSizeObjCluster();
            this.refererToHSCluster.put(referer, cluster);
        }
        cluster.addInstance(obj.getClazz(), size);
        this.lastObj = obj;
    }

    public DetailedStats getDetailedStats(int minOvhd) {
        List<List<? extends ReferencedObjCluster>> clustersWithFullRefChains = this.getProblematicDataClustersWithFullRefChains(minOvhd);
        List<List<? extends ReferencedObjCluster>> clustersWithNearestField = this.getProblematicDataClustersWithNearestField(minOvhd);
        ArrayList<List<ReferencedObjCluster.HighSizeObjects>> highSizeObjClusters = new ArrayList<List<ReferencedObjCluster.HighSizeObjects>>(2);
        highSizeObjClusters.add(clustersWithFullRefChains.get(4));
        highSizeObjClusters.add(clustersWithNearestField.get(4));
        ArrayList<List<ReferencedObjCluster.Collections>> collectionClusters = new ArrayList<List<ReferencedObjCluster.Collections>>(2);
        collectionClusters.add(clustersWithFullRefChains.get(0));
        collectionClusters.add(clustersWithNearestField.get(0));
        ArrayList<List<ReferencedObjCluster.DupStrings>> dupStringClusters = new ArrayList<List<ReferencedObjCluster.DupStrings>>(2);
        dupStringClusters.add(clustersWithFullRefChains.get(1));
        dupStringClusters.add(clustersWithNearestField.get(1));
        ArrayList<List<ReferencedObjCluster.DupArrays>> dupArrayClusters = new ArrayList<List<ReferencedObjCluster.DupArrays>>(2);
        dupArrayClusters.add(clustersWithFullRefChains.get(2));
        dupArrayClusters.add(clustersWithNearestField.get(2));
        ArrayList<List<ReferencedObjCluster.WeakHashMaps>> weakHashMapClusters = new ArrayList<List<ReferencedObjCluster.WeakHashMaps>>(2);
        weakHashMapClusters.add(clustersWithFullRefChains.get(3));
        weakHashMapClusters.add(clustersWithNearestField.get(3));
        return new DetailedStats(minOvhd, highSizeObjClusters, collectionClusters, weakHashMapClusters, dupStringClusters, dupArrayClusters);
    }

    private List<List<? extends ReferencedObjCluster>> getProblematicDataClustersWithFullRefChains(int minOvhd) {
        ArrayList<ReferencedObjCluster> hsClusters = new ArrayList<ReferencedObjCluster>(64);
        ArrayList<ReferencedObjCluster> colClusters = new ArrayList<ReferencedObjCluster>(64);
        ArrayList<ReferencedObjCluster> dsClusters = new ArrayList<ReferencedObjCluster>(128);
        ArrayList<ReferencedObjCluster> daClusters = new ArrayList<ReferencedObjCluster>(64);
        ArrayList<ReferencedObjCluster> wmClusters = new ArrayList<ReferencedObjCluster>(4);
        this.generateFullRefChainClusters(this.refererToHSCluster, hsClusters, minOvhd * 5);
        this.generateFullRefChainClusters(this.refererToColCluster, colClusters, minOvhd);
        this.generateFullRefChainClusters(this.refererToDSCluster, dsClusters, minOvhd);
        this.generateFullRefChainClusters(this.refererToDACluster, daClusters, minOvhd);
        this.generateFullRefChainClusters(this.refererToWMCluster, wmClusters, minOvhd);
        ArrayList<List<? extends ReferencedObjCluster>> result = new ArrayList<List<? extends ReferencedObjCluster>>(4);
        result.add(colClusters);
        result.add(dsClusters);
        result.add(daClusters);
        result.add(wmClusters);
        result.add(hsClusters);
        return result;
    }

    private <T extends AbstractClusterNode> void generateFullRefChainClusters(IdentityHashMap<RefChainElement, T> refererToCluster, ArrayList<ReferencedObjCluster> clusterList, int minOvhd) {
        Set<Map.Entry<RefChainElement, T>> colEntries = refererToCluster.entrySet();
        for (Map.Entry<RefChainElement, T> entry : colEntries) {
            RefChainElement referer = entry.getKey();
            AbstractClusterNode cluster = (AbstractClusterNode)entry.getValue();
            if (cluster.getTotalOverhead() < minOvhd) continue;
            clusterList.add(cluster.getFinalCluster(referer));
        }
        clusterList.sort(ReferencedObjCluster.DEFAULT_COMPARATOR);
    }

    private List<List<? extends ReferencedObjCluster>> getProblematicDataClustersWithNearestField(int minOvhd) {
        ArrayList<ReferencedObjCluster> hsClusters = new ArrayList<ReferencedObjCluster>(64);
        ArrayList<ReferencedObjCluster> colClusters = new ArrayList<ReferencedObjCluster>(64);
        ArrayList<ReferencedObjCluster> dsClusters = new ArrayList<ReferencedObjCluster>(128);
        ArrayList<ReferencedObjCluster> daClusters = new ArrayList<ReferencedObjCluster>(64);
        ArrayList<ReferencedObjCluster> wmClusters = new ArrayList<ReferencedObjCluster>(4);
        this.generateFieldClusters(this.refererToHSCluster, hsClusters, minOvhd * 5);
        this.generateFieldClusters(this.refererToColCluster, colClusters, minOvhd);
        this.generateFieldClusters(this.refererToDSCluster, dsClusters, minOvhd);
        this.generateFieldClusters(this.refererToDACluster, daClusters, minOvhd);
        this.generateFieldClusters(this.refererToWMCluster, wmClusters, minOvhd);
        ArrayList<List<? extends ReferencedObjCluster>> result = new ArrayList<List<? extends ReferencedObjCluster>>(4);
        result.add(colClusters);
        result.add(dsClusters);
        result.add(daClusters);
        result.add(wmClusters);
        result.add(hsClusters);
        return result;
    }

    private <T extends AbstractClusterNode> void generateFieldClusters(IdentityHashMap<RefChainElement, T> refererToCluster, ArrayList<ReferencedObjCluster> clusterList, int minOvhd) {
        HashMap<ExtendedField, AbstractClusterNode> fieldToCluster = new HashMap<ExtendedField, AbstractClusterNode>();
        Set<Map.Entry<RefChainElement, T>> allClusters = refererToCluster.entrySet();
        for (Map.Entry<RefChainElement, T> entry : allClusters) {
            RefChainElement referer = entry.getKey();
            if (referer instanceof RefChainElementImpl.GCRoot) continue;
            ArrayList<RefChainElement> fieldDescBuf = new ArrayList<RefChainElement>(4);
            while (referer != null && !(referer instanceof RefChainElementImpl.GCRoot)) {
                RefChainElementImpl.AbstractField fieldDesc;
                String clazzName;
                if (referer instanceof RefChainElementImpl.AbstractField && !(clazzName = (fieldDesc = (RefChainElementImpl.AbstractField)referer).getJavaClass().getName()).startsWith("java.util.Collections$") && !clazzName.startsWith("java.lang.ref.") && !clazzName.equals("java.util.BitSet")) break;
                fieldDescBuf.add(0, referer);
                referer = referer.getReferer();
            }
            if (referer == null || referer instanceof RefChainElementImpl.GCRoot) continue;
            fieldDescBuf.add(0, referer);
            ExtendedField fieldReferer = new ExtendedField(fieldDescBuf);
            AbstractClusterNode cluster = (AbstractClusterNode)fieldToCluster.get(fieldReferer);
            if (cluster == null) {
                cluster = ((AbstractClusterNode)entry.getValue()).createCopy(fieldReferer);
                fieldToCluster.put(fieldReferer, cluster);
                continue;
            }
            cluster.addCluster((AbstractClusterNode)entry.getValue());
        }
        Set fieldClusters = fieldToCluster.entrySet();
        for (Map.Entry entry : fieldClusters) {
            AbstractClusterNode cluster = (AbstractClusterNode)entry.getValue();
            if (cluster.getTotalOverhead() < minOvhd) continue;
            RefChainElement referer = ((ExtendedField)entry.getKey()).toReferenceChain();
            clusterList.add(cluster.getFinalCluster(referer));
        }
        clusterList.sort(ReferencedObjCluster.DEFAULT_COMPARATOR);
    }

    private static abstract class AbstractClusterNode {
        private AbstractClusterNode() {
        }

        abstract int getTotalOverhead();

        abstract AbstractClusterNode createCopy(RefChainElement var1);

        abstract void addCluster(AbstractClusterNode var1);

        abstract ReferencedObjCluster getFinalCluster(RefChainElement var1);

        void printNode(String indent) {
            System.out.println(indent + this.toString());
        }
    }

    private static class CollectionCluster
    extends AbstractClusterNode {
        ClassAndOvhdComboList entries = new ClassAndOvhdComboList();
        private int numGoodCollections;

        CollectionCluster() {
        }

        void addCollectionInstance(JavaClass colClass, Constants.ProblemKind ovhdKind, int ovhd) {
            this.entries.addCollectionInfo(colClass, ovhdKind, ovhd, 1);
        }

        void addCollectionInstanceWithNumEls(JavaClass colClass, Constants.ProblemKind ovhdKind, int ovhd, int numElements) {
            this.entries.addCollectionInfoWithNumEls(colClass, ovhdKind, ovhd, 1, numElements, numElements);
        }

        void addGoodCollection() {
            ++this.numGoodCollections;
        }

        @Override
        int getTotalOverhead() {
            return this.entries.getTotalOverhead();
        }

        @Override
        CollectionCluster createCopy(RefChainElement parentDesc) {
            CollectionCluster copy = new CollectionCluster();
            copy.entries = this.entries.clone();
            copy.numGoodCollections = this.numGoodCollections;
            return copy;
        }

        @Override
        void addCluster(AbstractClusterNode other) {
            CollectionCluster otherCluster = (CollectionCluster)other;
            this.entries.merge(otherCluster.entries);
            this.numGoodCollections += otherCluster.numGoodCollections;
        }

        @Override
        ReferencedObjCluster getFinalCluster(RefChainElement referer) {
            return new ReferencedObjCluster.Collections(referer, this.entries.getFinalList(), this.entries.getTotalOverhead(), this.numGoodCollections);
        }
    }

    private static class DupArrayCluster
    extends AbstractClusterNode {
        private int totalOverhead;
        private int numNonDupArrays;
        private final ObjectToIntMap<PrimitiveArrayWrapper> arrays;

        private DupArrayCluster(ObjectToIntMap<PrimitiveArrayWrapper> arrays) {
            this.arrays = arrays;
        }

        DupArrayCluster() {
            this(new ObjectToIntMap<PrimitiveArrayWrapper>(5));
        }

        @Override
        int getTotalOverhead() {
            return this.totalOverhead;
        }

        void addDupArray(JavaValueArray ar, int overhead) {
            PrimitiveArrayWrapper arWrapper = new PrimitiveArrayWrapper(ar);
            this.arrays.putOneOrIncrement(arWrapper);
            this.totalOverhead += overhead;
        }

        void addNonDupArray() {
            ++this.numNonDupArrays;
        }

        @Override
        DupArrayCluster createCopy(RefChainElement parentDesc) {
            DupArrayCluster copy = new DupArrayCluster((ObjectToIntMap<PrimitiveArrayWrapper>)this.arrays.clone());
            copy.totalOverhead = this.totalOverhead;
            copy.numNonDupArrays = this.numNonDupArrays;
            return copy;
        }

        @Override
        void addCluster(AbstractClusterNode other) {
            ObjectToIntMap.Entry<PrimitiveArrayWrapper>[] entries;
            DupArrayCluster otherCluster = (DupArrayCluster)other;
            ObjectToIntMap<PrimitiveArrayWrapper> otherStrings = otherCluster.arrays;
            ObjectToIntMap.Entry<PrimitiveArrayWrapper>[] entryArray = entries = otherStrings.getEntries();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectToIntMap.Entry<PrimitiveArrayWrapper> entry = entryArray[n2];
                this.arrays.putOrIncrementBy((PrimitiveArrayWrapper)entry.key, entry.value);
                ++n2;
            }
            this.totalOverhead += otherCluster.totalOverhead;
            this.numNonDupArrays += otherCluster.numNonDupArrays;
        }

        @Override
        ReferencedObjCluster getFinalCluster(RefChainElement referer) {
            return new ReferencedObjCluster.DupArrays(referer, this.totalOverhead, this.numNonDupArrays, this.arrays.getEntriesSortedByValueThenKey());
        }
    }

    private static class DupStringCluster
    extends AbstractClusterNode {
        private int totalOverhead;
        private int numDupBackingCharArrays;
        private int numNonDupStrings;
        private final ObjectToIntMap<String> strings;

        private DupStringCluster(ObjectToIntMap<String> strings) {
            this.strings = strings;
        }

        DupStringCluster() {
            this(new ObjectToIntMap<String>(5));
        }

        @Override
        int getTotalOverhead() {
            return this.totalOverhead;
        }

        void addDupString(String string, int overhead, boolean hasDupBackingCharArray) {
            this.strings.putOneOrIncrement(string);
            this.totalOverhead += overhead;
            if (hasDupBackingCharArray) {
                ++this.numDupBackingCharArrays;
            }
        }

        void addNonDupString() {
            ++this.numNonDupStrings;
        }

        @Override
        DupStringCluster createCopy(RefChainElement parentDesc) {
            DupStringCluster copy = new DupStringCluster((ObjectToIntMap<String>)this.strings.clone());
            copy.totalOverhead = this.totalOverhead;
            copy.numDupBackingCharArrays = this.numDupBackingCharArrays;
            copy.numNonDupStrings = this.numNonDupStrings;
            return copy;
        }

        @Override
        void addCluster(AbstractClusterNode other) {
            ObjectToIntMap.Entry<String>[] entries;
            DupStringCluster otherCluster = (DupStringCluster)other;
            ObjectToIntMap<String> otherStrings = otherCluster.strings;
            ObjectToIntMap.Entry<String>[] entryArray = entries = otherStrings.getEntries();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectToIntMap.Entry<String> entry = entryArray[n2];
                this.strings.putOrIncrementBy((String)entry.key, entry.value);
                ++n2;
            }
            this.totalOverhead += otherCluster.totalOverhead;
            this.numDupBackingCharArrays += otherCluster.numDupBackingCharArrays;
            this.numNonDupStrings += otherCluster.numNonDupStrings;
        }

        @Override
        ReferencedObjCluster getFinalCluster(RefChainElement referer) {
            return new ReferencedObjCluster.DupStrings(referer, this.totalOverhead, this.numDupBackingCharArrays, this.numNonDupStrings, this.strings.getEntriesSortedByValueThenKey());
        }
    }

    private static class HighSizeObjCluster
    extends AbstractClusterNode {
        ClassAndSizeComboList entries = new ClassAndSizeComboList();

        HighSizeObjCluster() {
        }

        void addInstance(JavaClass colClass, int implInclusiveSize) {
            this.entries.addInstanceInfo(colClass, implInclusiveSize, 1);
        }

        @Override
        int getTotalOverhead() {
            return this.entries.getTotalSize();
        }

        @Override
        HighSizeObjCluster createCopy(RefChainElement parentDesc) {
            HighSizeObjCluster copy = new HighSizeObjCluster();
            copy.entries = this.entries.clone();
            return copy;
        }

        @Override
        void addCluster(AbstractClusterNode other) {
            HighSizeObjCluster otherCluster = (HighSizeObjCluster)other;
            this.entries.merge(otherCluster.entries);
        }

        @Override
        ReferencedObjCluster getFinalCluster(RefChainElement referer) {
            return new ReferencedObjCluster.HighSizeObjects(referer, this.entries.getFinalList(), this.entries.getTotalSize());
        }
    }

    private static class WeakHashMapCluster
    extends AbstractClusterNode {
        private final SmallSet<String> colClasses;
        private final SmallSet<String> valueTypeAndFieldSamples;
        private int numInstances;
        private int totalOverhead;

        WeakHashMapCluster() {
            this.colClasses = new SmallSet();
            this.valueTypeAndFieldSamples = new SmallSet();
        }

        private WeakHashMapCluster(WeakHashMapCluster from) {
            this.totalOverhead = from.totalOverhead;
            this.numInstances = from.numInstances;
            this.colClasses = new SmallSet<String>(from.colClasses);
            this.valueTypeAndFieldSamples = new SmallSet<String>(from.valueTypeAndFieldSamples);
        }

        void addWeakHashMap(String colClass, int ovhd, String valueTypeAndFieldSample) {
            this.totalOverhead += ovhd;
            ++this.numInstances;
            this.colClasses.add(colClass);
            this.valueTypeAndFieldSamples.add(valueTypeAndFieldSample);
        }

        @Override
        int getTotalOverhead() {
            return this.totalOverhead;
        }

        @Override
        WeakHashMapCluster createCopy(RefChainElement parentDesc) {
            return new WeakHashMapCluster(this);
        }

        @Override
        void addCluster(AbstractClusterNode other) {
            WeakHashMapCluster otherCluster = (WeakHashMapCluster)other;
            this.totalOverhead += otherCluster.totalOverhead;
            this.numInstances += otherCluster.numInstances;
            this.colClasses.addAll(otherCluster.colClasses);
            this.valueTypeAndFieldSamples.addAll(otherCluster.valueTypeAndFieldSamples);
        }

        @Override
        ReferencedObjCluster getFinalCluster(RefChainElement referer) {
            return new ReferencedObjCluster.WeakHashMaps(referer, this.numInstances, this.totalOverhead, this.colClasses, this.valueTypeAndFieldSamples);
        }
    }
}

