/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.viewers;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.openjdk.jmc.joverflow.ui.model.ReferrerItem;

class ReferrerTreeViewer
extends TableViewer {
    private long mHeapSize = 1L;
    private final ReferrerTreeContentProvider mContentProvider = new ReferrerTreeContentProvider(this);

    ReferrerTreeViewer(Composite parent, int style) {
        super(parent, style | 0x10000000 | 0x10000);
        this.setContentProvider((IContentProvider)this.mContentProvider);
        this.createTreeViewerColumn("Referrer", ReferrerItem::getName, null, Comparator.comparing(ReferrerItem::getName), true);
        TableViewerColumn sortingColumn = this.createTreeViewerColumn("Memory KiB", model -> String.format("%,.2f (%d%%)", (double)model.getMemory() / 1024.0, Math.round((double)model.getMemory() * 100.0 / (double)this.mHeapSize)), model -> String.format("%,d Bytes", model.getMemory()), this.mContentProvider.getSortingComparator(), false);
        this.createTreeViewerColumn("Overhead KiB", model -> String.format("%,.2f (%d%%)", (double)model.getOvhd() / 1024.0, Math.round((double)model.getOvhd() * 100.0 / (double)this.mHeapSize)), model -> String.format("%,d Bytes", model.getOvhd()), Comparator.comparingLong(ReferrerItem::getOvhd), false);
        this.createTreeViewerColumn("Objects", model -> String.format("%,d", model.getSize()), null, Comparator.comparingInt(ReferrerItem::getSize), false);
        this.getTable().setSortColumn(sortingColumn.getColumn());
        this.getTable().setSortDirection(1024);
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this);
    }

    private TableViewerColumn createTreeViewerColumn(String label, final Function<ReferrerItem, String> labelProvider, final Function<ReferrerItem, String> toolTipProvider, final Comparator<ReferrerItem> comparator, final boolean intent) {
        final TableViewerColumn column = new TableViewerColumn((TableViewer)this, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(label);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new OwnerDrawLabelProvider(){
            Color referrerIconColor = new Color((Device)Display.getCurrent(), 116, 184, 250);

            protected void paint(Event event, Object element) {
                Widget item = event.item;
                event.gc.setAntialias(1);
                Rectangle bounds = ((TableItem)item).getBounds(event.index);
                Point p = event.gc.stringExtent((String)labelProvider.apply((ReferrerItem)element));
                int margin = (bounds.height - p.y) / 2;
                int dx = bounds.x + margin;
                int dy = bounds.y + margin * 2;
                if (intent) {
                    Color fg = event.gc.getForeground();
                    event.gc.setForeground(this.referrerIconColor);
                    event.gc.drawPolygon(new int[]{3 + (dx += 10 * ((ReferrerItem)element).getLevel()), dy, 6 + dx, 7 + dy, 4 + dx, 7 + dy, 4 + dx, 9 + dy, 8 + dx, 9 + dy, 8 + dx, 11 + dy, 2 + dx, 11 + dy, 2 + dx, 7 + dy, dx, 7 + dy});
                    event.gc.setForeground(fg);
                    dx += 11 + margin;
                }
                event.gc.drawString((String)labelProvider.apply((ReferrerItem)element), dx, bounds.y + margin, true);
            }

            public void dispose() {
                this.referrerIconColor.dispose();
                super.dispose();
            }

            protected void measure(Event event, Object element) {
            }

            protected void erase(Event event, Object element) {
            }

            public String getToolTipText(Object element) {
                if (toolTipProvider == null) {
                    return super.getToolTipText(element);
                }
                return (String)toolTipProvider.apply((ReferrerItem)element);
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Comparator newComparator = ReferrerTreeViewer.this.mContentProvider.getSortingComparator();
                int newDirection = ReferrerTreeViewer.this.mContentProvider.getSortingDirection();
                if (ReferrerTreeViewer.this.mContentProvider.getSortingComparator() == comparator) {
                    newDirection *= -1;
                } else {
                    newComparator = comparator;
                    newDirection = -1;
                }
                ReferrerTreeViewer.this.getTable().setSortColumn(column.getColumn());
                ReferrerTreeViewer.this.getTable().setSortDirection(newDirection == 1 ? 128 : 1024);
                ReferrerTreeViewer.this.mContentProvider.sort(newComparator, newDirection);
            }
        });
        return column;
    }

    void setHeapSize(long size) {
        this.mHeapSize = size;
    }

    static class ReferrerTreeContentProvider
    extends ArrayContentProvider
    implements ILazyContentProvider {
        private Comparator<ReferrerItem> mComparator = Comparator.comparingLong(ReferrerItem::getMemory);
        private int mDirection = -1;
        private TableViewer mTableViewer;
        private Object[] mItems = new ReferrerItem[0];

        ReferrerTreeContentProvider(TableViewer tableViewer) {
            this.mTableViewer = tableViewer;
        }

        public void updateElement(int index) {
            if (index >= this.mItems.length) {
                return;
            }
            this.mTableViewer.replace(this.mItems[index], index);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.mItems = (Object[])newInput;
        }

        void setInput(Object input) {
            Object selected = null;
            if (this.mTableViewer.getTable().getSelection().length > 0) {
                selected = this.mTableViewer.getTable().getSelection()[0].getData();
            }
            Object[] items = this.getElements(input);
            items = Arrays.stream(items).filter(item -> ((ReferrerItem)item).getSize() > 0).toArray();
            this.mItems = Arrays.copyOf(items, items.length, ReferrerItem[].class);
            this.sort(this.mComparator, this.mDirection);
            this.mTableViewer.setItemCount(this.mItems.length);
            int index = Arrays.asList(this.mItems).indexOf(selected);
            if (index == -1) {
                this.mTableViewer.getTable().deselectAll();
                return;
            }
            this.mTableViewer.getTable().setSelection(index);
        }

        void sort(Comparator<ReferrerItem> comparator, int direction) {
            this.mComparator = comparator;
            this.mDirection = direction;
            if (this.mComparator != null) {
                Arrays.sort(this.mItems, (o1, o2) -> {
                    if (((ReferrerItem)o1).getLevel() == ((ReferrerItem)o2).getLevel()) {
                        return direction * comparator.compare((ReferrerItem)o1, (ReferrerItem)o2);
                    }
                    return ((ReferrerItem)o1).getLevel() - ((ReferrerItem)o2).getLevel();
                });
            }
            this.mTableViewer.setInput((Object)this.mItems);
        }

        Comparator<ReferrerItem> getSortingComparator() {
            return this.mComparator;
        }

        int getSortingDirection() {
            return this.mDirection;
        }
    }
}

