/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v1;

import java.io.IOException;
import java.util.List;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.internal.ChunkInfo;
import org.openjdk.jmc.flightrecorder.internal.IChunkLoader;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.Chunk;
import org.openjdk.jmc.flightrecorder.internal.parser.LoaderContext;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.ChunkMetadata;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.ChunkStructure;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.IDataInput;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.SeekableInputStream;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.TypeManager;
import org.openjdk.jmc.flightrecorder.internal.util.ParserToolkit;

public class ChunkLoaderV1
implements IChunkLoader {
    private static final long CONSTANT_POOL_EVENT_TYPE = 1L;
    private final ChunkStructure header;
    private final byte[] data;
    private final LoaderContext context;

    public ChunkLoaderV1(ChunkStructure header, byte[] data, LoaderContext context) {
        this.header = header;
        this.data = data;
        this.context = context;
        context.addChunkRange(header.getChunkRange());
    }

    @Override
    public byte[] call() throws Exception {
        int size;
        SeekableInputStream input = SeekableInputStream.build(this.data, this.header.isIntegersCompressed());
        this.context.incChunkCount();
        input.seek(this.header.getMetadataOffset());
        List<ChunkMetadata.ClassElement> classes = ChunkMetadata.readMetadata((IDataInput)input).metadata.classes;
        TypeManager manager = new TypeManager(classes, this.context, this.header);
        long constantPoolOffset = 0L;
        long delta = this.header.getConstantPoolOffset();
        while (delta != 0L) {
            input.seek(constantPoolOffset += delta);
            delta = ChunkLoaderV1.readConstantPoolEvent(input, manager, this.header.isIntegersCompressed());
        }
        manager.resolveConstants();
        for (long index = this.header.getBodyStartOffset(); index < this.header.getChunkSize(); index += (long)size) {
            input.seek(index);
            size = input.readInt();
            long type = input.readLong();
            if (size == 0) {
                throw new CouldNotLoadRecordingException("Found event with invalid size (0)");
            }
            if (type == 1L || type == 0L) continue;
            manager.readEvent(type, input, size);
        }
        this.context.setSkippedEventCount(manager.getSkippedEventCount());
        this.context.addConstantPoolExtensions();
        return this.data;
    }

    private static long readConstantPoolEvent(IDataInput input, TypeManager manager, boolean compressedInts) throws IOException, InvalidJfrFileException {
        if (compressedInts) {
            input.readLong();
        } else {
            input.readInt();
        }
        ParserToolkit.assertValue(input.readLong(), 1L);
        input.readLong();
        input.readLong();
        long delta = input.readLong();
        input.readBoolean();
        int poolCount = input.readInt();
        for (int i = 0; i < poolCount; ++i) {
            long classId = input.readLong();
            int constantCount = input.readInt();
            manager.readConstants(classId, input, constantCount);
        }
        return delta;
    }

    public static IChunkLoader create(Chunk input, LoaderContext context) throws IOException, CouldNotLoadRecordingException {
        ChunkStructure header = new ChunkStructure(input);
        byte[] data = input.fill(header.getChunkSize());
        return new ChunkLoaderV1(header, data, context);
    }

    public static ChunkInfo getInfo(Chunk input, long position) throws IOException, CouldNotLoadRecordingException {
        ChunkStructure header = new ChunkStructure(input);
        return new ChunkInfo(position, header.getChunkSize(), header.getChunkRange());
    }

    @Override
    public long getTimestamp() {
        return this.header.getStartTimeNanos();
    }
}

