/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.impl;

import java.io.IOException;
import java.util.Set;
import javax.management.JMException;
import org.jolokia.server.core.Version;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.NotChangedException;
import org.jolokia.server.core.service.api.AbstractJolokiaService;
import org.jolokia.server.core.service.api.AgentDetails;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.request.RequestHandler;
import org.jolokia.server.core.util.NetworkUtil;
import org.jolokia.server.core.util.RequestType;
import org.json.simple.JSONObject;

public class VersionRequestHandler
extends AbstractJolokiaService<RequestHandler>
implements RequestHandler {
    private JolokiaContext context;

    VersionRequestHandler() {
        super(RequestHandler.class, -1);
    }

    @Override
    public void init(JolokiaContext pJolokiaContext) {
        this.context = pJolokiaContext;
    }

    public Object handleRequest(JolokiaRequest pJmxReq, Object pPreviousResult) throws JMException, IOException, NotChangedException {
        JSONObject ret = new JSONObject();
        ret.put("agent", Version.getAgentVersion());
        ret.put("protocol", Version.getProtocolVersion());
        ret.put("id", NetworkUtil.replaceExpression(this.context.getConfig(ConfigKey.AGENT_ID)));
        AgentDetails agentDetails = this.context.getAgentDetails();
        if (agentDetails != null) {
            ret.put("details", agentDetails.toJSONObject());
        }
        JSONObject info = new JSONObject();
        for (RequestHandler handler : this.context.getServices(RequestHandler.class)) {
            if (handler == this) continue;
            Object rtInfo = handler.getRuntimeInfo();
            info.put(handler.getProvider(), rtInfo != null ? rtInfo : new JSONObject());
        }
        ret.put("info", info);
        ret.put("config", this.configToJSONObject());
        return ret;
    }

    @Override
    public boolean canHandle(JolokiaRequest pJolokiaRequest) {
        return pJolokiaRequest.getType() == RequestType.VERSION;
    }

    private JSONObject configToJSONObject() {
        JSONObject info = new JSONObject();
        Set<ConfigKey> keys = this.context.getConfigKeys();
        for (ConfigKey key : keys) {
            if (!key.isGlobalConfig()) continue;
            info.put(key.getKeyValue(), this.context.getConfig(key));
        }
        return info;
    }

    @Override
    public String getProvider() {
        return null;
    }

    @Override
    public Object getRuntimeInfo() {
        return null;
    }
}

