/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.providers;

import java.awt.Polygon;
import java.util.Iterator;
import org.openjdk.jmc.common.xydata.DataSeries;
import org.openjdk.jmc.common.xydata.IXYData;
import org.openjdk.jmc.greychart.XAxis;
import org.openjdk.jmc.greychart.YAxis;
import org.openjdk.jmc.greychart.impl.CancelService;
import org.openjdk.jmc.greychart.impl.LongWorldToDeviceConverter;
import org.openjdk.jmc.greychart.impl.OptimizingProvider;
import org.openjdk.jmc.greychart.impl.SamplePoint;
import org.openjdk.jmc.greychart.impl.WorldToDeviceConverter;
import org.openjdk.jmc.greychart.providers.AveragingSampleBuffer;
import org.openjdk.jmc.greychart.providers.SamplePointIterator;

public final class AveragingProvider
implements OptimizingProvider {
    private final DataSeries<IXYData> m_dataSeries;
    private final double m_yMultiplier;
    private final XAxis m_xAxis;
    private final CancelService m_cancelService;
    private AveragingSampleBuffer m_sampleBuffer = new AveragingSampleBuffer(0);
    private long m_startX;
    private long m_endX;
    private int m_requestedResolution = 0;
    private long m_requestedStartX = Long.MIN_VALUE;
    private long m_requestedEndX = Long.MAX_VALUE;
    private volatile boolean dataChangeOccured;

    public AveragingProvider(DataSeries<IXYData> s, double yMultiplier, XAxis xAxis, CancelService cancelService) {
        this.m_dataSeries = s;
        this.m_yMultiplier = yMultiplier;
        this.m_cancelService = cancelService;
        this.m_xAxis = xAxis;
    }

    @Override
    public boolean update() {
        if (this.hasRangeChanged() || this.hasDataChanged() || this.isSampleBufferInvalid()) {
            this.m_sampleBuffer = this.createSampleBuffer(this.m_requestedResolution);
            this.m_startX = this.m_requestedStartX;
            this.m_endX = this.m_requestedEndX;
            this.dataChangeOccured = false;
            return true;
        }
        return false;
    }

    private boolean hasRangeChanged() {
        return this.m_startX != this.m_requestedStartX || this.m_endX != this.m_requestedEndX;
    }

    @Override
    public void setDataChanged(boolean changed) {
        this.dataChangeOccured = changed;
    }

    @Override
    public boolean hasDataChanged() {
        return this.dataChangeOccured;
    }

    private boolean isSampleBufferInvalid() {
        return this.m_sampleBuffer == null || this.m_sampleBuffer.getSize() != this.m_requestedResolution;
    }

    @Override
    public void setResolution(int resolution) {
        this.m_requestedResolution = resolution;
    }

    @Override
    public Iterator<SamplePoint> getSamples(int width) {
        return new SamplePointIterator(this.m_sampleBuffer.getSamples());
    }

    @Override
    public Polygon getSamplesPolygon(LongWorldToDeviceConverter xWorldToDevice, WorldToDeviceConverter yWorldToDevice) {
        int deviceWidth = xWorldToDevice.getDeviceWidth();
        int[] xs = new int[deviceWidth + 3];
        int[] ys = new int[deviceWidth + 3];
        int index = 0;
        if (yWorldToDevice.canCalculateDeviceCoordinate()) {
            Iterator<SamplePoint> it = this.getSamples(deviceWidth);
            while (it.hasNext() && index < deviceWidth) {
                SamplePoint sp = it.next();
                xs[index] = sp.x;
                ys[index] = yWorldToDevice.getDeviceCoordinate(sp.y);
                ++index;
            }
        }
        return new Polygon(xs, ys, index);
    }

    private AveragingSampleBuffer createSampleBuffer(int width) {
        Iterator it = this.m_dataSeries.createIterator(this.m_requestedStartX, this.m_requestedEndX);
        if (!it.hasNext()) {
            return new AveragingSampleBuffer(0);
        }
        long worldWidth = this.m_xAxis.getMax().longValue() - this.m_xAxis.getMin().longValue();
        long leftEdge = this.m_xAxis.getMin().longValue();
        AveragingSampleBuffer sampleBuffer = new AveragingSampleBuffer(width);
        IXYData data = this.addFirstBoundaryPoint(sampleBuffer, it, worldWidth, leftEdge);
        long x = this.getXAsLong(data);
        long oldx = this.getXAsLong(data);
        if (x >= leftEdge && x <= leftEdge + worldWidth) {
            this.addXYDataPoint(sampleBuffer, worldWidth, leftEdge, data);
        }
        while (it.hasNext() && x < leftEdge + worldWidth && this.m_cancelService.isNotCancelled()) {
            IXYData newData = (IXYData)it.next();
            x = this.getXAsLong(newData);
            if (x < oldx) {
                throw new IllegalArgumentException("Data points out of order: " + x + " is lower than " + oldx);
            }
            if (x >= leftEdge + worldWidth) {
                this.addInterpolatedNormalizedPoint(sampleBuffer, 1.0, data, newData, worldWidth, leftEdge);
            } else {
                this.addXYDataPoint(sampleBuffer, worldWidth, leftEdge, newData);
                oldx = x;
            }
            data = newData;
        }
        sampleBuffer.fixSamples();
        return sampleBuffer;
    }

    private long getXAsLong(IXYData data) {
        return ((Number)data.getX()).longValue();
    }

    /*
     * Unable to fully structure code
     */
    private IXYData addFirstBoundaryPoint(AveragingSampleBuffer sampleBuffer, Iterator<IXYData> it, long worldWidth, long leftEdge) {
        firstDataPoint = null;
        if (!it.hasNext() || (x = this.getXAsLong(firstDataPoint = it.next())) < leftEdge) ** GOTO lbl12
        return firstDataPoint;
lbl-1000:
        // 1 sources

        {
            data = it.next();
            x = this.getXAsLong(data);
            if (x >= leftEdge) {
                this.addInterpolatedNormalizedPoint(sampleBuffer, 0.0, firstDataPoint, data, worldWidth, leftEdge);
                if (x >= leftEdge + worldWidth) {
                    this.addInterpolatedNormalizedPoint(sampleBuffer, 1.0, firstDataPoint, data, worldWidth, leftEdge);
                }
                return data;
            }
            firstDataPoint = data;
lbl12:
            // 2 sources

            ** while (it.hasNext())
        }
lbl13:
        // 1 sources

        return firstDataPoint;
    }

    private void addInterpolatedNormalizedPoint(AveragingSampleBuffer sampleBuffer, double boundary, IXYData beforeData, IXYData afterData, long worldWidth, long leftEdge) {
        double n1 = this.getNormalizedX(beforeData, worldWidth, leftEdge);
        double n2 = this.getNormalizedX(afterData, worldWidth, leftEdge);
        double y1 = this.getY(beforeData);
        double y2 = this.getY(afterData);
        double k = (y2 - y1) / (n2 - n1);
        double yResult = (boundary - n1) * k + y1;
        sampleBuffer.addDataPoint(boundary, yResult);
    }

    private double getY(IXYData data) {
        return ((Number)data.getY()).doubleValue();
    }

    private void addXYDataPoint(AveragingSampleBuffer sampleBuffer, long worldWidth, long leftEdge, IXYData data) {
        double n = this.getNormalizedX(data, worldWidth, leftEdge);
        double y = ((Number)data.getY()).doubleValue();
        sampleBuffer.addDataPoint(n, y);
    }

    private double getNormalizedX(IXYData data, long worldWidth, long leftEdge) {
        return (double)(this.getXAsLong(data) - leftEdge) / (double)worldWidth;
    }

    @Override
    public DataSeries getDataSeries() {
        return this.m_dataSeries;
    }

    @Override
    public OptimizingProvider[] getChildren() {
        return new OptimizingProvider[0];
    }

    @Override
    public synchronized long getMaxX() {
        return this.m_endX;
    }

    @Override
    public synchronized long getMinX() {
        return this.m_startX;
    }

    @Override
    public double getMaxY() {
        return this.m_sampleBuffer.getMaxY() * this.m_yMultiplier;
    }

    @Override
    public double getMinY() {
        return this.m_sampleBuffer.getMinY() * this.m_yMultiplier;
    }

    @Override
    public WorldToDeviceConverter getYSampleToDeviceConverterFor(YAxis yAxis) {
        double minY = yAxis.getMin().doubleValue() / this.m_yMultiplier;
        double maxY = yAxis.getMax().doubleValue() / this.m_yMultiplier;
        return new WorldToDeviceConverter(yAxis.getRenderedHeight(), 0, minY, maxY);
    }

    @Override
    public synchronized void setRange(long start, long end) {
        this.m_requestedStartX = start;
        this.m_requestedEndX = end;
        this.update();
    }

    public void setIntegrate(boolean integrate) {
    }
}

