/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.jobs;

import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.unit.IConstrainedMap;
import org.openjdk.jmc.flightrecorder.configuration.IFlightRecorderService;
import org.openjdk.jmc.flightrecorder.configuration.IRecordingDescriptor;
import org.openjdk.jmc.flightrecorder.configuration.events.EventOptionID;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.ui.common.util.StatusFactory;

public class UpdateRecordingJob
extends Job {
    private final IRecordingDescriptor m_recordingDescriptor;
    private final IConstrainedMap<String> m_recordingOptions;
    private final IConstrainedMap<EventOptionID> m_recordingSettings;
    private final IServerHandle m_server;

    public UpdateRecordingJob(IServerHandle server, IRecordingDescriptor recordingDescriptor, IConstrainedMap<String> recordingOptions, IConstrainedMap<EventOptionID> recordingSettings) {
        super(NLS.bind((String)Messages.UPDATE_RECORDING_JOB_NAME, (Object)recordingDescriptor.getName()));
        this.m_server = server;
        this.m_recordingDescriptor = recordingDescriptor;
        this.m_recordingOptions = recordingOptions;
        this.m_recordingSettings = recordingSettings;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (IConnectionHandle connection = this.m_server.connect(this.getName());){
                IFlightRecorderService flightRecorderService = (IFlightRecorderService)connection.getServiceOrThrow(IFlightRecorderService.class);
                flightRecorderService.updateRecordingOptions(this.m_recordingDescriptor, this.m_recordingOptions);
                flightRecorderService.updateEventOptions(this.m_recordingDescriptor, this.m_recordingSettings);
                return StatusFactory.createOk((String)Messages.UPDATE_RECORDING_JOB_SUCCESS_MSG);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not update recording", e);
            return StatusFactory.createErr((String)NLS.bind((String)Messages.UPDATE_RECORDING_JOB_SERVICE_ERROR_MSG, (Object)this.m_recordingDescriptor.getName()));
        }
    }
}

