/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.CollectorType;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class DiscouragedGcOptionsRule
implements IRule {
    private static final IQuantity LARGE_HEAP = UnitLookup.MEMORY.getUnit((IPrefix)BinaryPrefix.GIBI).quantity(4L);
    private static final IQuantity HW_THREADS_FOR_MULTI_CPU = UnitLookup.NUMBER_UNITY.quantity(4L);
    private static final IQuantity ONE = UnitLookup.NUMBER_UNITY.quantity(1L);
    private static final String GC_OPTIONS_RESULT_ID = "GcOptions";
    public static final TypedResult<IQuantity> HARDWARE_THREADS = new TypedResult("hwThreads", JdkAggregators.MIN_HW_THREADS, (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IQuantity> PARALLEL_GC_THREADS = new TypedResult("parallelGcThreads", JdkAggregators.PARALLEL_GC_THREAD_COUNT_MAX, (ContentType)UnitLookup.NUMBER, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(HARDWARE_THREADS, PARALLEL_GC_THREADS);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.CPUInformation", RulesToolkit.EventAvailability.AVAILABLE).build();

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        IQuantity parallelGCThreads = (IQuantity)items.getAggregate(JdkAggregators.PARALLEL_GC_THREAD_COUNT_MAX);
        IQuantity minHwThreads = (IQuantity)items.getAggregate(JdkAggregators.MIN_HW_THREADS);
        CollectorType oc = CollectorType.getOldCollectorType(items);
        if (parallelGCThreads != null && minHwThreads != null && oc != null) {
            if (oc == CollectorType.SERIAL_OLD) {
                IQuantity maxHeapSize = (IQuantity)items.getAggregate(JdkAggregators.HEAP_CONF_MAX_SIZE);
                if (minHwThreads.compareTo((Object)HW_THREADS_FOR_MULTI_CPU) >= 0 && maxHeapSize != null && maxHeapSize.compareTo((Object)LARGE_HEAP) > 0) {
                    return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("SerialGcOnMultiCpuRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("SerialGcOnMultiCpuRuleFactory_TEXT_INFO_LONG")).build();
                }
            } else {
                if (minHwThreads.compareTo((Object)ONE) == 0 && oc == CollectorType.PARALLEL_OLD) {
                    return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("ParallelOnSingleCpuRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("ParallelOnSingleCpuRuleFactory_TEXT_INFO_LONG")).build();
                }
                if (parallelGCThreads.compareTo((Object)minHwThreads) > 0) {
                    return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).addResult(HARDWARE_THREADS, (Object)minHwThreads).addResult(PARALLEL_GC_THREADS, (Object)parallelGCThreads).setSummary(Messages.getString("NumberOfGcThreadsRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("NumberOfGcThreadsRuleFactory_TEXT_INFO_LONG")).build();
                }
                if (parallelGCThreads.compareTo((Object)ONE) == 0 && (oc == CollectorType.PARALLEL_OLD || oc == CollectorType.G1_OLD)) {
                    return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("ParGcFewThreadsRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("ParGcFewThreadsRuleFactory_TEXT_INFO_LONG")).build();
                }
            }
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("DiscouragedGcOptionsRule_TEXT_OK")).build();
        }
        return RulesToolkit.getTooFewEventsResult((IRule)this, (IPreferenceValueProvider)valueProvider);
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return DiscouragedGcOptionsRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return GC_OPTIONS_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DiscouragedGcOptionsRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

