/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.awt.Color;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemList;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class CompilationsPage
extends AbstractDataPage {
    private static final Color COMPILATIONS_COLOR = TypeLabelProvider.getColor("jdk.Compilation");
    private static final ItemList.ItemListBuilder COMPILATIONS_LIST = new ItemList.ItemListBuilder();
    private static final ItemList.ItemListBuilder FAILED_COMPILATIONS_LIST = new ItemList.ItemListBuilder();
    private static final String SASH = "sash";
    private static final String FAILED_COMPILATIONS_TABLE = "fCompilationsTable";
    private static final String COMPILATIONS_TABLE = "compilationsTable";
    private static final IItemFilter TABLE_FILTER;
    private ColumnManager.SelectionState compilationsState;
    private IItemFilter compilationsFilterState;
    private ColumnManager.SelectionState compilationsFailedState;
    private IItemFilter compilationsFailedFilterState;
    private int tabFolderIndex = 0;
    private IRange<IQuantity> durationsRange;
    public FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        COMPILATIONS_LIST.addColumn(JdkAttributes.COMPILER_COMPILATION_ID);
        COMPILATIONS_LIST.addColumn(JdkAttributes.COMPILER_METHOD);
        COMPILATIONS_LIST.addColumn(JfrAttributes.START_TIME);
        COMPILATIONS_LIST.addColumn(JfrAttributes.DURATION);
        COMPILATIONS_LIST.addColumn(JfrAttributes.END_TIME);
        COMPILATIONS_LIST.addColumn(JfrAttributes.EVENT_THREAD);
        COMPILATIONS_LIST.addColumn(JdkAttributes.COMPILER_CODE_SIZE);
        COMPILATIONS_LIST.addColumn(JdkAttributes.COMPILER_INLINED_SIZE);
        COMPILATIONS_LIST.addColumn(JdkAttributes.COMPILER_COMPILATION_LEVEL);
        COMPILATIONS_LIST.addColumn(JdkAttributes.COMPILER_COMPILATION_SUCCEEDED);
        COMPILATIONS_LIST.addColumn(JdkAttributes.COMPILER_IS_OSR);
        FAILED_COMPILATIONS_LIST.addColumn(JfrAttributes.EVENT_TIMESTAMP);
        FAILED_COMPILATIONS_LIST.addColumn(JfrAttributes.EVENT_THREAD);
        FAILED_COMPILATIONS_LIST.addColumn(JdkAttributes.COMPILER_COMPILATION_ID);
        FAILED_COMPILATIONS_LIST.addColumn(JdkAttributes.COMPILER_FAILED_MESSAGE);
        TABLE_FILTER = ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkQueries.COMPILER_FAILURE.getFilter(), JdkQueries.COMPILATION.getFilter()});
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new CompilationsPageUi(parent, toolkit, pageContainer, state);
    }

    public CompilationsPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return TABLE_FILTER;
    }

    public static class CompilationsPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.CompilationsPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/compilations.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"compilations"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new CompilationsPage(dpd, items, editor);
        }
    }

    private class CompilationsPageUi
    implements IPageUI {
        private static final String COMPILATIONS_FILTER = "compilationsFilter";
        private static final String FAILED_COMPILATIONS_FILTER = "failedCompilationsFilter";
        private final SashForm sash;
        private final ChartCanvas durationCanvas;
        private final ItemList compilationsTable;
        private final ItemList compilationsFailedTable;
        private FilterComponent compilationsFilter;
        private FilterComponent compilationsFailedFilter;
        private CTabFolder tabFolder;
        private XYChart durationChart;
        private IItemCollection selectedItems;
        private FlavorSelector flavorSelector;

        CompilationsPageUi(Composite container, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            Form form = DataPageToolkit.createForm(container, toolkit, CompilationsPage.this.getName(), CompilationsPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            this.durationCanvas = new ChartCanvas((Composite)this.sash);
            DataPageToolkit.createChartTooltip(this.durationCanvas);
            this.tabFolder = new CTabFolder((Composite)this.sash, 0);
            this.compilationsTable = COMPILATIONS_LIST.buildWithoutBorder((Composite)this.tabFolder, TableSettings.forState((IState)state.getChild(CompilationsPage.COMPILATIONS_TABLE)));
            this.compilationsTable.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(this.compilationsTable.getSelection().get())));
            this.compilationsFilter = FilterComponent.createFilterComponent(this.compilationsTable, CompilationsPage.this.compilationsFilterState, CompilationsPage.this.getDataSource().getItems().apply(JdkFilters.COMPILATION), pageContainer.getSelectionStore()::getSelections, this::onCompilationsFilterChange);
            MCContextMenuManager compilationsMm = MCContextMenuManager.create((Control)this.compilationsTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.compilationsTable.getManager(), (MCContextMenuManager)compilationsMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.compilationsTable, Messages.CompilationsPage_COMPILATIONS_TABLE_SELECTION, (IContributionManager)compilationsMm);
            compilationsMm.add(this.compilationsFilter.getShowFilterAction());
            compilationsMm.add(this.compilationsFilter.getShowSearchAction());
            DataPageToolkit.addTabItem(this.tabFolder, (Control)this.compilationsFilter.getComponent(), Messages.CompilationsPage_TAB_COMPILATIONS);
            this.compilationsFailedTable = FAILED_COMPILATIONS_LIST.buildWithoutBorder((Composite)this.tabFolder, TableSettings.forState((IState)state.getChild(CompilationsPage.FAILED_COMPILATIONS_TABLE)));
            this.compilationsFailedTable.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(this.compilationsFailedTable.getSelection().get())));
            this.compilationsFailedFilter = FilterComponent.createFilterComponent(this.compilationsFailedTable, CompilationsPage.this.compilationsFailedFilterState, CompilationsPage.this.getDataSource().getItems().apply(JdkFilters.COMPILER_FAILURE), pageContainer.getSelectionStore()::getSelections, this::onCompilationsFailedFilterChange);
            MCContextMenuManager compilationsFailedMm = MCContextMenuManager.create((Control)this.compilationsFailedTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.compilationsFailedTable.getManager(), (MCContextMenuManager)compilationsFailedMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.compilationsFailedTable, Messages.CompilationsPage_COMPILATIONS_FAILED_TABLE_SELECTION, (IContributionManager)compilationsFailedMm);
            compilationsFailedMm.add(this.compilationsFailedFilter.getShowFilterAction());
            compilationsFailedMm.add(this.compilationsFailedFilter.getShowSearchAction());
            DataPageToolkit.addTabItem(this.tabFolder, (Control)this.compilationsFailedFilter.getComponent(), Messages.CompilationsPage_TAB_COMPILATIONS_FAILED);
            IQuantity max = (IQuantity)CompilationsPage.this.getDataSource().getItems().getAggregate(JdkAggregators.LONGEST_COMPILATION);
            max = max == null ? UnitLookup.MILLISECOND.quantity(20L) : max.add((IQuantity)UnitLookup.MILLISECOND.quantity(20L));
            IXDataRenderer durationRoot = RendererToolkit.layers((IXDataRenderer[])new IXDataRenderer[]{DataPageToolkit.buildDurationHistogram(Messages.CompilationsPage_ROW_DURATIONS, JdkAggregators.COMPILATIONS_COUNT.getDescription(), CompilationsPage.this.getDataSource().getItems().apply(JdkFilters.COMPILATION), JdkAggregators.COMPILATIONS_COUNT, COMPILATIONS_COLOR)});
            this.durationChart = new XYChart((IQuantity)UnitLookup.MILLISECOND.quantity(0L), max, durationRoot, 180);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.durationChart, (IAttribute<IQuantity>)JfrAttributes.DURATION, Messages.CompilationsPage_COMPILATIONS_DURATION_SELECTION, (IContributionManager)this.durationCanvas.getContextMenu());
            this.durationCanvas.setChart(this.durationChart);
            this.durationCanvas.setSelectionListener(() -> {
                pageContainer.showSelection(ItemRow.getSelection(this.durationChart, (ICanonicalAccessorFactory<IQuantity>)JfrAttributes.DURATION));
                this.compilationsTable.show(ItemRow.getSelection(this.durationChart, (ICanonicalAccessorFactory<IQuantity>)JfrAttributes.DURATION));
            });
            if (CompilationsPage.this.durationsRange != null) {
                this.durationChart.setVisibleRange((IQuantity)CompilationsPage.this.durationsRange.getStart(), (IQuantity)CompilationsPage.this.durationsRange.getEnd());
            }
            this.durationChart.addVisibleRangeListener(r -> {
                IRange iRange = CompilationsPage.this.durationsRange = r;
            });
            this.tabFolder.setSelection(CompilationsPage.this.tabFolderIndex);
            this.compilationsFilter.loadState(CompilationsPage.this.getState().getChild(COMPILATIONS_FILTER));
            this.compilationsFailedFilter.loadState(CompilationsPage.this.getState().getChild(FAILED_COMPILATIONS_FILTER));
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(CompilationsPage.SASH));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, TABLE_FILTER, CompilationsPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, CompilationsPage.this.flavorSelectorState);
            CompilationsPage.this.addResultActions(form);
            this.compilationsTable.getManager().setSelectionState(CompilationsPage.this.compilationsState);
            this.compilationsFailedTable.getManager().setSelectionState(CompilationsPage.this.compilationsFailedState);
        }

        private void onCompilationsFilterChange(IItemFilter filter) {
            this.compilationsFilter.filterChangeHelper(filter, this.compilationsTable, this.getItems().apply(JdkFilters.COMPILATION));
            CompilationsPage.this.compilationsFilterState = filter;
        }

        private void onCompilationsFailedFilterChange(IItemFilter filter) {
            this.compilationsFailedFilter.filterChangeHelper(filter, this.compilationsFailedTable, this.getItems().apply(JdkFilters.COMPILER_FAILURE));
            CompilationsPage.this.compilationsFailedFilterState = filter;
        }

        private IItemCollection getItems() {
            return this.selectedItems != null ? this.selectedItems : CompilationsPage.this.getDataSource().getItems();
        }

        public void saveTo(IWritableState memento) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)memento.createChild(CompilationsPage.SASH));
            this.compilationsTable.getManager().getSettings().saveState(memento.createChild(CompilationsPage.COMPILATIONS_TABLE));
            this.compilationsFailedTable.getManager().getSettings().saveState(memento.createChild(CompilationsPage.FAILED_COMPILATIONS_TABLE));
            this.compilationsFilter.saveState(memento.createChild(COMPILATIONS_FILTER));
            this.compilationsFailedFilter.saveState(memento.createChild(FAILED_COMPILATIONS_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            CompilationsPage.this.compilationsState = this.compilationsTable.getManager().getSelectionState();
            CompilationsPage.this.compilationsFailedState = this.compilationsFailedTable.getManager().getSelectionState();
            CompilationsPage.this.tabFolderIndex = this.tabFolder.getSelectionIndex();
            CompilationsPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.selectedItems = items != null ? items : CompilationsPage.this.getDataSource().getItems();
            IItemCollection compilationItems = this.selectedItems.apply(JdkFilters.COMPILATION);
            IItemCollection failedCompilations = this.selectedItems.apply(JdkFilters.COMPILER_FAILURE);
            IXDataRenderer durationRoot = RendererToolkit.layers((IXDataRenderer[])new IXDataRenderer[]{DataPageToolkit.buildDurationHistogram(Messages.CompilationsPage_ROW_DURATIONS, JdkAggregators.COMPILATIONS_COUNT.getDescription(), compilationItems, JdkAggregators.COMPILATIONS_COUNT, COMPILATIONS_COLOR)});
            this.durationChart.setRendererRoot(durationRoot);
            this.durationCanvas.redrawChart();
            this.compilationsTable.show(compilationItems);
            this.compilationsFailedTable.show(failedCompilations);
            this.onCompilationsFilterChange(CompilationsPage.this.compilationsFilterState);
            this.onCompilationsFailedFilterChange(CompilationsPage.this.compilationsFailedFilterState);
        }
    }
}

