/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.parser.synthetic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCModule;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.LabeledIdentifier;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.parser.IEventSink;
import org.openjdk.jmc.flightrecorder.parser.IEventSinkFactory;
import org.openjdk.jmc.flightrecorder.parser.IParserExtension;
import org.openjdk.jmc.flightrecorder.parser.ValueField;
import org.openjdk.jmc.flightrecorder.parser.synthetic.Messages;
import org.openjdk.jmc.flightrecorder.parser.synthetic.SettingsTransformer;

public class SyntheticAttributeExtension
implements IParserExtension {
    private static final IAttribute<IMCStackTrace> EXECUTION_SAMPLES_STACKTRACE = Attribute.attr((String)"stackTrace", (String)Messages.getString("SyntheticAttributeExtension_EXECUTION_SAMPLES_STACKTRACE"), (ContentType)JfrAttributes.EVENT_STACKTRACE.getContentType());
    private static final IAttribute<IMCThread> EXECUTION_SAMPLES_THREAD = Attribute.attr((String)"sampledThread", (String)Messages.getString("SyntheticAttributeExtension_EXECUTION_SAMPLES_THREAD"), (ContentType)JfrAttributes.EVENT_THREAD.getContentType());
    private static final IAttribute<IMCThread> ALLOC_STATISTICS_THREAD = Attribute.attr((String)"thread", (String)Messages.getString("SyntheticAttributeExtension_ALLOC_STATISTICS_THREAD"), (ContentType)JfrAttributes.EVENT_THREAD.getContentType());
    static final IAttribute<LabeledIdentifier> REC_SETTING_EVENT_ID_ATTRIBUTE = Attribute.attr((String)"id", (String)Messages.getString("SyntheticAttributeExtension_REC_SETTING_EVENT_ID_ATTRIBUTE"), (ContentType)UnitLookup.LABELED_IDENTIFIER);

    @Override
    public IEventSinkFactory getEventSinkFactory(final IEventSinkFactory sf) {
        return SettingsTransformer.wrapSinkFactory(new IEventSinkFactory(){

            @Override
            public IEventSink create(String identifier, String label, String[] category, String description, List<ValueField> dataStructure) {
                if ("jdk.ExecutionSample".equals(identifier)) {
                    ValueField[] struct = new ValueField[dataStructure.size()];
                    for (int i = 0; i < struct.length; ++i) {
                        ValueField vf = dataStructure.get(i);
                        if (vf.matches(EXECUTION_SAMPLES_STACKTRACE)) {
                            vf = new ValueField(JfrAttributes.EVENT_STACKTRACE);
                        } else if (vf.matches(EXECUTION_SAMPLES_THREAD)) {
                            vf = new ValueField(JfrAttributes.EVENT_THREAD);
                        }
                        struct[i] = vf;
                    }
                    dataStructure = Arrays.asList(struct);
                } else if ("jdk.NativeMethodSample".equals(identifier)) {
                    ValueField[] struct = new ValueField[dataStructure.size()];
                    for (int i = 0; i < struct.length; ++i) {
                        ValueField vf = dataStructure.get(i);
                        if (vf.matches(EXECUTION_SAMPLES_THREAD)) {
                            vf = new ValueField(JfrAttributes.EVENT_THREAD);
                        }
                        struct[i] = vf;
                    }
                    dataStructure = Arrays.asList(struct);
                } else if ("jdk.ThreadAllocationStatistics".equals(identifier)) {
                    ValueField[] struct = new ValueField[dataStructure.size()];
                    for (int i = 0; i < struct.length; ++i) {
                        ValueField vf = dataStructure.get(i);
                        if (vf.matches(ALLOC_STATISTICS_THREAD)) {
                            vf = new ValueField(JfrAttributes.EVENT_THREAD);
                        }
                        struct[i] = vf;
                    }
                    dataStructure = Arrays.asList(struct);
                } else if ("jdk.JavaExceptionThrow".equals(identifier)) {
                    for (int i = 0; i < dataStructure.size(); ++i) {
                        final int stacktraceIndex = i;
                        if (!dataStructure.get(i).matches(JfrAttributes.EVENT_STACKTRACE)) continue;
                        final IEventSink subSink = sf.create(identifier, label, category, description, dataStructure);
                        return new IEventSink(){

                            @Override
                            public void addEvent(Object[] values) {
                                IMCStackTrace st = (IMCStackTrace)values[stacktraceIndex];
                                if (st == null || st.getFrames().size() < 2 || !this.isError((IMCFrame)st.getFrames().get(0)) && !this.isError((IMCFrame)st.getFrames().get(1))) {
                                    subSink.addEvent(values);
                                }
                            }

                            private boolean isError(IMCFrame frame) {
                                return frame.getMethod().getType().getFullName().equals("java.lang.Error");
                            }
                        };
                    }
                } else if ("jdk.ActiveSetting".equals(identifier)) {
                    ValueField[] struct = new ValueField[dataStructure.size()];
                    for (int i = 0; i < struct.length; ++i) {
                        ValueField vf = dataStructure.get(i);
                        if (vf.matches(REC_SETTING_EVENT_ID_ATTRIBUTE)) {
                            vf = new ValueField(JdkAttributes.REC_SETTING_FOR);
                        }
                        struct[i] = vf;
                    }
                    dataStructure = Arrays.asList(struct);
                } else if ("jdk.ModuleExport".equals(identifier)) {
                    int packageIndex = -1;
                    for (int i = 0; i < dataStructure.size(); ++i) {
                        ValueField vf = dataStructure.get(i);
                        if (!vf.matches(JdkAttributes.EXPORTED_PACKAGE)) continue;
                        packageIndex = i;
                        break;
                    }
                    if (packageIndex != -1) {
                        ArrayList<ValueField> newDataStructure = new ArrayList<ValueField>(dataStructure);
                        newDataStructure.add(new ValueField(JdkAttributes.EXPORTING_MODULE));
                        IEventSink subSink = sf.create(identifier, label, category, description, newDataStructure);
                        ModuleExportSink moduleExportSink = new ModuleExportSink(subSink, packageIndex);
                        return moduleExportSink;
                    }
                } else if ("jdk.JVMInformation".equals(identifier)) {
                    int packageIndex = -1;
                    for (int i = 0; i < dataStructure.size(); ++i) {
                        ValueField vf = dataStructure.get(i);
                        if (!vf.matches(JdkAttributes.JVM_PID)) continue;
                        packageIndex = i;
                        break;
                    }
                    if (packageIndex != -1) {
                        ArrayList<ValueField> newDataStructure = new ArrayList<ValueField>(dataStructure);
                        newDataStructure.set(packageIndex, new ValueField(JdkAttributes.PID));
                        IEventSink subSink = sf.create(identifier, label, category, description, newDataStructure);
                        LongAsStringSink moduleExportSink = new LongAsStringSink(subSink, packageIndex);
                        return moduleExportSink;
                    }
                }
                return sf.create(identifier, label, category, description, dataStructure);
            }

            @Override
            public void flush() {
                sf.flush();
            }
        });
    }

    @Override
    public String getValueInterpretation(String eventTypeId, String fieldId) {
        if (REC_SETTING_EVENT_ID_ATTRIBUTE.getIdentifier().equals(fieldId) && ("http://www.oracle.com/hotspot/jfr-info/recordings/recording_setting".equals(eventTypeId) || "com.oracle.jdk.ActiveSetting".equals(eventTypeId) || "jdk.ActiveSetting".equals(eventTypeId))) {
            return "org.openjdk.jmc.flightrecorder.value_interpretation.type_identifier";
        }
        return null;
    }

    private static class LongAsStringSink
    implements IEventSink {
        private final IEventSink subSink;
        private final int pidIndex;

        public LongAsStringSink(IEventSink subSink, int pidIndex) {
            this.subSink = subSink;
            this.pidIndex = pidIndex;
        }

        @Override
        public void addEvent(Object[] values) {
            Number longPid = (Number)values[this.pidIndex];
            if (longPid != null && values != null && values.length > 0) {
                String pid = String.valueOf(longPid.longValue());
                Object[] newValues = new Object[values.length];
                System.arraycopy(values, 0, newValues, 0, values.length - 1);
                newValues[this.pidIndex] = pid;
                this.subSink.addEvent(newValues);
            }
        }
    }

    private static class ModuleExportSink
    implements IEventSink {
        private final IEventSink subSink;
        private final int packageFieldIndex;

        public ModuleExportSink(IEventSink subSink, int packageFieldIndex) {
            this.subSink = subSink;
            this.packageFieldIndex = packageFieldIndex;
        }

        @Override
        public void addEvent(Object[] values) {
            IMCPackage thePackage = (IMCPackage)values[this.packageFieldIndex];
            if (thePackage != null) {
                IMCModule exportingModule = thePackage.getModule();
                Object[] newValues = new Object[values.length + 1];
                System.arraycopy(values, 0, newValues, 0, values.length);
                newValues[values.length] = exportingModule;
                this.subSink.addEvent(newValues);
            }
        }
    }
}

