/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.swt_awt;

import java.awt.Color;
import java.awt.EventQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public abstract class SWT_AWTBridge {
    public static <T> T computeInEDT(Supplier<T> task) {
        if (EventQueue.isDispatchThread()) {
            return task.get();
        }
        try {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay == null) {
                throw new IllegalStateException("No current display");
            }
            CompletableFuture completion = new CompletableFuture();
            EventQueue.invokeLater(() -> {
                try {
                    completion.complete(task.get());
                }
                catch (Throwable t) {
                    completion.completeExceptionally(t);
                }
            });
            while (!completion.isDone()) {
                if (currentDisplay.readAndDispatch()) continue;
                currentDisplay.sleep();
            }
            return completion.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void invokeInEDTAndWait(Runnable runnable) {
        SWT_AWTBridge.computeInEDT(() -> {
            runnable.run();
            return null;
        });
    }

    public static Color toAWTColor(org.eclipse.swt.graphics.Color swtColor) {
        return new Color(swtColor.getRed(), swtColor.getGreen(), swtColor.getBlue(), swtColor.getAlpha());
    }

    public static org.eclipse.swt.graphics.Color toSWTColor(Color awtColor) {
        return new org.eclipse.swt.graphics.Color(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue(), awtColor.getAlpha());
    }

    public static java.awt.Point toAWTPoint(Point swtPoint) {
        return new java.awt.Point(swtPoint.x, swtPoint.y);
    }

    public static Point toSWTPoint(java.awt.Point awtPoint) {
        return new Point(awtPoint.x, awtPoint.y);
    }

    public static void invokeSwtAwayFromAwt(Display display, Runnable task) {
        if (display.isDisposed()) {
            return;
        }
        SideExecutorHolder.es.execute(() -> {
            block3: {
                try {
                    if (display.isDisposed()) {
                        return;
                    }
                    task.run();
                }
                catch (SWTException e) {
                    if (e.code == 45) break block3;
                    throw e;
                }
            }
        });
    }

    private static abstract class SideExecutorHolder {
        static final ExecutorService es = Executors.newSingleThreadExecutor(targetRunnable -> {
            Thread thread = new Thread(targetRunnable, "Side-SWT-Queue");
            thread.setDaemon(true);
            return thread;
        });

        private SideExecutorHolder() {
        }
    }
}

